function calendar_show(date_src_value, date_selected_function)
{
    //Get the screen height and width
    var maskHeight = $(document).height();
    var maskWidth = $(window).width();

    var body = $('body');

    var calendar_bg = $('<div class="calendar_bg"></div>');
    calendar_bg.appendTo(body);
    calendar_bg.css({'width' : maskWidth, 'height' : maskHeight});

    var calendar_body = $('<div class="calendar_body"></div>');
    calendar_body.appendTo(body);

    var calendar_cleanup = function() {
        calendar_bg.children().remove();
        calendar_bg.remove();

        calendar_body.children().remove();
        calendar_body.remove();
    };

    calendar_body.not('.hasDatePicker').datepicker
    ({
        dateFormat: 'yy-mm-dd',
        defaultDate: date_src_value,
        onSelect: function(dateText, inst)
        {
            console.log("show_calendar: dateText=" + dateText);
            calendar_cleanup();
            if(undefined !== date_selected_function)
                date_selected_function(dateText);
        }
    });

    calendar_body.css
    ({
        'top': ($(window).height() - calendar_body.height()) / 2,
        'left': ($(window).width() - calendar_body.width()) / 2,
    });

    calendar_bg.on('click', function(){
        console.log("calendar_bg.on('click')");
        calendar_cleanup();
    });

    calendar_body.on('click', function(e){
        console.log("calendar_body.on('click')");
        e.preventDefault();
        return false;
    });

    calendar_bg.on('keypress', function(){
        console.log("calendar_bg.on('keypress')");
        calendar_cleanup();
    });

    calendar_bg.on('mousewheel', function(e) { e.preventDefault(); return true; });
    calendar_bg.on('scroll', function(e) { e.preventDefault(); return true; });
};

function calendar_today_str()
{
    var today = new Date();
    var dd = today.getDate();
    var mm = today.getMonth() + 1; //January is 0!
    var yyyy = today.getFullYear();

    if(dd < 10)
        dd = '0' + dd;

    if(mm < 10)
        mm = '0' + mm;

    today = yyyy + '-' + mm + '-' + dd;

    return today;
}
