function upload_thumb(event)
{
    console.log("Uploading selected");

    files = event.target.files;

    event.stopPropagation(); // Stop stuff happening
    event.preventDefault(); // Totally stop stuff happening

    $.each(files, function(key, value)
    {
        var data = new FormData();
        data.append(0, value);

        console.log("file=[" + value + "]");
        console.log("file_name=[" + value.name + "]");

        $.ajax
        ({
            url: 'upload_thumb.php',
            type: 'POST',
            data: data,
            cache: false,
            dataType: 'json',
            processData: false, // Don't process the files
            contentType: false, // Set content type to false as jQuery will tell the server its a query string request
            success: function(data, textStatus, jqXHR)
            {
                console.log("[success]=" + JSON.stringify(data));

                if(typeof data.name === 'undefined')
                {
                }
                else
                {
                    var hash = data.name;
                    $('#div_update_service').find(".UPDATE_THUMB_ENTRY").css
                    ({
                        'background-image': 'url("/watchdog.thumbs/' + hash + '")'
                    });
                    $('#div_update_service').find(".UPDATE_THUMB_ENTRY").attr('hash', hash);
                };
            },
            error: function(jqXHR, textStatus, errorThrown)
            {
                // Handle errors here
                console.log('ERRORS(2): ' + textStatus);
            },
            complete: function()
            {
                    console.log("[complete]");
            },
            xhr: function()
            {
                var xhr = new window.XMLHttpRequest();

                xhr.upload.addEventListener("progress", function(evt)
                {
                    if(evt.lengthComputable)
                    {
                        var percentComplete = Math.floor(100 * evt.loaded / evt.total);
                        console.log("xhr.progress=" + percentComplete);
                    }
                }, false);

                xhr.onreadystatechange = function ()
                {
                    console.log("xhr.readyState=[" + xhr.readyState + "]");
                };

                return xhr;
            }
        });
    });

    event.target.value = '';
    return;
};
