var StdXXXBuf_offset;

(function($) {
  $.fn.scrollToBottom = function() {
    return this.each(function (i, element) {
      $(element).scrollTop(Number.MAX_SAFE_INTEGER);
    });
  };
}(jQuery));

function StdXXXBuf_run(ptr)
{
    $.getJSON
    (
        'GetStdXXXBuf.php',
        {
            'ptr'   : ptr,
            'off'   : StdXXXBuf_offset,
        }
    )
    .done
    (
        function(curr)
        {
            if(curr['buf'] != null)
            {
                var off = StdXXXBuf_offset; StdXXXBuf_offset = curr['off'];

                console.log("StdXXXBuf_offset=" + StdXXXBuf_offset + ", buf=" + curr['buf']);

                var txt = curr['buf']['scalar'];
                txt = txt.replace(/[\r]/g, "\n").replace(/[\0]/g, "");
                $('#StdXXXBuf_block').find('pre').append(document.createTextNode(txt));

//                $('#StdXXXBuf_block').scrollToBottom();

                if($('#StdXXXBuf_block').is(":visible"))
                    setTimeout( function() { StdXXXBuf_run(ptr); }, (off == StdXXXBuf_offset) ? 1000 : 10);
            }
        }
    );
};

function StdXXXBuf_show(ptr)
{
    var pad_h = 50, pad_v = 50;
    //Get the screen height and width
    var maskHeight = $(window).height();
    var maskWidth = $(window).width();

    //Set height and width to mask to fill up the whole screen
    $('#StdXXXBuf_bg').css({'width' : maskWidth, 'height' : maskHeight});
    $('#StdXXXBuf_bg').show();

    // working window
    $('#StdXXXBuf_block').css
    ({
        'top': pad_v, //  ($(window).height() - $('#probe_block').height()) / 2,
        'left': pad_h, // ($(window).width() - $('#probe_block').width()) / 2,
        'width': (maskWidth - 3 * pad_h),
        'height': (maskHeight - 3 * pad_v)
    });
    $('#StdXXXBuf_block').show();

    StdXXXBuf_offset = 0;
    $('#StdXXXBuf_block').find('pre').text("");

    StdXXXBuf_run(ptr);
};

$(document).ready(function () {

    $('#div_head_lib').TheCoreLib_attach_monitor({'port' : '8000', 'bg' : 'static/TheCoreLib_capacity.png', 'step': 56 });

    bg_animate('div.IDLE_1280x64', 64, 0, 1280, 64, 40);

    $("body").delegate("button.REBOOT", "click", function() {

        if(!confirm("Are you sure to reboot server?"))
            return;

        $(this).prop("disabled", true);

        $.getJSON
        (
            'SetField.php',
            {
                'ptr'   : 0,
                'field' : 't_reboot',
                'val'   : 1,
            }
        );
    });

    $("body").delegate("button.SHUTDOWN", "click", function() {

        if(!confirm("Are you sure to shutdown server?"))
            return;

        $(this).prop("disabled", true);

        $.getJSON
        (
            'SetField.php',
            {
                'ptr'   : 0,
                'field' : 't_shutdown',
                'val'   : 1,
            }
        );
    });

    $("body").delegate("button.CONFIG", "click", function() {
        window.location.href = "config.html";
    });

    $("body").delegate("#main_table td.STATUS div.OUTTER div.INNER", "dblclick", function() {
        var tbody = $(this).parents('tbody').first();
        var ptr = tbody.attr('ptr');
        console.log("dbg STATUS, ptr=" + ptr);
        StdXXXBuf_show(ptr);
    });

    $("body").delegate("#StdXXXBuf_bg", 'mousewheel', function(e) { e.preventDefault(); return true; });
    $("body").delegate("#StdXXXBuf_bg", 'scroll', function(e) { e.preventDefault(); return true; });
    $("body").delegate("#StdXXXBuf_bg", "click", function() {
        $('#StdXXXBuf_block').hide();
        $('#StdXXXBuf_bg').hide();
    });

    $("body").delegate("button.ON,button.OFF,button.START,button.STOP", "click", function() {
        var f_on = $(this).hasClass('ON');
        var trg = "none";


        console.log("dbg tagName=" + $(this).parent().parent().parent().prop("tagName"));
        console.log("dbg list=" + $(this).parent().parent().parent().attr('class'));

        if($(this).parent().parent().parent().hasClass('RESPAWN'))
            trg = "f_respawn";
        else if($(this).parent().parent().parent().hasClass('AUTORUN'))
            trg = "f_autorun";
        else if($(this).parent().parent().parent().hasClass('START_STOP'))
        {
            f_on = 1;

            if($(this).hasClass('START'))
                trg = "t_run";
            else if($(this).hasClass('STOP'))
                trg = "t_term";
        };

        $(this).addClass('template');
        $(this).parent().find('button.IDLE').removeClass('template');

        var ptr = $(this).parent().parent().parent().parent().parent().attr('ptr');

        console.log("f_on=" + f_on + ", trg=" + trg + ", ptr=" + ptr);

        $.getJSON
        (
            'SetField.php',
            {
                'ptr'   : ptr,
                'field' : trg,
                'val'   : (1 - f_on),
            }
        );
    });


    GetStatus();
});
