(function($) {
  $.fn.scrollToBottom = function() {
    return this.each(function (i, element) {
      $(element).scrollTop(Number.MAX_SAFE_INTEGER);
    });
  };
}(jQuery));

var bridge_probe_xhr = null;

function bridge_probe_run(body)
{
    $.ajax
    ({
        xhr: function()
        {
            bridge_probe_xhr = new window.XMLHttpRequest();

            //Upload progress
            bridge_probe_xhr.upload.addEventListener("progress", function(evt)
            {
                if (evt.lengthComputable)
                {
                    var percentComplete = evt.loaded / evt.total;
                    //Do something with upload progress
                    console.log(percentComplete);
                }
            }, false);

            //Download progress
            bridge_probe_xhr.addEventListener("progress", function(evt)
            {
                console.log("xhr.progress:  evt.loaded=" + evt.loaded);

                if (evt.lengthComputable)
                {
                    var percentComplete = evt.loaded / evt.total;
                    //Do something with download progress
                    console.log("xhr.progress:  percentComplete=" + percentComplete);
                }
            }, false);

            bridge_probe_xhr.onreadystatechange = function ()
            {
                console.log("xhr.readyState=[" + bridge_probe_xhr.readyState + "]");

                if((bridge_probe_xhr.readyState == 4) || (bridge_probe_xhr.readyState == 3))
                {
                    if (bridge_probe_xhr.responseText)
                    {
                        $('#bridge_probe_block').find('pre')
                            .text(bridge_probe_xhr.responseText.replace(/[\r]/g, "\n").replace(/[\0]/g, ""));

//                        $('#bridge_probe_block').scrollToBottom();
                    }
                }
            };

            return bridge_probe_xhr;
        },
        type: 'POST',
        url: "bridge-probe.cgi",
        cache: false,
        dataType: 'text',
        data:
        {
            'body' : body,
        },
        success: function(data)
        {
            console.log("success");
        }
    });
};

function bridge_probe_start(body)
{
    var pad_h = 50, pad_v = 50;
    //Get the screen height and width
    var maskHeight = $(window).height();
    var maskWidth = $(window).width();

    //Set height and width to mask to fill up the whole screen
    $('#bridge_probe_bg').css({'width' : maskWidth, 'height' : maskHeight});
    $('#bridge_probe_bg').show();

    // working window
    $('#bridge_probe_block').css
    ({
        'top': pad_v, //  ($(window).height() - $('#probe_block').height()) / 2,
        'left': pad_h, // ($(window).width() - $('#probe_block').width()) / 2,
        'width': (maskWidth - 3 * pad_h),
        'height': (maskHeight - 3 * pad_v)
    });
    $('#bridge_probe_block').show();

    $('#bridge_probe_block').find('pre').text("");

    bridge_probe_run(body);
};

function set_bridge(br_data)
{
    var br_area = $('#div_update_service').find(".BRIDGE_CONFIG_AREA");
    br_area.empty();

    var br_item = $("body div.bridge_item").clone();
    br_item.removeClass('template');
    br_item.attr('id', 'bridge_item');
    br_item.appendTo(br_area);

    if(br_data == "")
        br_data = {};
    else
        br_data = JSON.parse(br_data);

    $("#bridge_item").bridge_init(br_data);

    $('#bridge_item').delegate(".manual_bridge", "click", function() {
        var body = JSON.stringify($('#bridge_item').save_bridge());
        body = prompt("Manual bridge configuration:", body);
        if(body != null)
            set_bridge(body);
    });

    $('#bridge_item').delegate(".probe_bridge", "click", function() {
        var body = JSON.stringify($('#bridge_item').save_bridge());
        bridge_probe_start(body);
    });

};

function div_update_service_set(curr)
{
    /* setup text fields */
    $('#div_update_service').find("input[name='id']").val(curr['id']);
    $('#div_update_service').find("input[name='id_name']").val(curr['id_name']);
    $('#div_update_service').find("input[name='ptr']").val(curr['ptr']);
    $('#div_update_service').find("input[name='alias']").val(curr['alias']);
    $('#div_update_service').find("input[name='config']").val(curr['config']);
    $('#div_update_service').find("input[name='bin_path']").val(curr['bin_path']);
    $('#div_update_service').find("input[name='numa_bind']").val(curr['numa_bind']);
    $('#div_update_service').find("textarea[name='envs']").val(curr['envs'].join("\n"));
    $('#div_update_service').find("textarea[name='raws']").val(curr['raws'].join("\n"));

    console.log("div_update_service_set: curr['id_name']=" + curr['id_name']);

    /* put bridge specific config */
    if("bridge" == curr['id_name'])
    {
        $('#div_update_service').find("input[name='config']").hide();
        $('#div_update_service').find("textarea[name='envs']").hide();

        $('#div_update_service').find(".title_env_area").hide();
        $('#div_update_service').find(".title_config").hide();

        set_bridge($('#div_update_service').find("textarea[name='raws']").val());
    }
    else
    {
        $('#div_update_service').find(".BRIDGE_CONFIG_AREA").empty();

        $('#div_update_service').find("input[name='config']").show();
        $('#div_update_service').find("textarea[name='envs']").show();

        $('#div_update_service').find(".title_env_area").show();
        $('#div_update_service').find(".title_config").show();
    };

    /* thumb upload handler */
    $('#div_update_service').find(".UPDATE_THUMB_ENTRY").attr('hash', curr['thumb']);
    if(curr['thumb'] != '')
    {
        $('#div_update_service').find(".UPDATE_THUMB_ENTRY").css
        ({
            'background-image': 'url("/watchdog.thumbs/' + curr['thumb'] + '")'
        });
    }
    else
    {
        $('#div_update_service').find(".UPDATE_THUMB_ENTRY").css
        ({
            'background-image': ''
        });
    };

    /* setup icon */
    var anch = $('#div_update_service').find('td.logo_place');
    var tmpl = $('#div_select_service').find('.APP_ADD_SELECTOR.template').clone();
    tmpl.removeClass('template');
    tmpl.find('div.APP_ADD_SELECTOR_2').addClass('ICON_APP2_DISABLED_' + curr['id_name'].toUpperCase());
    tmpl.find('div.APP_ADD_SELECTOR_3').text(curr['id_name'].toUpperCase().replace(/_/g, ' '));
    anch.empty();
    tmpl.appendTo(anch);
////    window.scrollTo(0, 0);
};

/*
    0 - services list
    1 - apps list select
    2 - service item edit
*/
var config_view_prev = -1;
function switch_config_view(v)
{
    /* save scroll position */
////    if(0 == v)
////        window.scrollTo(0, 0);

    /* hide control buttons */
    $('button.ADD').addClass('template');
    $('button.OPER').addClass('template');
    $('button.ADD_CANCEL').addClass('template');
    $('button.ADD_NEXT').addClass('template');
    $('button.ADD_SAVE').addClass('template');

    // hide areas
    $('#div_table').addClass('template');
    $('#div_select_service').addClass('template');
    $('#div_update_service').addClass('template');

    /* services list */
    if(0 == v)
    {
        $('#div_table').removeClass('template');
        $('button.ADD').removeClass('template');
        $('button.OPER').removeClass('template');
    }
    /* apps list select */
    else if(1 == v)
    {
        $('button.ADD_CANCEL').removeClass('template');
        $('button.ADD_NEXT').removeClass('template');
        $('#div_select_service').removeClass('template');
    }
    /* service item edit */
    else if(2 == v)
    {
        $('button.ADD_CANCEL').removeClass('template');
        $('button.ADD_SAVE').removeClass('template');
        $('#div_update_service').removeClass('template');
    };

    /* save previously set state */
    config_view_prev = v;
};

$(document).ready(function () {

    $('#div_head_lib').TheCoreLib_attach_monitor({'port' : '8000', 'bg' : 'static/TheCoreLib_capacity.png', 'step': 56 });

    bg_animate('div.IDLE_1280x64', 64, 0, 1280, 64, 40);

    $("body").delegate("button.ITEM_BUTTON_UP,button.ITEM_BUTTON_DOWN,button.ITEM_BUTTON_DELETE,button.ITEM_BUTTON_CLONE", "click", function() {
        var tbody = $(this).parents('tbody').first();
        var ptr = tbody.attr('ptr');
        var f = 'none';

        if($(this).hasClass('ITEM_BUTTON_UP'))
            f = 't_up';
        else if($(this).hasClass('ITEM_BUTTON_DOWN'))
            f = 't_down';
        else if($(this).hasClass('ITEM_BUTTON_CLONE'))
            f = 't_clone';
        else if($(this).hasClass('ITEM_BUTTON_DELETE'))
        {
            if(!confirm("Are you sure to delete?"))
                return;
            f = 't_del';
        };

        $.getJSON
        (
            'SetField.php',
            {
                'ptr'   : ptr,
                'field' : f,
                'val'   : '1',
            }
        )
        .done
        (
            function(curr)
            {
                GetStatusSingle();
                switch_config_view(0);
            }
        );

    });

    $("body").delegate("button.ITEM_BUTTON_EDIT", "click", function() {
        var tbody = $(this).parents('tbody').first();
        var ptr = tbody.attr('ptr');

        console.log("button.ITEM_BUTTON_EDIT: ptr=" + ptr);

        $.getJSON
        (
            'GetItem.php',
            {
                'ptr'   : ptr,
            }
        )
        .done
        (
            function(curr)
            {
                console.log("edit_item: curr=" + JSON.stringify(curr));
                if(curr.hasOwnProperty('ptr'))
                {
                    div_update_service_set(curr);
                    switch_config_view(2);
                }
            }
        );
    });

    $("body").delegate("button.OPER", "click", function() {
        window.location.href = "index.html";
    });

    $("body").delegate("button.ADD_CANCEL", "click", function() {
        switch_config_view(0);
    });

    $("body").delegate("button.ADD_SAVE", "click", function() {

        console.log('button.ADD_SAVE');

        $("#bridge_item").each(function(index){
            $('#div_update_service').find("textarea[name='raws']")
                .val(JSON.stringify($('#bridge_item').save_bridge()));
        });

        $.getJSON
        (
            'SetItem.php',
            {
                'id':           $('#div_update_service').find("input[name='id_name']").val(),
                'ptr':          $('#div_update_service').find("input[name='ptr']").val(),
                'alias':        $('#div_update_service').find("input[name='alias']").val(),
                'thumb':        $('#div_update_service').find(".UPDATE_THUMB_ENTRY").attr('hash'),
                'config':       $('#div_update_service').find("input[name='config']").val(),
                'bin_path':     $('#div_update_service').find("input[name='bin_path']").val(),
                'numa_bind':    $('#div_update_service').find("input[name='numa_bind']").val(),
                'raws':         $('#div_update_service').find("textarea[name='raws']")
                                    .val().replace("\r", "\n").split("\n")
                                    .filter(function(n){ return n != "" }),
                'envs':         $('#div_update_service').find("textarea[name='envs']")
                                    .val().replace("\r", "\n").split("\n")
                                    .filter(function(n){ return n != "" }),
            }
        )
        .done
        (
            function(curr)
            {
                GetStatusSingle();
                switch_config_view(0);
            }
        );
    });

    $("body").delegate("button.ADD_NEXT", "click", function() {
        var app_idx = -1;
        var app_id = "";

        $('#div_select_service').find('div.APP_ADD_SELECTOR:not(.template)').each(function(index){
            if($(this).hasClass('APP_ADD_SELECTOR_SELECTED'))
            {
                app_idx = $(this).attr('app_idx');
                app_id = $(this).attr('app_id');
            };
        });

        console.log("button.ADD_NEXT: app_idx=" + app_idx + ", app_id=" + app_id);

        if(-1 != app_idx)
        {
            var item =
            {
                'id_name': app_id,
                'id': app_idx,
                'ptr':0,
                'alias':'',
                'config':'',
                'bin_path':'',
                'numa_bind':'',
                'raws':[],
                'envs':[]
            };

            div_update_service_set(item);

            switch_config_view(2);
        };
    });

    $("body").delegate("div.APP_ADD_SELECTOR", "click", function() {
        if(!$(this).hasClass('APP_ADD_SELECTOR_SELECTED'))
        {
            $('#div_select_service').find('div.APP_ADD_SELECTOR:not(.template)').each(function(index){
                $(this).removeClass('APP_ADD_SELECTOR_SELECTED');
            });

            $(this).addClass('APP_ADD_SELECTOR_SELECTED');
        };
        console.log("HERE");
    });

    $("body").delegate("button.ADD", "click", function() {

        // clear area
        $('#div_select_service').find('div.APP_ADD_SELECTOR:not(.template)').each(function(index){
            $(this).remove();
        });

        switch_config_view(1);

        $.getJSON
        (
            'GetApps.php',
            {
            }
        )
        .done
        (
            function(state)
            {
                var i;
                var list = state['apps'];

                var anch = $('#div_select_service').find('.APP_ADD_SELECTOR.template');

                for(i = 0; i < list.length; i++)
                {
                    var tmpl = anch.clone();
                    tmpl.removeClass('template');
                    tmpl.attr('app_idx', i);
                    tmpl.attr('app_id', list[i]);
                    tmpl.find('div.APP_ADD_SELECTOR_2').addClass('ICON_APP2_DISABLED_' + list[i].toUpperCase());
                    tmpl.find('div.APP_ADD_SELECTOR_3').text(list[i].toUpperCase().replace(/_/g, ' '));
                    tmpl.appendTo($('#div_select_service'));
                };
            }
        )
        .fail
        (
            function(data)
            {
                console.log("FAIL: data=" + data);
            }
        );


    });

    $("body").delegate("#bridge_probe_bg", 'mousewheel', function(e) { e.preventDefault(); return true; });
    $("body").delegate("#bridge_probe_bg", 'scroll', function(e) { e.preventDefault(); return true; });
    $("body").delegate("#bridge_probe_bg", "click", function() {
        if(bridge_probe_xhr != null)
        {
            bridge_probe_xhr.abort();
            bridge_probe_xhr = null;
        }
        $('#bridge_probe_block').hide();
        $('#bridge_probe_bg').hide();
    });

    GetStatusSingle();

    switch_config_view(0);

    $(document).delegate('#upload_thumb', 'change', upload_thumb);

    $('#div_update_service').find(".UPDATE_THUMB_ENTRY").on("click", function(e){
        $("#upload_thumb").trigger("click");
    });
    $('#div_update_service').find(".CLEAR_THUMB_ENTRY").on("click", function(e){
        $('#div_update_service').find(".UPDATE_THUMB_ENTRY").css
        ({
            'background-image': ''
        });
        $('#div_update_service').find(".UPDATE_THUMB_ENTRY").attr('hash', '');
    });

});
