var offset = 0;

function bg_animate(sel, x_step, y_step, width, height, interval)
{
    var x_curr = 0, y_curr = 0;

    window.setInterval
    (
        function()
        {
            $('' + sel).css('background-position', '' +  (-x_curr) + 'px ' + (-y_curr) + 'px');
            $('' + sel).css('background-position-x', (-x_curr) + 'px');
            $('' + sel).css('background-position-y', (-y_curr) + 'px');

            x_curr += x_step;

            if(x_curr >= width)
            {
                x_curr = 0;
                y_curr = y_step;
            };

            if(y_curr >= height)
            {
                y_curr = 0;
            };
        },
        interval
    );

};

var timer = null;

function GetStatus()
{
    timer = null;

    $.getJSON
    (
        'GetStatus.php',
        {
        }
    )
    .done
    (
        function(state)
        {
            update_ui(state);
            timer = window.setTimeout(GetStatus, 1000);
        }
    )
    .fail
    (
        function(data)
        {
            console.log("FAIL: data=" + data);
            update_ui({});
            timer = window.setTimeout(GetStatus, 2000);
        }
    );
};

function GetStatusSingle()
{
    timer = null;

    $.getJSON
    (
        'GetStatus.php',
        {
        }
    )
    .done
    (
        function(state)
        {
            update_ui(state);
        }
    )
    .fail
    (
        function(data)
        {
            console.log("FAIL: data=" + data);
        }
    );
};

function format_time(t_sec)
{
    var ret = "/";

    if(t_sec > (24 * 3600))
    {
        var t_days = Math.floor(t_sec / (24 * 60 * 60));
        t_sec = t_sec % (24 * 60 * 60);
        ret += " " + t_days + " days";
    };

    if(t_sec > 3600)
    {
        var t_hours = Math.floor(t_sec / (60 * 60));
        t_sec = t_sec % (60 * 60);
        ret += " " + t_hours + " hours";
    };

    if(t_sec > 60)
    {
        var t_mins = Math.floor(t_sec / (60));
        t_sec = t_sec % 60;
        ret += " " + t_mins + " mins";
    };

    ret += " " + t_sec + " seconds /";

    return ret;
};

function apps_list_timings_update(tbody, item)
{
    var td = tbody.find('td.STATUS div.OUTTER div.INNER');

    td.find('span.ELAPSED').text(format_time(item['terminated']));
    td.find('span.UPTIME').text(format_time(item['started']));
};

function app_icon_set(td, item)
{
    /* get classes list */
    var classes = td.attr('class').split(/\s+/);

    /* enum and drop unused classes */
    $.each(classes, function(index, item)
    {
//        console.log('classes['+index+']=' + item);
//        console.log('classes1['+index+']=' + item.substr(0, 9));

        if ('ICON_APP_' === item.substr(0, 9))
        {
//            console.log('will drop: ' + item);
            td.removeClass(item);
        }
    });

    /* compose class name */
    td.css
    ({
        'background-image': ''
    });
    if(item['thumb'] != '')
    {
        td.css
        ({
            'background-image': 'url("/watchdog.thumbs/' + item['thumb'] + '")'
        });
    }
    else
        td.addClass('ICON_APP_' + (item['f_autorun'] == 0 ? 'DISABLED_' : 'ENABLED_') + item['app_name'].toUpperCase());
}

function apps_list_item_update(tbody, item)
{
//    console.log("apps_list_item_update: item=" + JSON.stringify(item));

    if(tbody.attr('amend') == null || tbody.attr('amend') != item['amend'] || tbody.attr('ptr') != item['ptr'])
    {
        var td;

//        console.log("apps_list_item_update: HERE");

        tbody.attr('amend', item['amend']);
        tbody.attr('ptr', item['ptr']);

        td = tbody.find('td.ALIAS div.OUTTER div.INNER div.CONTENT');
        td.text(item['alias']);
        app_icon_set(td, item);

        td = tbody.find('td.AUTORUN div.OUTTER div.INNER');
        td.find('button').addClass('template');
        td.find(item['f_autorun'] ? 'button.ON' : 'button.OFF').removeClass('template');

        td = tbody.find('td.RESPAWN div.OUTTER div.INNER').first();
        td.find('button').addClass('template');
        td.find(item['f_respawn'] ? 'button.ON' : 'button.OFF').removeClass('template');

        td = tbody.find('td.START_STOP div.OUTTER div.INNER');
        td.find('button').addClass('template');
        td.find((item['pid'] != 0) ? 'button.STOP' : 'button.START').removeClass('template');

        td = tbody.find('td.STATUS div.OUTTER div.INNER');
        td.find('div.CONTENT').addClass('template');

        if(item['pid'] == 0)
        {
            if(item['err'] != '')
            {
                td.find('div.ERROR').removeClass('template');
                td.find('span.MESSAGE').text(item['err']);
            };
        }
        else
        {
            td.find('span.PID').text(item['pid']);

            if(item['terminated'] != 0)
            {
                td.find('div.TERMINATING').removeClass('template');
            }
            else
            {
                td.find('div.RUNNING').removeClass('template');
            };
        };
    };

    apps_list_timings_update(tbody, item)
};

function apps_list_cleanup()
{
    $('#main_table tbody:not(.idle, .template)').each(function(index){
        $(this).remove();
    });

    $('#main_table tbody.idle').each(function(index){
        $(this).addClass('template');
    });
};

var last = {};

function update_ui(curr)
{
//    console.log("update_ui: curr=" + JSON.stringify(curr));

    if(curr.hasOwnProperty('version'))
        $('span.VERSION').text(curr['version']);
    if(curr.hasOwnProperty('instance_name'))
        $('span.INSTANCE_NAME').text(curr['instance_name']);

    if(curr.hasOwnProperty('amend'))
    {
        // hide idler
        if(!last.hasOwnProperty('amend'))
            $('#main_table tbody.idle').each(function(index){
                $(this).addClass('template');
            });

        //
        if(!last.hasOwnProperty('amend') || last['amend'] != curr['amend'])
        {
            var i;

            console.log("update_ui: curr=" + JSON.stringify(curr));

            // goto online
            console.log("update_ui: new amend=" + curr['amend'] + ", list.length=" + curr['list'].length);

            /* recreate a list */
            if(!last.hasOwnProperty('list') || last['list'].length != curr['list'].length)
            {
                // cleanup
                apps_list_cleanup();

                // append all items
                var tbody = $('#main_table tbody.template:not(.idle)').clone();
                tbody.removeClass('template');
                for(i = 0; i < curr['list'].length; i++)
                    tbody.clone().insertBefore($('#main_table tfoot'));
            };

            /* header update */
        };

        //
        $('#main_table tbody:not(.idle, .template)').each(function(index){
            apps_list_item_update($(this), curr['list'][index]);
        });
    }
    else
    {
        if(last.hasOwnProperty('amend'))
        {
            $('#main_table tbody.idle').each(function(index){
                $(this).removeClass('template');
            });

            // goto offline
            console.log("update_ui: offline");

            // cleanup
            $('#main_table tbody:not(.idle, .template)').each(function(index){
                $(this).remove();
            });
        };
    };

    last = curr;
};
