(function( $ )
{
    $.fn.output_video_codec_select = function(params)
    {
        var select = this;
        var parent = this.parents('div.output_video_codec_attrs');
        var codec = params['codec'];

        console.log("$.fn.output_video_codec_select");

        $(this).change(function() {
            var p = $(select).parent();
            var b = $(select).find("option:selected").first().val();
            console.log("$.fn.output_video_codec_select: CHANGED=" + b);

            if('none' == b)
            {
                p.find('.output_video_codec_bitstream').hide();
                p.find('.output_video_codec_filter').hide();
                p.find('.output_video_codec_encoding').hide();
                p.find('.output_video_codec_encoding_opt').hide();
            }
            else if('copy' == b)
            {
                p.find('.output_video_codec_bitstream').show();
                p.find('.output_video_codec_filter').hide();
                p.find('.output_video_codec_encoding').hide();
                p.find('.output_video_codec_encoding_opt').hide();
            }
            else if('empty' == b)
            {
                p.find('.output_video_codec_bitstream').hide();
                p.find('.output_video_codec_filter').show();
                p.find('.output_video_codec_encoding').hide();
                p.find('.output_video_codec_encoding_opt').show();
            }
            else
            {
                p.find('.output_video_codec_bitstream').hide();
                p.find('.output_video_codec_filter').show();
                p.find('.output_video_codec_encoding').show();
                p.find('.output_video_codec_encoding_opt').show();
            }

//            mode_id_select.input_mode_id_select(b, mode_value);
        });

        $.getJSON
        (
            'bridge-helper.cgi',
            {
                'action' : 'video_encoders'
            }
        )
        .done
        (
            function(curr)
            {
                var i;
                console.log("$.fn.output_video_codec_select: items=" + curr.length);

                /* filter out support codecs */
                $(select).find('option').each(function(index)
                {
                    if($(this).text() == "")
                    {
                        console.log("will ask for support=" + $(this).attr('value'));
                        for(i = 0; i < curr.length; i++)
                            if(curr[i]['codec'] == $(this).attr('value'))
                                $(this).text(curr[i]['title']);

                        if($(this).text() == "")
                            $(this).remove();
                    };
                });

                /* setup codec */
                i = -1;
                $(select).find('option').each(function(index)
                {
                    if($(this).attr('value') == codec)
                    {
                        $(this).attr('selected', 'selected');
                        i = index;
                    };
                });

                /* set default codec */
                if(-1 == i)
                    $(select).find('option').first().attr('selected', 'selected');

                /* notify changing */
                $(select).change();
            }
        );

        var fields = ["bsf:v", "map", "vf", "minrate", "vb", "maxrate", "a53cc", "profile:v", "level:v", "qscale:v", "preset:v", "bf", "g", "keyint_min"];
        for(var i = 0; i < fields.length; i++)
            parent.find("input[name='" + fields[i] + "']").val(params[fields[i]]);

        /* setup optional codecs list */
        var optional_video_codec_params_list = [];
        parent
            .find('.output_video_codec_encoding_opt')
            .find('.optional_video_codec_param_item')
            .each(function(index)
            {
                $(this).optional_video_codec_param_setup(params, optional_video_codec_params_list);
            });
        parent
            .find('.output_video_codec_encoding_opt')
            .find('.video_codec_opt')
            .ddm_attach
            ({
                'class': 'optional_video_codec_params_list',
                'items': optional_video_codec_params_list,
                'cookie': null,
                'cb': function(idx, a, c) { a.css('display', 'inline-block'); }
            });
    };

    $.fn.optional_video_codec_param_collect = function(params)
    {
        var top = this;

        console.log("$.fn.optional_video_codec_param_collect");

        if(top.css('display') == 'none')
            return;

        var block = $(this).find(".codec_attr_holder").find("select,input").first();

        if(block === undefined)
            return;

        var name = block.attr('name');
        var val = block.val();
        console.log("$.fn.optional_video_codec_param_collect: name=[" + name + "], val=[" + val + "]");

        if(val != "")
            params[name] = val;
    };

    $.fn.optional_protocol_param_collect = function(params)
    {
        var top = this;

        console.log("$.fn.optional_protocol_param_collect");

        if(top.css('display') == 'none')
            return;

        var block = $(this).find(".protocol_attr_holder").find("select,input").first();

        if(block === undefined)
            return;

        var name = block.attr('name');
        var val = block.val();
        console.log("$.fn.optional_protocol_param_collect: name=[" + name + "], val=[" + val + "]");

        if(val != "")
            params[name] = val;
    };

    $.fn.optional_video_codec_param_setup = function(params, list)
    {
        var top = this;
        var display = 'none';

        console.log("$.fn.optional_video_codec_param_setup");

        var block = $(this).find(".codec_attr_holder").find("select,input").first();

        if(block !== undefined)
        {
            var name = block.attr('name');

            console.log("$.fn.optional_video_codec_param_setup: block.name=" + name);

            var title = block.parent().find('.input_field_title').first();
            if(title !== undefined)
            {
                var t = title.text();
                console.log("$.fn.optional_video_codec_param_setup: title=" + t);
                list.push
                ({
                    'text' : t,
                    'cookie': top,
                    'class': 'optional_video_codec_params_item',
                });
            };

            if(params[name] !== undefined)
            {
                console.log("$.fn.optional_video_codec_param_setup: " + params[name]);
                block.setval(params[name]);
                display = 'inline-block';
            }
            else
                console.log("$.fn.optional_video_codec_param_setup: not in optional list");
        };

        top.css('display', display);
    };

    $.fn.optional_protocol_param_setup = function(params, list)
    {
        var top = this;
        var display = 'none';

        console.log("$.fn.optional_protocol_param_setup");

        var block = $(this).find(".protocol_attr_holder").find("select,input").first();

        if(block !== undefined)
        {
            var name = block.attr('name');

            console.log("$.fn.optional_protocol_param_setup: block.name=" + name);

            var title = block.parent().find('.input_field_title').first();
            if(title !== undefined)
            {
                var t = title.text();
                console.log("$.fn.optional_protocol_param_setup: title=" + t);
                list.push
                ({
                    'text' : t,
                    'cookie': top,
                    'class': 'optional_protocol_params_item',
                });
            };

            if(params[name] !== undefined)
            {
                console.log("$.fn.optional_protocol_param_setup: " + params[name]);
                block.setval(params[name]);
                display = 'inline-block';
            }
            else
                console.log("$.fn.optional_protocol_param_setup: not in optional list");
        };

        top.css('display', display);
    };

    $.fn.output_audio_codec_select = function(params)
    {
        var select = this;
        var parent = this.parents('div.output_audio_codec_attrs');
        var codec = params['codec'];

        console.log("$.fn.output_audio_codec_select");

        $(this).change(function() {
            var p = $(select).parent();
            var b = $(select).find("option:selected").first().val();
            console.log("$.fn.output_audio_codec_select: CHANGED=" + b);

            if('none' == b)
            {
                p.find('.output_audio_codec_bitstream').hide();
                p.find('.output_audio_codec_filter').hide();
                p.find('.output_audio_codec_encoding').hide();
            }
            else if('copy' == b)
            {
                p.find('.output_audio_codec_bitstream').show();
                p.find('.output_audio_codec_filter').hide();
                p.find('.output_audio_codec_encoding').hide();
            }
            else if('empty' == b)
            {
                p.find('.output_audio_codec_bitstream').hide();
                p.find('.output_audio_codec_filter').show();
                p.find('.output_audio_codec_encoding').hide();
            }
            else
            {
                p.find('.output_audio_codec_bitstream').hide();
                p.find('.output_audio_codec_filter').show();
                p.find('.output_audio_codec_encoding').show();
            }

        });

        $.getJSON
        (
            'bridge-helper.cgi',
            {
                'action' : 'audio_encoders'
            }
        )
        .done
        (
            function(curr)
            {
                var i;
                console.log("$.fn.output_audio_codec_select: items=" + curr.length);

                /* filter out support codecs */
                $(select).find('option').each(function(index)
                {
                    if($(this).text() == "")
                    {
                        console.log("will ask for support=" + $(this).attr('value'));
                        for(i = 0; i < curr.length; i++)
                            if(curr[i]['codec'] == $(this).attr('value'))
                                $(this).text(curr[i]['title']);

                        if($(this).text() == "")
                            $(this).remove();
                    };
                });

                /* setup codec */
                i = -1;
                $(select).find('option').each(function(index)
                {
                    if($(this).attr('value') == codec)
                    {
                        $(this).attr('selected', 'selected');
                        i = index;
                    };
                });

                /* set default codec */
                if(-1 == i)
                    $(select).find('option').first().attr('selected', 'selected');

                /* notify changing */
                $(select).change();
            }
        );

        var fields = ["bsf:a", "map", "af", "ab", "ac", "ar"];
        for(var i = 0; i < fields.length; i++)
            parent.find("input[name='" + fields[i] + "']").val(params[fields[i]]);

    };

    $.fn.renum_outputs = function(arr)
    {
        var par = null;

        if($(this).hasClass('outputs'))
            par = this;
        else
            par = $(this).parents('div.outputs');

        if(par != null)
        {
            $(par).find('div.input_field_title.output_item_title span.output_item_title_id').each(function(index)
            {
                $(this).text(index);
            });
        };
    };

    $.fn.set_format = function(f, par, item)
    {
        console.log("$.fn.set_format: f=" + f);
    };

    $.fn.output_url_collect = function(item)
    {
        /* save output filename */
        item['y'] = $(this).find("input[name='y']").val();

        var protocol_params = {};

        $(this)
            .find('.optional_protocol_param_item')
            .each(function(index)
            {
                $(this).optional_protocol_param_collect(protocol_params);
            });

        item['protocol_params'] = protocol_params;
    };

    $.fn.output_url_setup = function(item)
    {
        /* setup output filename - y */
        $(this).find("input[name='y']").val(item['y']);

        /* setup optional protocol list */
        var optional_protocol_params_list = [];
        $(this)
            .find('.optional_protocol_param_item')
            .each(function(index)
            {
                $(this).optional_protocol_param_setup(
                    (item['protocol_params'] !== undefined)?item['protocol_params']:[],
                    optional_protocol_params_list);
            });
        $(this)
            .find('.protocol_opt')
            .ddm_attach
            ({
                'class': 'optional_protocol_params_list',
                'items': optional_protocol_params_list,
                'cookie': null,
                'cb': function(idx, a, c) { a.css('display', 'inline-block'); }
            });
    };

    $.fn.new_format = function(lst)
    {
        console.log("$.fn.new_format: length=" + lst.length);

        var par = $(this).find("div.formats");;
//        console.log("$.fn.new_format: par.html()=" + par.html());
        var obj = $(par).find("div.format_item.template").clone();
//        console.log("$.fn.new_format: obj=" + obj.html());
        obj.removeClass('template');

        for(var i = 0; i < lst.length; i++)
        {
            var flds =
            {
                'mxf'           : ['signal_standard'],
                'hls'           : ['hls_flags', 'hls_list_size', 'hls_time', 'use_localtime', 'hls_segment_filename', 'flush_packets'],
                'mpegts'        : ['metadata@service_provider', 'metadata@service_name'],
                'libndi_newtek' : ['clock_audio', 'clock_video', 'video_queue', 'audio_queue'],
                'dash'          : ['window_size', 'extra_window_size', 'remove_at_exit', 'flush_packets'],
                'flv'           : ['flvflags', 'flush_packets'],
                'decklink'      : ['preroll'],
                'stream_segment': ['segment_time', 'segment_format', 'segment_atclocktime', 'strftime',
                                    'flush_packets', 'metadata@service_provider', 'metadata@service_name',
                                    'segment_list_type', 'segment_list', 'segment_format_options', 'increment_tc',
                                    'reset_timestamps', 'timecode'],
            };

            var j = obj.clone();

            console.log("$.fn.new_format [" + i + "]");

            j.delegate(".del_format", "click", function()
            {
                var o = $(this).parents("div.format_item").first();
                console.log("del_format");
                o.remove();
            });

            j.find("div.format_name_decklink select[name='output_board']").decklink_output_board_id_select
                ((lst[i]['f'] == 'decklink') ? lst[i]['y'] : '');

            j.find("div.format_name_thecoreelements select[name='thecoreelements_input_select']").setval
                ((lst[i]['f'] == 'thecoreelements') ? lst[i]['y'] : '0');

            j.find("div.format_name_non_decklink").output_url_setup(lst[i]);

            $.each(flds[lst[i]['f']], function(index, value){
                j.find("div.format_name_" + lst[i]['f'] + " input[name='" + value + "'], "
                + "div.format_name_" + lst[i]['f'] + " select[name='" + value + "']")
                .first().setval((typeof lst[i][value] === 'undefined')?'':lst[i][value]);
            });

            /* select setup */
            var select = j.find("select[name='format_select']"); //.set_format_select(j, lst[i]);
            $(select).change(function() {
                var b = $(this).find("option:selected").first().val();
                var p = $(this).parents("div.format_item");

                console.log("$.fn.new_format: CHANGED=" + b);
                p.find("div.format_name").hide();
                p.find("div.format_name_" + b).show();

                if(b == 'decklink' || b == 'thecoreelements')
                    p.find("div.format_name_non_decklink").hide();
                else
                    p.find("div.format_name_non_decklink").show();
            });

            var i0 = -1;

            $(select).find('option').each(function(index)
            {
                if($(this).attr('value') == lst[i]['f'])
                {
                    $(this).attr('selected', 'selected');
                    i0 = index;
                };
            });

            if(-1 == i0)
                $(select).find('option').first().attr('selected', 'selected');

            /* notify changing */
            $(select).change();

            par.append(j);
        };
    };

    $.fn.new_output = function(arr)
    {
        var par = this;

        var obj = $(this).find('.output_item.template').clone();
        obj.removeClass('template');

        for(var i = 0; i < arr.length; i++)
        {
            var j = obj.clone();

            par.append(j);

            j.delegate(".del_output", "click", function()
            {
                var o = $(this).parents("div.output_item").first();
                console.log("del_output");
                o.remove();
                par.renum_outputs();
            });

            j.find("div.output_video_codec_attrs select[name='output_video_codec_select']")
                .output_video_codec_select((typeof arr[i]['video'] === 'undefined')
                    ? {"codec" : "copy", "map" : "0:v"}
                    : arr[i]['video']);

            // audios
            if(typeof arr[i]['audios'] === 'undefined')
            {
                j.find("div.output_audio_codec_attrs select[name='output_audio_codec_select']")
                    .output_audio_codec_select((typeof arr[i]['audio'] === 'undefined')
                        ? {"codec" : "copy", "map" : "0:a"}
                        : arr[i]['audio']);
            }
            else
            {
                var a_tmpl = j.find("div.output_audio_codec_attrs").first();
                var a_anch = a_tmpl;

                a_tmpl.addClass("template");

                console.log("arr[i]['audios'].length=" + arr[i]['audios'].length);

                for(var a_idx = 0; a_idx < arr[i]['audios'].length; a_idx++)
                {
                    var a_clone = a_tmpl.clone();
                    a_clone.removeClass("template");
                    a_clone.insertAfter(a_anch);
                    a_clone
                        .find("select[name='output_audio_codec_select']")
                        .output_audio_codec_select(arr[i]['audios'][a_idx]);
                    a_clone
                        .find(".audio_track_index")
                        .text("#" + a_idx);
                    a_anch = a_clone;
                };
            };

            j.find("button.new_format").ddm_attach
            ({
                'class': 'new_format_preset_list',
                'items': new_format_preset_list,
                'cookie': j.find("button.new_format").parents("div.output_item"),
                'cb': function(idx, a, c) { c.new_format([a]); }
            });

            j.new_format((typeof arr[i]['formats'] === 'undefined') ? [] : arr[i]['formats']);
        };

        par.renum_outputs();
    };

    $.fn.new_filter_complex = function(arr)
    {
        var par = this;

        var obj = $(this).find('.filter_complex_item.template').clone();
        obj.removeClass('template');

//        if(typeof arr !== 'undefined')
        for(var i = 0; i < arr.length; i++)
        {
            var j = obj.clone();
            j.find("input[name='filter_complex_item']").val(arr[i]);
            par.append(j);
        };
    };

    $.fn.input_mode_id_select = function(board_value, mode_value)
    {
        var select = this;

        $.getJSON
        (
            'bridge-helper.cgi',
            {
                'action' : 'decklink_list_formats',
                'device' : board_value,
            }
        )
        .done
        (
            function(curr)
            {
                var i;

//                console.log("$.fn.input_mode_id_select: items=" + curr.length);
//                console.log("$.fn.input_mode_id_select: id=" + $(select).attr('id'));

                $(select).find("option").remove();

                // append values
                for(i = 0; i < curr.length; i++)
                {
                    var t = curr[i]['width'] + 'x' + curr[i]['height'] + ' at ' +
                        curr[i]['fps_nom'] + '/' + curr[i]['fps_den'] + 'fps ' + curr[i]['tail'];

                    $(select).append
                    (
                        $("<option/>",
                        {
                            value: curr[i]['id'],
                            text: t
                        })
                    );
                };

                i = -1;
                $(select).find('option').each(function(index)
                {
                    if($(this).attr('value') == mode_value)
                    {
                        $(this).attr('selected', 'selected');
                        i = index;
                    };
                });

                if(-1 == i)
                    $(select).find('option').first().attr('selected', 'selected');

            }
        );
    };

    $.fn.decklink_input_board_id_select = function(board_value)
    {
        var select = this;

        $.getJSON
        (
            'bridge-helper.cgi',
            {
                'action' : 'decklink_list_sources'
            }
        )
        .done
        (
            function(curr)
            {
                var i;
                console.log("$.fn.decklink_board_id_select: items=" + curr.length);

                // append values
                for(i = 0; i < curr.length; i++)
                {
                    $(select).append
                    (
                        $("<option/>",
                        {
                            value: curr[i],
                            text: curr[i]
                        })
                    );
                };

                i = -1;
                $(select).find('option').each(function(index)
                {
                    if($(this).attr('value') == board_value)
                    {
                        $(this).attr('selected', 'selected');
                        i = index;
                    };
                });

                if(-1 == i)
                    $(select).find('option').first().attr('selected', 'selected');

                $(select).change();
            }
        );
    };

    $.fn.decklink_output_board_id_select = function(board_value)
    {
        var select = this;

        $.getJSON
        (
            'bridge-helper.cgi',
            {
                'action' : 'decklink_list_sinks'
            }
        )
        .done
        (
            function(curr)
            {
                var i;
                console.log("$.fn.decklink_board_id_select: items=" + curr.length);

                // append values
                for(i = 0; i < curr.length; i++)
                {
                    $(select).append
                    (
                        $("<option/>",
                        {
                            value: curr[i],
                            text: curr[i]
                        })
                    );
                };

                i = -1;
                $(select).find('option').each(function(index)
                {
                    if($(this).attr('value') == board_value)
                    {
                        $(this).attr('selected', 'selected');
                        i = index;
                    };
                });

                if(-1 == i)
                    $(select).find('option').first().attr('selected', 'selected');

                $(select).change();
            }
        );
    };

    $.fn.input_board_id_select = function(board_value, mode_value, mode_id_select, audio_channels, audio_channels_select)
    {
        var select = this;

        $(this).change(function() {
            var b = $(select).find("option:selected").first().val();
            console.log("$.fn.input_board_id_select: CHANGED=" + b);
            mode_id_select.input_mode_id_select(b, mode_value);
        });

        $(this).decklink_input_board_id_select(board_value);

        audio_channels_select.find('option').each(function(index)
        {
            if($(this).attr('value') == audio_channels)
                $(this).attr('selected', 'selected');
        });
    };

    $.fn.ndi_source_select = function(ndi_value)
    {
        var select = this;

        $.getJSON
        (
            'bridge-helper.cgi',
            {
                'action' : 'ndi_find_sources'
            }
        )
        .done
        (
            function(curr)
            {
                var i;
                console.log("$.fn.ndi_source_select: items=" + curr.length);

                // append values
                for(i = 0; i < curr.length; i++)
                {
                    $(select).append
                    (
                        $("<option/>",
                        {
                            value: curr[i],
                            text: curr[i]
                        })
                    );
                };

                i = -1;
                $(select).find('option').each(function(index)
                {
                    if($(this).attr('value') == ndi_value)
                    {
                        $(this).attr('selected', 'selected');
                        i = index;
                    };
                });

                if(-1 == i)
                    $(select).find('option').first().attr('selected', 'selected');

                $(select).change();
            }
        );
    };


    var channels_names_search = ['AUDIO_PID', 'VIDEO_PID', 'SERVICE_ID'];
    var args_names_search = ['DEV_IDX', 'SAT_NUMBER', 'LNB', 'DELIVERY_SYSTEM', 'FREQUENCY', 'POLARIZATION', 'SYMBOL_RATE', 'INNER_FEC'];

    $.fn.setval = function(val)
    {
        var a = $(this).prop("tagName");
        if(typeof a !== 'string')
            return;
        if(a.toLowerCase() == 'input')
            $(this).val(val);
        else if(a.toLowerCase() == 'select')
        {
            $(this).find('option').each(function(index)
            {
                if($(this).attr('value') == val)
                    $(this).attr('selected', 'selected');
            });
        };
    };

    $.fn.dvblink_set_transponder = function(args_vals_search)
    {
        var i;
        var BRIDGE_DIV = this;

        for(i = 0; i < args_names_search.length; i++)
        {
            var key = args_names_search[i];
            var name = 'dvblink_' + key;
            var val = args_vals_search[key];
            $(BRIDGE_DIV).find("[name='" + name + "']").setval(val);
            console.log("$.fn.dvblink_set_transponder: name=[" + name + "], val=[" + val + "]");
        };

        for(i = 0; i < channels_names_search.length; i++)
        {
            var key = channels_names_search[i];
            var name = 'dvblink_' + key;
            var val = args_vals_search[key]
            $(BRIDGE_DIV).find("[name='" + name + "']").setval(val);
            console.log("$.fn.dvblink_set_transponder: name=[" + name + "], val=[" + val + "]");
        };

        $(BRIDGE_DIV).find("[name='dvblink_scanned_transponder']").append
        (
            $("<option/>",
            {
                value: 'none',
                text: args_vals_search['name']
            })
        );


        return args_vals_search;
    };

    $.fn.dvblink_get_transponder = function(BRIDGE_DIV)
    {
        var i;
        var args_vals_search = {};

        for(i = 0; i < args_names_search.length; i++)
        {
            var key = args_names_search[i];
            var name = 'dvblink_' + key;
            var val = $(BRIDGE_DIV).find("[name='" + name + "']").val();
            console.log("$.fn.dvblink_get_transponder: name=[" + name + "], val=[" + val + "]");
            args_vals_search[key] = val;
        };

        for(i = 0; i < channels_names_search.length; i++)
        {
            var key = channels_names_search[i];
            var name = 'dvblink_' + key;
            var val = $(BRIDGE_DIV).find("[name='" + name + "']").val();
            console.log("$.fn.dvblink_get_transponder: name=[" + name + "], val=[" + val + "]");
            args_vals_search[key] = val;
        };

        $(BRIDGE_DIV).find("[name='dvblink_scanned_transponder']").find('option:selected').each(function()
        {
            args_vals_search['name'] = $(this).text();
        });

        return args_vals_search;
    };

    $.fn.dvblink_scan_transponder = function(BRIDGE_DIV)
    {
        var i;
        var args_vals_search = {};

        console.log("$.fn.dvblink_scan_transponder");

        for(i = 0; i < args_names_search.length; i++)
        {
            var key = args_names_search[i];
            var name = 'dvblink_' + key;
            var val = $(BRIDGE_DIV).find("[name='" + name + "']").val();
            console.log("$.fn.dvblink_scan_transponder: name=[" + name + "], val=[" + val + "]");
            args_vals_search[key] = val;
        };

        console.log("$.fn.dvblink_scan_transponder: args_vals_search=" + JSON.stringify(args_vals_search));

        var dvblink_scanned_transponder = $(BRIDGE_DIV).find("[name='dvblink_scanned_transponder']");
        var dvblink_scan_button = this;

        // disable button
        $(dvblink_scan_button).prop('disabled', true);
        // disable list
        $(dvblink_scanned_transponder).prop('disabled', true);
        // disconnect all event handler of select
        $(dvblink_scanned_transponder).unbind('change');
        // delete all current items
        $(dvblink_scanned_transponder).find('option').remove();
        // add Searching...
        $(dvblink_scanned_transponder).append
        (
            $("<option/>",
            {
                value: 'none',
                text: 'Searching....'
            })
        );

        $.getJSON
        (
            'bridge-dvbscan.cgi', args_vals_search
        )
        .done
        (
            function(curr)
            {

                console.log("$.fn.dvblink_scan_transponder: curr=" + JSON.stringify(curr));

                // enable button
                $(dvblink_scan_button).prop('disabled', false);

                // delete all select items
                $(dvblink_scanned_transponder).find('option').remove();

                var channels = curr.channels;

                // attach change handler
                $(dvblink_scanned_transponder).change(function()
                {
                    var o = $(dvblink_scanned_transponder).find("option:selected").first();
                    console.log("$.fn.dvblink_scan_transponder: text=" + o.text());

                    for(var j = 0; j < channels_names_search.length; j++)
                    {
                        var key = channels_names_search[j];
                        var name = 'dvblink_' + key;
                        var val = o.attr(name);
                        $(BRIDGE_DIV).find("[name='" + name + "']").val(val);
                    };

                });

                // append values
                for(i = 0; i < channels.length; i++)
                {
                    var o = $("<option/>", { text: channels[i].name });

                    for(var j = 0; j < channels_names_search.length; j++)
                    {
                        var key = channels_names_search[j];
                        var name = 'dvblink_' + key;
                        o.attr(name, channels[i][key]);
                    };

                    $(dvblink_scanned_transponder).append(o);
                };

                // enable list
                $(dvblink_scanned_transponder).prop('disabled', false);

                // select first
                $(dvblink_scanned_transponder).find('option').first().attr('selected', 'selected');
                $(dvblink_scanned_transponder).trigger('change');
            }
        );
    };

    $.fn.bridge_init = function(ITEM)
    {
        var BRIDGE_DIV = this;

        $(BRIDGE_DIV).find("input[name='alias']").val
            ((typeof ITEM['alias'] === 'undefined') ? "" : ITEM['alias']);

        $(BRIDGE_DIV).find(".input_tabs input[name='input_url']").val(
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['url'] === 'undefined') ? "" : ITEM['input']['url']);

        $(BRIDGE_DIV).find(".input_tabs input[name='input_local']").val(
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['local'] === 'undefined') ? "" : ITEM['input']['local']);

        $(BRIDGE_DIV).find(".input_tabs input[name='streamlink']").val(
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['streamlink'] === 'undefined')
                ? "" : ITEM['input']['streamlink']);
        $(BRIDGE_DIV).find(".input_tabs input[name='streamlink_twitch-oauth-token']").val(
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['streamlink_twitch-oauth-token'] === 'undefined')
                ? "" : ITEM['input']['streamlink_twitch-oauth-token']);

        $(BRIDGE_DIV).find(".input_tabs select[name='input_board_id_select']").input_board_id_select(
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['decklink'] === 'undefined') ? '' : ITEM['input']['decklink'],
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['decklink'] === 'undefined') ? '' : ITEM['input']['mode'],
            $(BRIDGE_DIV).find(".input_tabs select[name='input_board_mode_select']"),
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['decklink'] === 'undefined') ? '' : ITEM['input']['decklink_audio_channels'],
            $(BRIDGE_DIV).find(".input_tabs select[name='input_board_audio_channels']"));

        $(BRIDGE_DIV).find(".input_tabs select[name='ndi_source_select']").ndi_source_select(
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['ndi'] === 'undefined') ? '' : ITEM['input']['ndi']);

        $(BRIDGE_DIV).find(".input_tabs select[name='thecoreelements_output_select']").setval(
            (typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['thecoreelements'] === 'undefined') ? 0 : ITEM['input']['thecoreelements']);

        $(BRIDGE_DIV).find(".input_tabs input[name='thecoreelements_output_nv12']").prop('checked',
            (typeof ITEM['input'] === 'undefined' ||
            typeof ITEM['input']['thecoreelements'] === 'undefined' ||
            typeof ITEM['input']['nv12'] !== 'undefined') ? true : false);

        $(BRIDGE_DIV).find(".input_tabs input[name='thecoreelements_output_channels_cnt_8']").prop('checked',
            (typeof ITEM['input'] === 'undefined' ||
            typeof ITEM['input']['thecoreelements'] === 'undefined' ||
            typeof ITEM['input']['channels_cnt_8'] === 'undefined') ? false : true);

        $(BRIDGE_DIV).find(".input_tabs input[name='thecoreelements_output_deint']").prop('checked',
            (typeof ITEM['input'] === 'undefined' ||
            typeof ITEM['input']['thecoreelements'] === 'undefined' ||
            typeof ITEM['input']['deint'] !== 'undefined') ? true : false);

        $(BRIDGE_DIV).dvblink_set_transponder
            ((typeof ITEM['input'] === 'undefined' || typeof ITEM['input']['dvblink'] === 'undefined') ? {} : ITEM['input']['dvblink']);

        /* switch input tab */
        if(typeof ITEM['input'] !== 'undefined' && typeof ITEM['input']['url'] !== 'undefined')
            $(BRIDGE_DIV).find('.input_tabs').attach_tabs_controller("url");
        else if(typeof ITEM['input'] !== 'undefined' && typeof ITEM['input']['local'] !== 'undefined')
            $(BRIDGE_DIV).find('.input_tabs').attach_tabs_controller("local");
        else if(typeof ITEM['input'] !== 'undefined' &&  typeof ITEM['input']['decklink'] !== 'undefined')
            $(BRIDGE_DIV).find('.input_tabs').attach_tabs_controller("decklink");
        else if(typeof ITEM['input'] !== 'undefined' &&  typeof ITEM['input']['streamlink'] !== 'undefined')
            $(BRIDGE_DIV).find('.input_tabs').attach_tabs_controller("streamlink");
        else if(typeof ITEM['input'] !== 'undefined' &&  typeof ITEM['input']['dvblink'] !== 'undefined')
            $(BRIDGE_DIV).find('.input_tabs').attach_tabs_controller("dvblink");
        else if(typeof ITEM['input'] !== 'undefined' &&  typeof ITEM['input']['ndi'] !== 'undefined')
            $(BRIDGE_DIV).find('.input_tabs').attach_tabs_controller("ndi");
        else if(typeof ITEM['input'] !== 'undefined' &&  typeof ITEM['input']['thecoreelements'] !== 'undefined')
            $(BRIDGE_DIV).find('.input_tabs').attach_tabs_controller("thecoreelements");
        else
            $(BRIDGE_DIV).find('.input_tabs').attach_tabs_controller("url");

//            $(BRIDGE_DIV).find(".input_tabs input[name='input_url']").val(ITEM['input']['url']);

        /* sat search */
        $(BRIDGE_DIV).delegate(".dvblink_scan_transponder", "click", function() {
            $(this).dvblink_scan_transponder($(BRIDGE_DIV));
        });

        /* filter complex */
        $(BRIDGE_DIV).delegate(".new_filter_complex", "click", function() {
            $(BRIDGE_DIV).find(".filters_complex").new_filter_complex([""]);
        });
        $(BRIDGE_DIV).find(".filters_complex").new_filter_complex
            ((typeof ITEM['filters_complex'] === 'undefined') ? [] : ITEM['filters_complex']);

        /* output */
        $(BRIDGE_DIV).find(".new_output").ddm_attach
        ({
            'class': 'new_output_preset_list',
            'items': new_output_preset_list,
            'cookie': $(BRIDGE_DIV).find(".outputs"),
            'cb': function(idx, a, c) { c.new_output([a]); }
        });
        $(BRIDGE_DIV).find(".outputs").new_output
            ((typeof ITEM['outputs'] === 'undefined') ? [] : ITEM['outputs']);
    };

    $.fn.save_bridge = function(ITEM)
    {
        var BRIDGE_DIV = this;
        var BRIDGE = {};

        BRIDGE['alias'] = $(BRIDGE_DIV).find("input[name='alias']").val();

        var input = {};
        var current_tab = $(BRIDGE_DIV).find('.input_tabs').current_tab()
        if('url' == current_tab)
        {
            input['url'] = $(BRIDGE_DIV).find(".input_tabs input[name='input_url']").val();
        }
        else if('local' == current_tab)
        {
            input['local'] = $(BRIDGE_DIV).find(".input_tabs input[name='input_local']").val();
        }
        else if('streamlink' == current_tab)
        {
            input['streamlink'] = $(BRIDGE_DIV).find(".input_tabs input[name='streamlink']").val();
            input['streamlink_twitch-oauth-token'] = $(BRIDGE_DIV).find(".input_tabs input[name='streamlink_twitch-oauth-token']").val();
        }
        else if('dvblink' == current_tab)
        {
            input['dvblink'] = $(BRIDGE_DIV).dvblink_get_transponder($(BRIDGE_DIV));
        }
        else if('ndi' == current_tab)
        {
            input['ndi'] = $(BRIDGE_DIV).find(".input_tabs select[name='ndi_source_select']").val();
        }
        else if('thecoreelements' == current_tab)
        {
            input['thecoreelements'] = $(BRIDGE_DIV).find(".input_tabs select[name='thecoreelements_output_select']").val();
            if($(BRIDGE_DIV).find(".input_tabs input[name='thecoreelements_output_nv12']").is(':checked'))
                input['nv12'] = "1";
            if($(BRIDGE_DIV).find(".input_tabs input[name='thecoreelements_output_channels_cnt_8']").is(':checked'))
                input['channels_cnt_8'] = "1";
            if($(BRIDGE_DIV).find(".input_tabs input[name='thecoreelements_output_deint']").is(':checked'))
                input['deint'] = "1";
        }
        else
        {
            input['decklink'] = $(BRIDGE_DIV).find(".input_tabs select[name='input_board_id_select']").val();
            input['decklink_audio_channels'] = $(BRIDGE_DIV).find(".input_tabs select[name='input_board_audio_channels']").val();
            input['mode'] = $(BRIDGE_DIV).find(".input_tabs select[name='input_board_mode_select']").val();
        };
        BRIDGE['input'] = input;

        var filters_complex = [];
        $(BRIDGE_DIV).find("div.filters_complex div.filter_complex_item:not(.template) input[name='filter_complex_item']").each(function(index){
            var v = $(this).val();
            if(v != '')
                filters_complex.push(v);
        });
        BRIDGE['filters_complex'] = filters_complex;


        var outputs = [];
        $(BRIDGE_DIV).find("div.outputs div.output_item:not(.template)").each(function(index){
            outputs[index] = $(this).save_output();
        });
        BRIDGE['outputs'] = outputs;

        return BRIDGE;
    };

    $.fn.save_output = function()
    {
        var OUTPUT_DIV = this;
        var OUTPUT = {};

        var VIDEO = {};
        VIDEO['map'] = $(OUTPUT_DIV).find("div.output_video_codec_attrs input[name='map']").val();
        VIDEO['codec'] = $(OUTPUT_DIV).find("div.output_video_codec_attrs select[name='output_video_codec_select']").val();
        if(VIDEO['codec'] == 'copy')
        {
            var f = $(OUTPUT_DIV).find("div.output_video_codec_attrs input[name='bsf:v']").val();
            if(f != '')
                VIDEO['bsf:v'] = f;
        }
        else if(VIDEO['codec'] != 'none')
        {
            var fields = ["vf"];
            $.each(fields, function(index, value){
                VIDEO[value] = $(OUTPUT_DIV).find("div.output_video_codec_attrs input[name='" + value + "']").val();
            });

            $(OUTPUT_DIV)
                .find("div.optional_video_codec_param_item")
                .each(function(index)
                {
                    $(this).optional_video_codec_param_collect(VIDEO);
                });
        };
        OUTPUT['video'] = VIDEO;

        var AUDIOS = [];
        $(OUTPUT_DIV).find("div.output_audio_codec_attrs:not(.template)").each(function(index){
            var AUDIO = {};
            var oaca = this;

            AUDIO['map'] = $(oaca).find("input[name='map']").val();
            AUDIO['codec'] = $(oaca).find("select[name='output_audio_codec_select']").val();
            if(AUDIO['codec'] == 'empty')
                AUDIO['af'] = $(oaca).find("input[name='af']").val();
            else if(AUDIO['codec'] == 'copy')
                AUDIO['bsf:a'] = $(oaca).find("input[name='bsf:a']").val();
            else
            {
                var fields = ["af", "ab", "ac", "ar"];
                $.each(fields, function(index, value){
                    AUDIO[value] = $(oaca).find("input[name='" + value + "']").val();
                });
            };

            AUDIOS[index] = AUDIO;
        });
        OUTPUT['audios'] = AUDIOS;

/*
        var AUDIO = {};
        AUDIO['map'] = $(OUTPUT_DIV).find("div.output_audio_codec_attrs input[name='map']").val();
        AUDIO['codec'] = $(OUTPUT_DIV).find("div.output_audio_codec_attrs select[name='output_audio_codec_select']").val();
        if(AUDIO['codec'] == 'empty')
            AUDIO['af'] = $(OUTPUT_DIV).find("div.output_audio_codec_attrs input[name='af']").val();
        else if(AUDIO['codec'] == 'copy')
            AUDIO['bsf:a'] = $(OUTPUT_DIV).find("div.output_audio_codec_attrs input[name='bsf:a']").val();
        else
        {
            var fields = ["af", "ab", "ac", "ar"];
            $.each(fields, function(index, value){
                AUDIO[value] = $(OUTPUT_DIV).find("div.output_audio_codec_attrs input[name='" + value + "']").val();
            });
        };
        OUTPUT['audio'] = AUDIO;
*/

        var FORMATS = [];
        $(OUTPUT_DIV).find("div.formats div.format_item:not(.template)").each(function(index){
            FORMATS[index] = $(this).save_format();
        });
        OUTPUT['formats'] = FORMATS;

        return OUTPUT;
    };

    $.fn.save_format = function()
    {
        var FORMAT_DIV = this;
        var FORMAT = {};

        FORMAT['f'] = $(FORMAT_DIV).find("select[name='format_select']").val();

        if('decklink' == FORMAT['f'])
        {
            FORMAT['y'] = $(FORMAT_DIV).find("div.format_name_decklink select[name='output_board']").val();
            FORMAT['preroll'] = $(FORMAT_DIV).find("div.format_name_decklink input[name='preroll']").val();
        }
        else if('thecoreelements' == FORMAT['f'])
        {
            FORMAT['y'] = $(FORMAT_DIV).find("div.format_name_thecoreelements select[name='thecoreelements_input_select']").val();
        }
        else
        {
            $(FORMAT_DIV).find(
                "div.format_name_" + FORMAT['f'] + " input" + "," +
                "div.format_name_" + FORMAT['f'] + " select").each(function(index){
                var v = $(this).val();

                if(v != '')
                    FORMAT[$(this).attr('name')] = v;
            });

            $(FORMAT_DIV).find("div.format_name_non_decklink").output_url_collect(FORMAT);
        };

        return FORMAT;
    };

}( jQuery ));
