#!/usr/bin/perl

$|=1;

use strict;
use vars qw(%ENV %ARGV);
use CGI qw(:cgi standart);
use Data::Dump qw(dump);
use JSON;

my $cgi = new CGI;
my $res = [];
my $action = $cgi->param('action');
##my $action = 'audio_encoders';
##my $action = "decklink_list_formats";
##my $device = "DeckLink SDI (1)";

if(!defined($action))
{
}
elsif('decklink_list_formats' eq $action)
{
    my $device = $cgi->param('device');

    my @RES = ();

    foreach my $l (split("\n", `/usr/local/enctools/bin/ffmpeg -f decklink -list_formats 1 -i "$device" 2>&1`))
    {
        my $item;
##print "line=" . dump($l) . "\n";
        if(($l =~ m/^\[decklink [^\]]+\] \t(\d+)\t(\d+)x(\d+) at (\d+)\/(\d+) fps(.*)/)
            || ($l =~ m/^\t([^\t]+)\t\t(\d+)x(\d+) at (\d+)\/(\d+) fps(.*)/))
        {
            # save main params
            $item =
            {
                id => $1,
                width => $2,
                height => $3,
                fps_nom => $4,
                fps_den => $5,
                tail => $6,
            };

            # check interlaced
            if($item->{tail} =~ m/interlaced, (upper|lower)/g)
            {
                $item->{fields} = $1;
            }
            else
            {
                $item->{fields} = 'progressive';
            };

            push(@RES, $item);
        };
    };

    $res = \@RES;
}
elsif('decklink_list_devices' eq $action)
{
    my @RES = ();

    foreach my $l (split("\n", `/usr/local/enctools/bin/ffmpeg -f decklink -list_devices 1 -i dummy 2>&1`))
    {
        if($l =~ m/^\[decklink [^\]]+\] \t\'([^\']*)/)
        {
            push(@RES, $1);
        };
    };

    $res = \@RES;
}
elsif('decklink_list_sources' eq $action)
{
    my @RES = ();

    foreach my $l (split("\n", `/usr/local/enctools/bin/ffmpeg -sources decklink 2>/dev/null`))
    {
        if($l =~ m/[^\]]*\[([^\]]*)\]/)
        {
            push(@RES, $1);
        };
    };

    $res = \@RES;
}
elsif('decklink_list_sinks' eq $action)
{
    my @RES = ();

    foreach my $l (split("\n", `/usr/local/enctools/bin/ffmpeg -sinks decklink 2>/dev/null`))
    {
        if($l =~ m/[^\]]*\[([^\]]*)\]/)
        {
            push(@RES, $1);
        };
    };

    $res = \@RES;
}
elsif('ndi_find_sources' eq $action)
{
    my @RES = ();

    foreach my $l (split("\n", `/usr/local/enctools/bin/ffmpeg -f libndi_newtek -find_sources 1 -i dummy 2>&1`))
    {
        if($l =~ m/^\[libndi_newtek [^\]]+\] \t\'([^\']*)/)
        {
            push(@RES, $1);
        };
    };

    $res = \@RES;
}
elsif(('video_encoders' eq $action) || ('audio_encoders' eq $action))
{
    my @RES = ();

    my $VAS = ('video_encoders' eq $action) ? 'V' : 'A';

    foreach my $l (split("\n", `/usr/local/enctools/bin/ffmpeg -encoders 2>&1`))
    {
        if($l =~ m/([VAS.])([F.])([S.])([X.])([B.])([D.]) ([^ ]*)[ ]*(.*)/)
        {
            next if($1 ne $VAS);
            next if($7 eq '=');

            push(@RES, {'codec' => $7, 'title' => $8});
        };
    };

    $res = \@RES;
};

# output to browser
print
    $cgi->header
    (
        -access_control_allow_origin => "*",
        -charset        =>      "utf-8",
        -type           =>      "application/json",
        -expires        =>      "-1d"
    )
    .
    encode_json($res);

