#!/usr/bin/perl

$|=1;

use strict;
use vars qw(%ENV %ARGV);
use CGI qw(:cgi standart);
use Data::Dump qw(dump);
use JSON;

my $args = ['SAT_NUMBER', 'LNB', 'DELIVERY_SYSTEM', 'FREQUENCY', 'POLARIZATION', 'SYMBOL_RATE', 'INNER_FEC'];
my $cgi = new CGI;
my $res = {};
my @CHANNELS = ();

# [CHANNEL]
# <------>SAT_NUMBER = 0
# <------>LNB = UNIVERSAL
# <------>DELIVERY_SYSTEM = DVBS
# <------>FREQUENCY = 11244000
# <------>POLARIZATION = HORIZONTAL
# <------>SYMBOL_RATE = 22000000
# <------>INNER_FEC = 5/6
# <------>INVERSION = AUTO

my $freq_file = "/tmp/bridge-dvbscan-$$.src";
my $channel_file = "/tmp/bridge-dvbscan-$$.dst";
open(DATA, ">$freq_file") or die "Couldn't open file $channel_file, $!";
print DATA "[CHANNEL]\n";
foreach my $idx (@{$args})
{
#    print sprintf("[%s]\n", $idx);
    my $val = scalar $cgi->param($idx);

    $val = int($val) * 1000
        if($idx eq 'FREQUENCY' or $idx eq 'SYMBOL_RATE');

    print DATA sprintf("\t%s = %s\n", $idx, $val);
};
close DATA;

my $dev_idx = scalar $cgi->param('DEV_IDX');

$res->{'log'} = `/usr/local/v4l-utils/bin/dvbv5-scan -a $dev_idx -F $freq_file -o $channel_file 2>&1`;
$res->{'channels'} = \@CHANNELS;

# read lines
open(my $fh, '<', $channel_file);
my @lines = <$fh>;
close $fh;

# decompose it
my ($AUDIO_PID, $VIDEO_PID, $SERVICE_ID);
foreach my $L (reverse @lines)
{
    if($L =~ m/\[([^\]]+)\]/)
    {
        my %ch;

        $ch{'name'} = $1;

        $ch{'AUDIO_PID'} = $AUDIO_PID;
        $ch{'VIDEO_PID'} = $VIDEO_PID;
        $ch{'SERVICE_ID'} = $SERVICE_ID;

        foreach my $idx (@{$args})
        {
            my $val = scalar $cgi->param($idx);
            $ch{$idx} = $val;
        };

        push(@CHANNELS, \%ch)
            if(defined($AUDIO_PID) && defined($VIDEO_PID));

        ($AUDIO_PID, $VIDEO_PID, $SERVICE_ID) = (undef, undef, undef);
    }
    elsif($L =~ m/\t([^ ]+) = (.*)/)
    {
        my ($key, $val) = ($1, $2);

        $AUDIO_PID = $val if ($key eq 'AUDIO_PID');
        $VIDEO_PID = $val if ($key eq 'VIDEO_PID');
        $SERVICE_ID = $val if ($key eq 'SERVICE_ID');
    };
};

# output to browser
print
    $cgi->header
    (
        -access_control_allow_origin => "*",
        -charset        =>      "utf-8",
        -type           =>      "application/json",
        -expires        =>      "-1d"
    )
    .
    encode_json($res);

#unlink $freq_file;
#unlink $channel_file;
