$.fn.TheCoreLib_attach_monitor = function(params)
{
    var parent_div = this;

    function EnableUI(p)
    {
        console.log("EnableUI:" + p);

        if(p == null)
        {
            parent_div.css('background', "");
            parent_div.attr('title', 'no connection....');
//            parent_div.text('');
        }
        else
        {

            var
                total_space_mb = parseInt(p['total_space_mb']),
                free_space_mb = parseInt(p['free_space_mb']),
                per = Math.round((total_space_mb - free_space_mb) * 100 / total_space_mb);

//            console.log("EnableUI: per=" + per);

            var
                x = Math.floor(per % 10),
                y = Math.floor(per / 10);

            var
                offset_x = -x * parseInt(params['step']),
                offset_y = -y * parseInt(params['step']);

            parent_div.css('background-position', offset_x + 'px ' + offset_y + 'px');
            parent_div.css('background-position-x', offset_x + 'px');
            parent_div.css('background-position-y', offset_y + 'px');
            parent_div.css('background-image', "url('" + params['bg'] + "')");
            parent_div.css('background-repeat', "no-repeat");
//            parent_div.text(f + '%');
            parent_div.attr('title', 'Free space ' + p['free_space_percent'] + '% (' + p['free_space_mb'] + 'MB)');

        };
    };

    function LibState(retry_delay)
    {
        $.getJSON
        (
            'TheCoreLib.LibState.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
//            console.log("LibState:" + JSON.stringify(curr));

            if(!(typeof curr.result === 'undefined'))
                EnableUI(curr);
            else
                EnableUI(null);

            if(retry_delay > 0)
                window.setTimeout(function() { LibState(retry_delay); }, retry_delay);
        })
        .fail(function(msg)
        {
            EnableUI(null);
            if(retry_delay > 0)
                window.setTimeout(function() { LibState(retry_delay); }, 4 * retry_delay);
        });
    };

    EnableUI(null);
    LibState(1000);
}

