<?php

include_once 'XML/RPC2/Client.php';

XML_RPC2_Backend::setBackend('php');

$client = XML_RPC2_Client::create('http://127.0.0.1:'
    . (array_key_exists('xmlrpc_port', $_REQUEST) ? $_REQUEST['xmlrpc_port'] : '8000')
    . '/RPC2' , array('prefix' => 'TheCoreLib.'));

try
{
    if(array_key_exists('cnt', $_REQUEST))
        $r = $client->LibState((int)$_REQUEST['cnt']);
    else
        $r = $client->LibState((int)0);

    if($r['free_space'] != NULL)
        $r['free_space_mb'] = (int)($r['free_space'] / (1024 * 1024));

    if($r['total_space'] != NULL)
        $r['total_space_mb'] = (int)($r['total_space'] / (1024 * 1024));

    if($r['free_space'] != NULL && $r['total_space'] != NULL)
        $r['free_space_percent'] = (int)(100 * $r['free_space_mb'] / $r['total_space_mb']);

}
catch (XML_RPC2_FaultException $e)
{
    $r = array
    (
//        'faultString'     => $e->getFaultString(),
//        'faultCode'     => $e->getFaultCode(),
        'faultMessage' => 'XML_RPC2_FaultException',
    );
}
catch (Exception $e)
{
    $r = array
    (
        'faultMessage' => 'Exception',
//        'faultMessage'     => $e->getMessage()
//        'faultCode'     => $e->getFaultCode(),
    );
}

header("Content-type: text/x-json");

echo json_encode($r);
