$.fn.TheCoreElementsB1Mix_attach = function(params)
{
    var p;
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsB1Mix main"></div>');
    main_div.appendTo(parent_div);

    // -------------------------

    $('<div class="TheCoreElementsB1Mix row"><h1>Connection</h1></div>').appendTo(main_div);

    function append_row(title, type, conn_output)
    {
        var row = $('<div class="TheCoreElementsB1Mix row"></div>');
        row.appendTo(main_div);

        var t = $('<span class="title"></span>');
        t.appendTo(row);
        t.text(title);

        var td_sel = $('<select class="CONN"></select>');
        td_sel.prop('disabled', true);
        td_sel.appendTo(row);
        td_sel.addClass(type);
        if(conn_output)
            td_sel.addClass('CONN_OUTPUT');

        row.delegate('select.CONN', 'change', function(e)
        {
            console.log('Input changed');
            main_div.find('button.SAVE_CONN').prop('disabled', false);
        });
    };

    append_row('Input:', 'INP', 0);
    append_row('Output:', 'OUT', 1);

    $('<div class="TheCoreElementsB1Mix row"><button class="SAVE_CONN"> SAVE </button></div>').appendTo(main_div);

    main_div.delegate('button.SAVE_CONN', "click", function()
    {
        var conn =
        {
            "inp": 0,
            "out": 0,
        };

        main_div.find('select.CONN').each(function(index)
        {
            var c = parseInt($(this).val());
            if($(this).hasClass('INP')) conn['inp'] = c;
            else if($(this).hasClass('OUT')) conn['out'] = c;
            else if($(this).hasClass('AUX')) conn['aux'] = c;
        });

        console.log("saving connections...conn=" + JSON.stringify(conn));

        var r =
        {
            'xmlrpc_port'       : params['port'],
            'conn'              : conn,
        };

        $.post
        (
            'TheCoreElementsB1Mix.SetConnections.php', r
        )
        .done
        (
            function(curr)
            {
                GetStat();
            }
        );
    });


    // -------------------------

    $('<div class="TheCoreElementsB1Mix row"><h1>Selector config</h1></div>').appendTo(main_div);

    function append_selector_config_row(idx)
    {
        var row = $('<div class="TheCoreElementsB1Mix row SELECTOR"></div>');
        row.appendTo(main_div);
        row.attr('idx', idx);

        var p = $('<input type="text" class="TheCoreElementsB1Mix SELECTOR SELECTOR_FILE">');
        p.appendTo(row);

        var td_sel = $('<select class="CONN SELECTOR_PIN"></select>');
        td_sel.prop('disabled', true);
        td_sel.appendTo(row);
        td_sel.addClass('PIN-' + idx);
        row.delegate('select.CONN', 'change', function(e)
        {
            console.log('Input changed');
            main_div.find('button.SAVE_SELECTOR').prop('disabled', false);
        });
        row.delegate('input.SELECTOR', 'keypress', function(e)
        {
            main_div.find('button.SAVE_SELECTOR').prop('disabled', false);
        });
    };

//    $('<div class="TheCoreElementsB1Mix row"><div class="TheCoreElementsB1Mix SELECTOR_FILE">FILE NAME</div><div class="TheCoreElementsB1Mix SELECTOR_PIN">PIN</div>').appendTo(main_div);

    for(i = 0; i < 8; i++)
        append_selector_config_row(i);

    $('<div class="TheCoreElementsB1Mix row"><button class="SAVE_SELECTOR"> SAVE </button></div>').appendTo(main_div);

    // -------------------------

    main_div.delegate('button.SAVE_SELECTOR', "click", function()
    {
        var files = [ "", "", "", "",  "", "", "", ""];
        var pins = [ "", "", "", "",  "", "", "", ""];

        main_div.find('div.TheCoreElementsB1Mix.row.SELECTOR').each(function(index)
        {
            var idx = parseInt($(this).attr('idx'));

            files[idx] = $(this).find('input.SELECTOR.SELECTOR_FILE').val();

            main_div.find('select.CONN.PIN-' + idx).each(function(index)
            {
                pins[idx] = $(this).val();
            });
        });

        console.log("saving selector...files=" + JSON.stringify(files) + ", pins=" + JSON.stringify(pins));

        var r =
        {
            'xmlrpc_port'       : params['port'],
            'pins'              : pins,
            'files'             : files,
        };

        $.post
        (
            'TheCoreElementsB1Mix.SetSelectors.php', r
        )
        .done
        (
            function(curr)
            {
                GetStat();
            }
        );

    });


    // -------------------------

    parent_div.delegate("input[type='text'].row_pos", "keypress", function(e)
    {
        var txt = String.fromCharCode(e.which);
        if(!txt.match(/[0-9.,]/))
        {
            return false;
        }
    });

    parent_div.delegate("input[type='text'].row_neg", "keypress", function(e)
    {
        var txt = String.fromCharCode(e.which);
        if(!txt.match(/[0-9.,]/))
        {
            if(txt != '-')
                return false;
        }
    });

    function GetStat()
    {
        $.getJSON
        (
            'TheCoreElementsB1Mix.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetStat:" + JSON.stringify(curr));
            update_ui(curr);
        })
        .fail(function(msg)
        {
        });
    };

    GetStat();


    function update_ui_labels(curr, labels, type, matrix_output)
    {
        var opt;
        var sel_idx;
        var td_sel = main_div.find('select.CONN.' + type);

        /* disable */
        td_sel.prop('disabled', true);

        /* clear options */
        td_sel.find('option').each(function(index) { $(this).remove(); });
        td_sel.find('optgroup').each(function(index) { $(this).remove(); });

        opt = $('<optgroup label="Outputs"></optgroup>');
        opt.appendTo(td_sel);

        if(!td_sel.hasClass('CONN_OUTPUT'))
        for(sel_idx = 1; sel_idx < labels.outputs.length; sel_idx++)
        {
            if("" == labels.outputs[sel_idx])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(sel_idx);
            o.text(sel_idx + ' - ' + labels.outputs[sel_idx]);
            if(sel_idx == matrix_output)
                o.attr("selected","selected");
        };

        opt = $('<optgroup label="Inputs"></optgroup>');
        opt.appendTo(td_sel);

        for(sel_idx = 1; sel_idx < labels.inputs.length; sel_idx++)
        {
            if("" == labels.inputs[sel_idx])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(-sel_idx);
            o.text(sel_idx + ' - ' + labels.inputs[sel_idx]);
            if(-sel_idx == matrix_output)
                o.attr("selected","selected");
        };

        /* enable */
        td_sel.prop('disabled', false);
    };

    function update_ui(curr)
    {
        /* update connections labels */
        $.getJSON
        (
            'TheCoreElementsB1Mix.GetLabels.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(labels)
        {
            console.log("GetLabels:" + JSON.stringify(labels));

            update_ui_labels(curr, labels, 'INP', curr.inp);
            update_ui_labels(curr, labels, 'OUT', curr.out);

            for(i = 0; i < 8; i++)
                update_ui_labels(curr, labels, 'PIN-' + i, curr.pins[i]);

            main_div.find('div.TheCoreElementsB1Mix.row.SELECTOR').each(function(index)
            {
                var idx = parseInt($(this).attr('idx'));
                $(this).find('input.SELECTOR.SELECTOR_FILE').val(curr.files[idx]) ;
            });

            main_div.find('button.SAVE_CONN').prop('disabled', true);
            main_div.find('button.SAVE_SELECTOR').prop('disabled', true);
        })
        .fail(function(msg)
        {
        });
    };
}
