<?php

include_once 'MongoDB/autoload.php';

//use MongoDB\Client;

$r = [];

try
{
    $conn = new MongoDB\Client("mongodb://localhost:27017");
    $db = $conn->TheCoreElementsPresets;
    $collection = $db->selectCollection($_REQUEST['collection']);

    if($_REQUEST['action'] == 'list_all')
    {
        $r = $collection->find()->toArray();
        foreach($r as &$v)
            $v['_id'] = $v['_id']->__toString();
    }
    else if($_REQUEST['action'] == 'save_as')
    {
        // https://www.php.net/manual/ru/function.json-decode.php
        $p = json_decode($_REQUEST['preset'], true);

        // https://docs.mongodb.com/php-library/master/reference/method/MongoDBCollection-insertOne/
        $r = $collection->insertOne($p);

        // https://docs.mongodb.com/php-library/v1.2/reference/method/MongoDBInsertOneResult-getInsertedId/
        // https://www.php.net/manual/en/mongodb-bson-objectid.tostring.php
        $p['_id'] = $r->getInsertedId()->__toString();

        $r = $p;
    }
    else if($_REQUEST['action'] == 'save')
    {
        $p = json_decode($_REQUEST['preset'], true);

        // https://docs.mongodb.com/php-library/master/reference/method/MongoDBCollection-updateOne/
        $r = $collection->updateOne(['_id' => new MongoDB\BSON\ObjectId($_REQUEST['_id'])], ['$set' => $p]);

        $r = $r->getModifiedCount();
    }
    else if($_REQUEST['action'] == 'remove')
    {
        // https://docs.mongodb.com/php-library/master/reference/method/MongoDBCollection-deleteOne/#example
        // https://www.php.net/class.mongodb-bson-objectid
        $r = $collection->deleteOne(['_id'=> new MongoDB\BSON\ObjectId($_REQUEST['_id'])]);
        $r = $r->getDeletedCount();
    };
}
catch (MongoConnectionException $e)
{
    error_log("Error connecting to MongoDB server");
}
catch (MongoException $e)
{
    error_log("Error: " . $e->getMessage());
}

    header("Content-type: text/x-json");
    echo json_encode($r);
?>
