$.fn.TheCoreElementsMosaic_attach = function(params)
{
    var sel;
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsMosaic main"></div>');
    main_div.appendTo(parent_div);

    // -------------------------

    var pins_div = $('<div class="TheCoreElementsMosaic pins"></div>');
        pins_div.appendTo(main_div);

    $('<h1>Connections</h1>').appendTo(pins_div);
    {
        var row, t, img;

        row = $('<div class="TheCoreElementsMosaic thin_row"></div>');
        row.appendTo(pins_div);

        t = $('<span class="title"></span>');
        t.appendTo(row);
        t.text('OUTPUT:');

        matrix_pins_selector_list_create(row, 'OUTPUT', 0);

        row = $('<div class="TheCoreElementsMosaic thin_row"></div>');
        row.appendTo(pins_div);
        img = $('<img alt="output preview" src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" class="TheCoreElementsMosaic MATRIX_PIN_PRV OUTPUT"/>');
        img.appendTo(row);
    };

    // ----------------------

    var funcs_div = $('<div class="TheCoreElementsMosaic funcs"></div>');
        funcs_div.appendTo(main_div);
    $('<h1>Sources mappings</h1>').appendTo(funcs_div);

    // -------------------------
    var prst_div = $('<div class="TheCoreElementsPresets main_fr" style="margin-bottom: 15px;"></div>');
        prst_div.appendTo(funcs_div);
        prst_div.attr('idx', i);
        prst_div.TheCoreElementsPresets_attach
        ({
            'cookie' : { },
            'collection' : (params['hash']),
            'get_values' : function (cookie)
            {
                var r = {};
                console.log("Getting values");
                return r;
            },
            'set_values' : function (preset, cookie)
            {
                console.log("Setting values");
            }
        });

    // -------------------------

    var main_table = $('<table width="100%" border="1" cellpadding="0" cellspacing="0" class="TheCoreElementsMosaic"></table>');
        main_table.appendTo(funcs_div);

    var thead = $('<thead></thead');
        thead.appendTo(main_table);

    var tbody = $('<tbody></tbody');
        tbody.appendTo(main_table);

    var tr = $('<tr></tr>');
        tr.appendTo(thead);

    $('<th class="PRV" width="80">PRV</th>').appendTo(tr);

    $('<th class="PIN" width="*">PIN</th>').appendTo(tr);

    $('<th class="SRC" width="120">SRC<br>X Y / W H</th>').appendTo(tr);
    $('<th class="DST" width="120">DST<br>X Y</th>').appendTo(tr);
    $('<th class="CONTROL" width="*">CONTROL</th>').appendTo(tr);

    for(var i = 0; i < 8; i++)
    {
        var td, inp;

        tr = $('<tr class="PARAMS"></tr>');
        tr.appendTo(tbody);
        tr.attr('idx', i);

        td = $('<td class="PRV"></td>'); td.appendTo(tr);
        td.attr('idx', i);
        img = $('<img alt="input preview" src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" class="TheCoreElementsMosaic MATRIX_PIN_PRV INPUT"/>');
        img.attr('idx', i);
        img.appendTo(td);

        td = $('<td class="PIN"></td>'); td.appendTo(tr);
        td.attr('idx', i);
        matrix_pins_selector_list_create(td, 'INPUT', i);

        td = $('<td class="SRC"></td>'); td.appendTo(tr);
        td.attr('idx', i);
        {
            inp = $('<input type="text" class="TheCoreElementsMosaic SRC X PARAMS">');
            inp.appendTo(td);
            inp.attr('idx', i);

            inp = $('<input type="text" class="TheCoreElementsMosaic SRC Y PARAMS">');
            inp.appendTo(td);
            inp.attr('idx', i);

            $('<br>').appendTo(td);

            inp = $('<input type="text" class="TheCoreElementsMosaic SRC W PARAMS">');
            inp.appendTo(td);
            inp.attr('idx', i);

            inp = $('<input type="text" class="TheCoreElementsMosaic SRC H PARAMS">');
            inp.appendTo(td);
            inp.attr('idx', i);
        }

        td = $('<td class="DST"></td>'); td.appendTo(tr);
        td.attr('idx', i);
        {
            inp = $('<input type="text" class="TheCoreElementsMosaic DST X PARAMS">');
            inp.appendTo(td);
            inp.attr('idx', i);

            inp = $('<input type="text" class="TheCoreElementsMosaic DST Y PARAMS">');
            inp.appendTo(td);
            inp.attr('idx', i);
        }

        td = $('<td class="SAVE"></td>'); td.appendTo(tr);
        td.attr('idx', i);
        {
            inp = $('<button class="TheCoreElementsMosaic SAVE">SAVE</button>');
            inp.appendTo(td);
            inp.attr('idx', i);
        };
    };

    /* open in tab image */
    main_div.delegate("img.TheCoreElementsMosaic.MATRIX_PIN_PRV", "click", function(e)
    {
        var u = $(this).attr('src');

        console.log('src1=' + u);

        if(u.indexOf('-5-5.jpg') > 0)
            u = u.replace('-5-5.jpg', '-0-0.jpg');
        else if(u.indexOf('-2-5.jpg') > 0)
            u = u.replace('-2-5.jpg', '-0-0.jpg');
        else
            u = "";

        console.log('src2=' + u);

        if(u != "")
        {
            var win = window.open(u, '_blank');
            win.focus();
        };
    });

    /* enable only digits */
    main_table.delegate("input[type='text'].PARAMS", "keypress", function(e)
    {
        var txt = String.fromCharCode(e.which);
        var idx = $(this).attr('idx');
        if(!txt.match(/[0-9]/))
        {
            return false;
        }
        main_table.find("button[idx='" + idx + "'].SAVE").prop('disabled', false);
    });

    main_table.delegate('input.PARAMS', 'change', function(e)
    {
    });

    main_table.delegate("button.SAVE", "click", function()
    {
        $(this).prop('disabled', true);
        var tr = $(this).parent().parent();
        var idx = $(this).attr('idx');
        var r =
        {
            'xmlrpc_port'       : params['port'],
            'idx'               : parseInt(idx),
            'src_x'             : parseInt(tr.find('input.SRC.X').val()),
            'src_y'             : parseInt(tr.find('input.SRC.Y').val()),
            'src_w'             : parseInt(tr.find('input.SRC.W').val()),
            'src_h'             : parseInt(tr.find('input.SRC.H').val()),
            'dst_x'             : parseInt(tr.find('input.DST.X').val()),
            'dst_y'             : parseInt(tr.find('input.DST.Y').val()),
        };

        $.post
        (
            'TheCoreElementsMosaic.SaveMap.php', r
        )
        .done(function(curr)
        {
            GetTally();
        });

    });


    /* get matrix pins */
    $.getJSON
    (
        'TheCoreElementsMosaic.GetLabels.php',
        {
            'xmlrpc_port' : params['port']
        }
    )
    .done(function(labels)
    {
        console.log("GetLabels:" + JSON.stringify(labels));
        main_div.find('select.MATRIX_PIN_SELECT').each(function()
        {
            matrix_pins_selector_list_setup($(this), labels)
            $(this).prop('disabled', false);
        });

        GetTally();
    });

    var GetTallyTimeout = setTimeout(function(){ GetTelly(); }, 30000);

    function GetTally()
    {
        $.getJSON
        (
            'TheCoreElementsMosaic.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(resp)
        {
            var amend_resp = parseInt(resp.amend);
            var timeout_dur = 800;
            if(amend < amend_resp)
            {
                amend = amend_resp;
                UpdateUI(resp);
                timeout_dur = 200;
            };
            clearTimeout(GetTallyTimeout);
            GetTallyTimeout = setTimeout(function(){ GetTally(); }, timeout_dur);
        });
    };

    function UpdateUI(resp)
    {
        console.log("Update UI");

        /* params */
        main_div.find('tr.PARAMS').each(function(index)
        {
            var tr = $(this);
            var idx = parseInt(tr.attr('idx'));

            tr.find('input.SRC.X').val(resp.maps[idx].src_x);
            tr.find('input.SRC.Y').val(resp.maps[idx].src_y);
            tr.find('input.SRC.W').val(resp.maps[idx].src_w);
            tr.find('input.SRC.H').val(resp.maps[idx].src_h);
            tr.find('input.DST.X').val(resp.maps[idx].dst_x);
            tr.find('input.DST.Y').val(resp.maps[idx].dst_y);

            tr.find('button.SAVE').prop('disabled', 1);
        });

        /* update prv images */
        main_div.find('img.MATRIX_PIN_PRV').each(function(index)
        {
            var u, pin, img = $(this);
            if(img.hasClass('OUTPUT'))
                pin = parseInt(resp.out_pin);
            else
            {
                var idx = parseInt(img.attr('idx'));
                pin = parseInt(resp.maps[idx].pin);
//                console.log("prv pin=" + pin + ", idx=" + idx);
            };
            if(pin)
            {
                u = "/TheCoreElementsIOJPEGOutput/" + ((pin < 0) ? ('i' + (-pin)) : ('o' + pin));
                if(img.hasClass('OUTPUT'))
                    u += '-2-5.jpg';
                else
                    u += '-5-5.jpg';
            }
            else
                u = 'data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=';
            img.attr('src', u);

            console.log('img: ' + u);
        });

        /* update pins selection */
        main_div.find('select.MATRIX_PIN_SELECT').each(function(index)
        {
            var sel = $(this);

            if(sel.hasClass('OUTPUT'))
                pin = parseInt(resp.out_pin);
            else
            {
                var idx = parseInt(sel.attr('idx'));
                pin = parseInt(resp.maps[idx].pin);
            };

            sel.find('option').each(function(index)
            {
                var o = $(this);
                var v = parseInt(o.val());
                o.attr('selected', pin == v ? 'selected' : null);
            });
        });


    };

    function matrix_pins_selector_list_setup(td_sel, labels)
    {
        var opt, i, d;

        /* disable */
        d = td_sel.prop('disabled');

        /* clear options */
        td_sel.find('option').each(function(index) { $(this).remove(); });
        td_sel.find('optgroup').each(function(index) { $(this).remove(); });

        if(td_sel.hasClass('INPUT'))
        {
            opt = $('<optgroup label="Outputs"></optgroup>');
            opt.appendTo(td_sel);

            for(i = 1; i < labels.outputs.length; i++)
            {
                if("" == labels.outputs[i])
                    continue;

                var o = $('<option></option>');
                o.appendTo(opt);
                o.val(i);
                o.text(i + ' - ' + labels.outputs[i]);
            };
        };

        if(1)
        {
            opt = $('<optgroup label="Inputs"></optgroup>');
            opt.appendTo(td_sel);

            for(i = 1; i < labels.inputs.length; i++)
            {
                if("" == labels.inputs[i])
                    continue;

                var o = $('<option></option>');
                o.appendTo(opt);
                o.val(-i);
                o.text(i + ' - ' + labels.inputs[i]);
            };
        };

        var o = $('<option ></option>');
            o.val(0);
            o.appendTo(td_sel);
            o.attr("selected","selected");

        /* enable */
        td_sel.prop('disabled', d);
    };

    function matrix_pins_selector_list_create(row, clss, idx)
    {
        sel = $('<select class="TheCoreElementsMosaic MATRIX_PIN_SELECT"></select>');
        sel.prop('disabled', true);
        sel.appendTo(row);
        sel.addClass(clss);
        sel.attr('idx', idx);
        row.delegate('select.MATRIX_PIN_SELECT', 'change', function(e)
        {
            console.log('Pin changed');
            var sel = $(this);
            var pin = sel.find('option:selected').val();
            var idx = sel.attr('idx');
            var dir = sel.hasClass('INPUT') ? 0 : 1;

            console.log("input dir=" + dir + ", idx=" + idx + ", pin=" + pin);

            if(pin !== undefined)
            {
                console.log("pin=" + pin);

                $.getJSON
                (
                    'TheCoreElementsMosaic.SetPin.php',
                    {
                        'xmlrpc_port' : params['port'],
                        'dir' : dir,
                        'idx' : idx,
                        'pin' : pin
                    }
                )
                .done(function()
                {
                    GetTally();
                });
            };
        });
    };

}
