$.fn.TheCoreElementsDVE3D_attach = function(params)
{
    var b;
    var parent_div = this;

    var tab_switcher = $('<div class="TheCoreElementsDVE3D tab_switcher"></div>');
    tab_switcher.appendTo(parent_div);

    var oper = $('<div class="TheCoreElementsDVE3D tab_oper"></div>');
    oper.appendTo(parent_div);

    b = $('<div class="TheCoreElementsDVE3D tab_switch CONF" title="Configuration"></div>');
    b.appendTo(tab_switcher);

    b = $('<div class="TheCoreElementsDVE3D tab_switch OPER" title="Operating"></div>');
    b.appendTo(tab_switcher);

    tab_switcher.delegate("div.TheCoreElementsDVE3D.tab_switch", "mousedown", function()
    {
        tab_switcher.find('div.TheCoreElementsDVE3D.tab_switch').removeClass('active');
        $(this).addClass('active');

        oper.empty();
        oper.remove();
        oper = $('<div class="TheCoreElementsDVE3D tab_oper"></div>');
        oper.appendTo(parent_div);

        if($(this).hasClass('CONF'))
        {
            console.log("TheCoreElementsDVE3D.tab_switch: CONF");
            oper.TheCoreElementsDVE3D_conf_attach(params);
        }
        else if($(this).hasClass('OPER'))
        {
            console.log("TheCoreElementsDVE3D.tab_switch: OPER");
            oper.TheCoreElementsDVE3D_oper_attach(params);
        }

    });

    tab_switcher.find('div.TheCoreElementsDVE3D.tab_switch.OPER').trigger('mousedown');
};


$.fn.TheCoreElementsDVE3D_conf_attach = function(params)
{
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsDVE3D main"></div>');
    main_div.appendTo(parent_div);

    var input_header_div = $('<div class="TheCoreElementsDVE3D header">CONNECTIONS <button class="connectors_save">SAVE</button></div>');
    input_header_div.appendTo(main_div);

    var input_selectors_div = $('<div class="TheCoreElementsDVE3D connectors"></div>');
    input_selectors_div.appendTo(main_div);

    function update_connections()
    {
        $.getJSON
        (
            'TheCoreElementsDVE3D.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(conns)
        {
            input_selectors_div.empty();

            console.log("GetConnections:" + JSON.stringify(conns));

            var srcs = parseInt(conns.srcs), keys = parseInt(conns.keys), dsks = parseInt(conns.dsks);

            // build input selector
            {
                var i;
                var table = $('<table class="TheCoreElementsDVE3D"></table>');
                table.appendTo(input_selectors_div);
                table.attr('cnt-srcs', srcs);
                table.attr('cnt-keys', keys);
                table.attr('cnt-dsks', dsks);

                var thead = $('<thead></thead>');
                thead.appendTo(table);

                var thead_tr = $('<tr></tr>');
                thead_tr.appendTo(thead);

                $('<th class="TYPE">TYPE</th>').appendTo(thead_tr);
                $('<th class="CONN">CONN</th>').appendTo(thead_tr);

                var tbody = $('<tbody></tbody>');
                tbody.appendTo(table);

                function append_row(type, matrix, conn_output)
                {
                    var td;
                    var tr = $('<tr></tr>');
                    tr.appendTo(tbody);
                    tr.attr('row-type', type);
                    tr.addClass('CONN');

                    td = $('<td class="TYPE"></td>');
                    td.text(type);
                    td.appendTo(tr);

                    td = $('<td class="CONN"></td>');
                    td.appendTo(tr);
                    var td_sel = $('<select class="CONN"></select>');
                    td_sel.attr('matrix-idx', matrix);
                    td_sel.prop('disabled', true);
                    td_sel.appendTo(td);
                    if(conn_output)
                        td_sel.addClass('CONN_OUTPUT');
                };

                append_row('INPA', conns.inpA, 0);
                append_row('INPB', conns.inpB, 0);
                append_row('OUT', conns.out, 1);
                append_row('BYPASS', conns.bypass, 1);

                /* update labels */
                $.getJSON
                (
                    'TheCoreElementsDVE3D.GetLabels.php',
                    {
                        'xmlrpc_port' : params['port'],
                    }
                )
                .done(function(labels)
                {
                    table.find('select.CONN').each(function(index)
                    {
                        var sel_idx;
                        var td_sel = $(this);
                        var matrix_output = td_sel.attr('matrix-idx');

                        if(!td_sel.hasClass('CONN_OUTPUT'))
                        for(sel_idx = 1; sel_idx < labels.outputs.length; sel_idx++)
                        {
                            var o = $('<option></option>');
                            o.appendTo(td_sel);
                            o.val(sel_idx);
                            o.text(sel_idx + ' - ' + labels.outputs[sel_idx]);
                            if(sel_idx == matrix_output)
                                o.attr("selected","selected");
                        };

                        for(sel_idx = 1; sel_idx < labels.inputs.length; sel_idx++)
                        {
                            var o = $('<option></option>');
                            o.appendTo(td_sel);
                            o.val(-sel_idx);
                            o.text(sel_idx + ' - ' + labels.inputs[sel_idx]);
                            if(-sel_idx == matrix_output)
                                o.attr("selected","selected");
                        };

                        td_sel.prop('disabled', false);
                    });
                });
            };
        });
    };

    update_connections();

    input_header_div.delegate("button.connectors_save", "click", function()
    {
        var t = input_selectors_div.find('table.TheCoreElementsDVE3D');

        var conn =
        {
            "inpA": 0,
            "inpB": 0,
            "out": 0,
            "bypass": 0,
        };

        t.find('tr.CONN').each(function(index)
        {
            var type = $(this).attr('row-type');
            var c = parseInt($(this).find('select.CONN').val());

            if(type == 'INPA') conn['inpA'] = c;
            else if(type == 'INPB') conn['inpB'] = c;
            else if(type == 'OUT') conn['out'] = c;
            else if(type == 'BYPASS') conn['bypass'] = c;
        });

        $.post
        (
            'TheCoreElementsDVE3D.SetConnections.php',
            {
                'xmlrpc_port' : params['port'],
                'conn': conn
            }
        )
        .done
        (
            function(curr)
            {
                update_connections();
            }
        );
    });
}

$.fn.TheCoreElementsDVE3D_oper_attach = function(params)
{
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsDVE3D main"></div>');
    main_div.appendTo(parent_div);

    var header_div = $('<div class="TheCoreElementsDVE3D header">Simple operating controls</div>');
    header_div.appendTo(main_div);

    var oper_div = $('<div class="TheCoreElementsDVE3D operating"></div>');
    oper_div.appendTo(main_div);

    $('<br><br><span>Sequence:</span><select class="TheCoreElementsDVE3D sequence_index"><option value="44">44</option><option value="45">45</option><option value="46">46</option><option value="33">33</option></select>').appendTo(oper_div);
    $('<br><br><br>').appendTo(oper_div);

    $('<br><br><button class="TheCoreElementsDVE3D ctl_button LoadAndRunDVESequence">LoadAndRunDVESequence</button>').appendTo(oper_div);
    $('<br><br><button class="TheCoreElementsDVE3D ctl_button LoadDVESequenceWithAction">LoadDVESequenceWithAction</button>').appendTo(oper_div);
    $('<br><br><button class="TheCoreElementsDVE3D ctl_button RunDVESequence">RunDVESequence</button>').appendTo(oper_div);
    $('<br><br><button class="TheCoreElementsDVE3D ctl_button RunDVESequenceInReverse">RunDVESequenceInReverse</button>').appendTo(oper_div);
    $('<br><br><button class="TheCoreElementsDVE3D ctl_button Unload">Unload</button>').appendTo(oper_div);

    parent_div.delegate("button.TheCoreElementsDVE3D.ctl_button", "click", function()
    {
        var sequence_index = parseInt(oper_div.find('.sequence_index').val());

        console.log('sequence_index=' + sequence_index);

        if($(this).hasClass('LoadAndRunDVESequence'))
            $.post
            (
                'TheCoreElementsDVE3D.LoadAndRunDVESequence.php',
                {
                    'xmlrpc_port' : params['port'],
                    'param1' : sequence_index,
                    'param2' : 0,
                    'param3' : 0,
                }
            );
        else if($(this).hasClass('LoadDVESequenceWithAction'))
            $.post
            (
                'TheCoreElementsDVE3D.LoadDVESequenceWithAction.php',
                {
                    'xmlrpc_port' : params['port'],
                    'param1' : sequence_index,
                    'param2' : 0,
                }
            );
        else if($(this).hasClass('RunDVESequence'))
            $.post
            (
                'TheCoreElementsDVE3D.RunDVESequence.php',
                {
                    'xmlrpc_port' : params['port'],
                    'param1' : 0,
                    'param2' : 0,
                }
            );
        else if($(this).hasClass('RunDVESequenceInReverse'))
            $.post
            (
                'TheCoreElementsDVE3D.RunDVESequenceInReverse.php',
                {
                    'xmlrpc_port' : params['port'],
                    'param1' : 0,
                    'param2' : 0,
                }
            );
        else if($(this).hasClass('Unload'))
            $.post
            (
                'TheCoreElementsDVE3D.LoadDVESequenceWithAction.php',
                {
                    'xmlrpc_port' : params['port'],
                    'param1' : 0,
                    'param2' : 0,
                }
            );

    });
}
