$(document).ready(function ()
{
    $.getJSON
    (
        '/watchdog/GetElements.php',
        {
        }
    )
    .done(function(elements)
    {
        var matrix_port = 0;

        console.log("GetElements:" + JSON.stringify(elements));

        var items = new Array();

        for(var i = 0; i < elements.list.length; i++)
        {
            var app_name = elements.list[i].app_name.replace("elem_", "").toUpperCase();

            items.push
            ({
                'title': elements.list[i].alias,
                'port': elements.list[i].port,
                'icon': app_name,
            });

            /* save matrix control port */
            if(app_name == 'MATRIX')
                matrix_port = elements.list[i].port;

            console.log("    app_name=" + app_name);
        };

        items.push
        ({
            'title': 'PRV',
            'port': matrix_port,
            'icon': 'PRV',
        });

        $('#top_body').TheCoreElements_attach({ 'items': items, 'instance_name' : elements.instance_name });
    });

//    $('#top_body').TheCoreElements_attach({ 'items': ITEMS, 'instance_name' : INSTANCE_NAME });
});

$.fn.TheCoreElements_attach = function(params)
{
    var buttons_color = undefined; // 'yel';
    var parent_div = this;

    var top_menu_div = $('<div horizontal layout class="TheCoreElements top_menu_bar"></div>');
        top_menu_div.appendTo(parent_div);

    var home = $('<div><a href="/"><img src="static/TheCoreElements/home.png" width="50" height="50" border="0" alt="home"></a></div>');
        home.appendTo(top_menu_div);

    var oper = $('<div class="TheCoreElements tab_oper"></div>');
    oper.appendTo(parent_div);

    console.log("HASH=" + window.location.hash);

    $(document).attr("title", "[TheCoreElements] " + params['instance_name']);

    var top_menu_instance_name = $('<div class="TheCoreElements top_menu_instance_name"></div>');
        top_menu_instance_name.text(params['instance_name']);
        top_menu_instance_name.appendTo(top_menu_div);

    var top_menu_scroll_left = $('<div class="TheCoreElements top_menu_items_scroll top_menu_items_scroll_left"></div>');
        top_menu_scroll_left.appendTo(top_menu_div);

    var top_menu_items = $('<div class="TheCoreElements top_menu_items"></div>');
        top_menu_items.appendTo(top_menu_div);

    var top_menu_scroll_right = $('<div class="TheCoreElements top_menu_items_scroll top_menu_items_scroll_right"></div>');
        top_menu_scroll_right.appendTo(top_menu_div);

    var top_menu_items_scroll_busy = false;
    function top_menu_items_scroll(dir)
    {
        var
            sw = top_menu_items.prop("scrollWidth"),
            sl = top_menu_items.prop("scrollLeft"),
            w = top_menu_items.outerWidth(true);

        var sl_new = sl + ((dir) ? 100 : -100);

        if(sl_new < 0)
            sl_new = 0;
        else if(sl_new > (sw - w))
            sl_new = sw - w;

//        console.log("top_menu_items_scroll: sl=" + sl + ", sl_new=" + sl_new);

        if(sl == sl_new)
            return;

        if(!top_menu_items_scroll_busy)
        {
            top_menu_items_scroll_busy = true;
            top_menu_items.animate({scrollLeft: sl_new}, 200,
                function(){
                    top_menu_items_scroll_busy = false;
                    top_menu_items_scroll_enable(); });
        };
    };

    function top_menu_items_scroll_enable()
    {
        var
            sw = top_menu_items.prop("scrollWidth"),
            sl = top_menu_items.prop("scrollLeft"),
            w = top_menu_items.outerWidth(true);

        if((sw - 2) >= w)
        {
            top_menu_scroll_right.css({'display': 'block'});
            top_menu_scroll_left.css({'display': 'block'});
        }
        else
        {
            top_menu_scroll_right.css({'display': 'none'});
            top_menu_scroll_left.css({'display': 'none'});
        };

        if(sl == 0)
            top_menu_scroll_left.css({'opacity': '0'});
        else
            top_menu_scroll_left.css({'opacity': '1.0'});

//        console.log("top_menu_items_scroll_enable: delta=" + (sw - sl - w));

        if((sw - sl - w) < 2)
            top_menu_scroll_right.css({'opacity': '0'});
        else
            top_menu_scroll_right.css({'opacity': '1.0'});
    };

    top_menu_div.delegate('div.TheCoreElements.top_menu_items_scroll', 'click', function(e) {
        top_menu_items_scroll($(this).hasClass('top_menu_items_scroll_right'));
    });

    $(window).on('resize', function() {
        top_menu_items_scroll_enable();
    });

    top_menu_items.scroll(function(){
        top_menu_items_scroll_enable();
    });

    setTimeout(() => top_menu_items_scroll_enable(), 1000);

    top_menu_div.delegate('div.TheCoreElements.top_menu_items', 'scroll', function(e)
    {
        console.log("scroll event");
    });

    top_menu_div.delegate('div.TheCoreElements.top_menu_items, div.TheCoreElements.top_menu_btn', 'mousewheel', function(e)
    {
        if(typeof e.originalEvent.detail == 'number' && e.originalEvent.detail !== 0)
        {
            if(e.originalEvent.detail > 0)
                top_menu_items_scroll(true);
            else if(e.originalEvent.detail < 0)
                top_menu_items_scroll(false);
        }
        else if (typeof e.originalEvent.wheelDelta == 'number')
        {
            if(e.originalEvent.wheelDelta < 0)
                top_menu_items_scroll(true);
            else if(e.originalEvent.wheelDelta > 0)
                top_menu_items_scroll(false);
        }

        e.preventDefault();

        return true;
    });

    for(var i = 0; i < params.items.length; i++)
    {
        var btn = $('<div class="TheCoreElements top_menu_btn"></div>');
            btn.appendTo(top_menu_items);
        btn.addClass(params.items[i].icon);
        btn.text(params.items[i].title);
        btn.attr('idx', i);
        btn.attr('hash', encodeURI(params.items[i].title));
        btn.attr('element-port', params.items[i].port);
        btn.attr('element-icon', params.items[i].icon);
    };

    top_menu_div.delegate('div.TheCoreElements.top_menu_btn', 'mousedown', function(e)
    {
        var idx = $(this).attr('idx');
        var hash = $(this).attr('hash');
        var port = $(this).attr('element-port');
        var icon = $(this).attr('element-icon');

        window.location.hash = hash;

        oper.empty();
        oper.remove();
        oper = $('<div class="TheCoreElements tab_oper"></div>');
        oper.appendTo(parent_div);

        top_menu_div.find('div.TheCoreElements.top_menu_btn').each(function()
        {
            $(this).removeClass('active');
        });

        $(this).addClass('active');

        if(undefined === params.items[idx].callback)
        {
            if('MATRIX' === icon)
                oper.TheCoreElementsMatrix_attach
                ({
                    'buttons_color' : buttons_color,
                    'port' : port,
                    'inputs': 64,
                    'outputs': 64
                });
            else if('DVE' === icon)
                oper.TheCoreElementsDVE_attach({ 'port' : port});
            else if('ABMIX' === icon)
                oper.TheCoreElementsABMix_attach({ 'port' : port, 'DSK_CNT': 4, });
            else if('MIXER' === icon)
                oper.TheCoreElementsMixer_attach({ 'port' : port});
            else if('MULTI' === icon)
                oper.TheCoreElementsMulti_attach({'port' : port, 'buttons_color' : buttons_color,});
            else if('DSP' === icon)
                oper.TheCoreElementsDSP_attach({'port' : port});
            else if('FLASH' === icon)
                oper.TheCoreElementsFlash_attach({'port' : port});
            else if('OXTEL_PROXY' === icon)
                oper.TheCoreElementsOxtelProxy_attach({'port' : port});
            else if('SUBS_BURN' === icon)
                oper.TheCoreElementsSubsBurn_attach({ 'port' : port});
            else if('SUBS_INS' === icon)
                oper.TheCoreElementsSubsIns_attach({ 'port' : port});
            else if('B1MIX' === icon)
                oper.TheCoreElementsB1Mix_attach({ 'port' : port});
            else if('IO_DRM_OUT' === icon)
                oper.TheCoreElementsIODRMOutput_attach({ 'port' : port});
            else if('IO_NDI_IN' === icon)
                oper.TheCoreElementsIONDIInput_attach({ 'port' : port});
            else if('COLOR' === icon)
                oper.TheCoreElementsColor_attach({ 'port' : port, 'hash' : hash});
            else if('MOSAIC' === icon)
                oper.TheCoreElementsMosaic_attach({ 'port' : port, 'hash' : hash});
            else if('DVE3D' === icon)
                oper.TheCoreElementsDVE3D_attach({ 'port' : port, 'hash' : hash});
            else if('PRV' === icon)
                oper.TheCoreElementsPRV_attach({ 'port' : port, 'hash' : hash});
            else if('DELAY' === icon)
                oper.TheCoreElementsDelay_attach({ 'port' : port, 'hash' : hash});
            else
                alert("Something wrong: app=[" + icon + "]");
        }
        else
            params.items[idx].callback(oper);
    });

    if(window.location.hash == "")
        window.location.hash = params.items[0].title;
    top_menu_div.find('div.TheCoreElements.top_menu_btn').each(function(idx)
    {
//        console.log('idx=' + idx + ', window.location.hash=[' + window.location.hash + '], hash=[' + $(this).attr('hash') + ']');
        if(window.location.hash == ('#' + $(this).attr('hash')))
            $(this).trigger('mousedown');
    });
};
