$.fn.TheCoreElementsPresets_attach = function(params)
{
    var parent_div = this;
    var presets = [];
    var last_selected_id;

    console.log("TheCoreElementsPresets: collection=" + params['collection']);

    var spn = $('<span class="TheCoreElementsPresets">PRESETS:</span>');
        spn.appendTo(parent_div);

    var sel = $('<select class="TheCoreElementsPresets"></select>');
        sel.appendTo(parent_div);
        sel.attr('id' , params['collection']);

    o = $('<option func="none"></option>');
    o.appendTo(sel);
    o = $('<option func="reset">Reset</option>');
    o.appendTo(sel);
    o = $('<option func="save">Save</option>');
    o.appendTo(sel);
    o = $('<option func="save_as">Save As..</option>');
    o.appendTo(sel);
    o = $('<option func="remove">Remove</option>');
    o.appendTo(sel);

    var opt_presets = $('<optgroup label="Load presets"></optgroup>');
        opt_presets.appendTo(sel);

    function load_presets_list()
    {
        sel.prop('disabled', true);

        $.getJSON
        (
            'TheCoreElementsPresets.php',
            {
                'action' : 'list_all',
                'collection' : params['collection']
            }
        )
        .done(function(list)
        {
            opt_presets.children().remove();

            // https://developer.mozilla.org/uk/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach
            list.forEach(function(item)
            {
                var o = $('<option></option>');
                o.appendTo(opt_presets);
                o.attr('func', 'preset');
                o.attr('value', item['_id']);
                o.text(item['_title']);
            });

            sel.prop('disabled', false);

            presets = list;
        })
        .fail(function(msg)
        {
        });
    };

    sel.on("dirty", function()
    {
        function preset_cmp(item, curr)
        {
            for(var k in curr)
                if(undefined === item[k] || item[k] != curr[k])
                    return false;

            return true;
        };

        console.log("DIRTY, i=" + params['cookie']['i']);

        var curr = params['get_values'](params['cookie']);
        var fnd = presets.find(item => preset_cmp(item, curr));

        if(undefined === last_selected_id)
        {
            console.log("curr=" + JSON.stringify(curr));
            console.log("fnd=" + fnd);

            if(fnd !== undefined)
            {
                if(fnd instanceof Array) fnd = fnd.shift();

                if(parent_div.hasClass('dirty'))
                    parent_div.removeClass('dirty');

                var o = sel.find('option[value="' + fnd["_id"] + '"]').first();
                o.attr('selected', 'selected');
                last_selected_id = fnd["_id"];
            }
        }
        else
        {
            if(!parent_div.hasClass('dirty'))
                parent_div.addClass('dirty');

            if(fnd !== undefined)
            {
                if(fnd instanceof Array) fnd = fnd.shift();

                if(fnd['_id'] == last_selected_id)
                    parent_div.removeClass('dirty');
            };
        };
    });

    sel.on("change", function()
    {
        var o = sel.find('option:selected').first();
        if(o !== undefined)
        {
            var func = o.attr('func');
            console.log("func=" + func);
            if(func == 'save_as')
            {
                var title = window.prompt('Enter name for preset');
                if(title == null || title == "")
                {
                    console.log('restore previous value');
                }
                else
                {
                    var preset = params['get_values'](params['cookie']);
                    preset['_title'] = title;

                    $.post
                    (
                        'TheCoreElementsPresets.php',
                        {
                            'action' : 'save_as',
                            'collection' : params['collection'],
                            'preset' : JSON.stringify(preset)
                        }
                    )
                    .done
                    (
                        function(item)
                        {
                            console.log('item=' + JSON.stringify(item));
                            // append to presets list
                            presets.push(item);

                            // append select option
                            var o = $('<option></option>');
                            o.appendTo(opt_presets);
                            o.attr('func', 'preset');
                            o.attr('value', item['_id']);
                            o.text(item['_title']);

                            sel.find('option:selected').prop('selected', false);
                            o.prop('selected', true);

                            last_selected_id = item['_id'];

                            if(parent_div.hasClass('dirty'))
                                parent_div.removeClass('dirty');
                        }
                    );
                };
            }
            else if(func == 'save')
            {
                // drop selection
                sel.find('option:selected').prop('selected', false);

                if(undefined === last_selected_id)
                {
                    // restore selection
                    sel.find('option[func="none"]').prop('selected', true);
                }
                else
                {
                    var i;
                    var curr = params['get_values'](params['cookie']);
                    for(i = 0; i < presets.length; i++)
                    {
                        if(presets[i]['_id'] != last_selected_id)
                            continue;
                        for(var k in curr)
                            presets[i][k] = curr[k];
                        break;
                    };

                    sel.prop('disabled', true);

                    $.post
                    (
                        'TheCoreElementsPresets.php',
                        {
                            'action' : 'save',
                            'collection' : params['collection'],
                            '_id' : last_selected_id,
                            'preset' : JSON.stringify(curr)
                        }
                    )
                    .done
                    (
                        function(curr)
                        {
                            console.log("restoring selection after save");

                            // drop selection
                            if(parent_div.hasClass('dirty'))
                                parent_div.removeClass('dirty');
                            sel.prop('disabled', false);
                            sel.find('option[func="preset"][value="' + last_selected_id + '"]').prop('selected', true);
                        }
                    );

                };
            }
            else if(func == 'reset')
            {
                // drop selection
                sel.find('option:selected').prop('selected', false);

                if(undefined === last_selected_id)
                {
                    // restore selection
                    sel.find('option[func="none"]').prop('selected', true);
                }
                else
                {
                    var p = presets.find(preset => (preset['_id'] == last_selected_id));
                    params['set_values'](p, params['cookie']);
                    sel.find('option[func="preset"][value="' + last_selected_id + '"]').prop('selected', true);
                };
            }
            else if(func == 'remove')
            {
                if(undefined !== last_selected_id)
                {
                    // get id to remove
                    console.log("deleting _id=" + last_selected_id);

                    // remove from select list
                    sel.find('option[value="' + last_selected_id + '"]').remove();

                    sel.prop('disabled', true);
                    $.post
                    (
                        'TheCoreElementsPresets.php',
                        {
                            'action' : 'remove',
                            'collection' : params['collection'],
                            '_id' : last_selected_id
                        }
                    )
                    .done
                    (
                        function(curr)
                        {
                            // drop selection
                            sel.find('option:selected').prop('selected', false);
                            sel.find('option[func="none"]').prop('selected', true);

                            // last selected is not defined now
                            last_selected_id = undefined;

                            sel.prop('disabled', false);
                        }
                    );
                };
            }
            else if(func == 'preset')
            {
                last_selected_id = o.val();
                var p = presets.find(preset => (preset['_id'] == o.val()));
                params['set_values'](p, params['cookie']);
            };

        };
//        console.log("o=" + o);
        sel.blur();
    });

    load_presets_list();
};
