$.fn.TheCoreElementsColor_attach = function(params)
{
    var sel, i;
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsColor main"></div>');
    main_div.appendTo(parent_div);

    // -------------------------

    var pins_div = $('<div class="TheCoreElementsColor pins"></div>');
        pins_div.appendTo(main_div);

    $('<h1>Connections</h1>').appendTo(pins_div);
    {
        var row, t, img;

        row = $('<div class="TheCoreElementsColor thin_row"></div>');
        row.appendTo(pins_div);

        t = $('<span class="title"></span>');
        t.appendTo(row);
        t.text('OUTPUT:');
        {
            sel = $('<select class="TheCoreElementsColor MATRIX_PIN_SELECT"></select>');
            sel.prop('disabled', true);
            sel.appendTo(row);
            sel.addClass('OUTPUT');
            row.delegate('select.MATRIX_PIN_SELECT', 'change', function(e)
            {
                console.log('Input changed');
                var sel = $(this);
                var pin = sel.find('option:selected').val();

                console.log("input pin=" + pin);

                if(pin !== undefined)
                {
                    console.log("pin=" + pin);

                    $.getJSON
                    (
                        'TheCoreElementsColor.SetPin.php',
                        {
                            'xmlrpc_port' : params['port'],
                            'dir' : 1,
                            'pin' : pin
                        }
                    )
                    .done(function()
                    {
                        GetTally();
                    });
                };
            });
        };

        row = $('<div class="TheCoreElementsColor thin_row"></div>');
        row.appendTo(pins_div);
        img = $('<img alt="output preview" src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" class="TheCoreElementsColor MATRIX_PIN_PRV OUTPUT"/>');
        img.appendTo(row);

        row = $('<div class="TheCoreElementsColor thin_row"><hr></div>');
        row.appendTo(pins_div);

        t = $('<span class="title"></span>');
        t.appendTo(row);
        t.text('INPUT:');
        {
            sel = $('<select class="TheCoreElementsColor MATRIX_PIN_SELECT"></select>');
            sel.prop('disabled', true);
            sel.appendTo(row);
            sel.addClass('INPUT');
            row.delegate('select.MATRIX_PIN_SELECT', 'change', function(e)
            {
                console.log('Input changed');
                var sel = $(this);
                var pin = sel.find('option:selected').val();

                console.log("input pin=" + pin);

                if(pin !== undefined)
                {
                    console.log("pin=" + pin);

                    $.getJSON
                    (
                        'TheCoreElementsColor.SetPin.php',
                        {
                            'xmlrpc_port' : params['port'],
                            'dir' : 0,
                            'pin' : pin
                        }
                    )
                    .done(function()
                    {
                        GetTally();
                    });
                };
            });
        };

        row = $('<div class="TheCoreElementsColor thin_row"></div>');
        row.appendTo(pins_div);
        img = $('<img alt="output preview" src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" class="TheCoreElementsColor MATRIX_PIN_PRV INPUT"/>');
        img.appendTo(row);
    };

    /* open in tab image */
    main_div.delegate("img.TheCoreElementsColor.MATRIX_PIN_PRV", "click", function(e)
    {
        var u = $(this).attr('src');

        console.log('src1=' + u);

        if(u.indexOf('-5-5.jpg') > 0)
            u = u.replace('-5-5.jpg', '-0-0.jpg');
        else if(u.indexOf('-2-5.jpg') > 0)
            u = u.replace('-2-5.jpg', '-0-0.jpg');
        else
            u = "";

        console.log('src2=' + u);

        if(u != "")
        {
            var win = window.open(u, '_blank');
            win.focus();
        };
    });

    // -------------------------

    var funcs_div = $('<div class="TheCoreElementsColor funcs"></div>');
        funcs_div.appendTo(main_div);
    var h1 = $('<h1>Functions:</h1>');
        h1.appendTo(funcs_div);

    var funcs_desc =
    [
        {
            name: 'EQ',
            params:
            [
                {
                    title: 'Parameters',
                    proc: func_x_title_create,
                },
                {
                    name: 'contrast',
                    title: 'Contrast',
                    proc: func_x_slider_create,
                    min: -100, max: 300, def: 100, div: 100,
                },
                {
                    name: 'brightness',
                    title: 'Brightness',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },
                {
                    name: 'saturation',
                    title: 'Saturation',
                    proc: func_x_slider_create,
                    min: 0, max: 300, def: 100, div: 100,
                },
                {
                    name: 'gamma',
                    title: 'Gamma',
                    proc: func_x_slider_create,
                    min: 1, max: 100, def: 10, div: 10,
                },
                {
                    name: 'gamma_r',
                    title: 'Gamma R.',
                    proc: func_x_slider_create,
                    min: 1, max: 100, def: 10, div: 10,
                },
                {
                    name: 'gamma_g',
                    title: 'Gamma G.',
                    proc: func_x_slider_create,
                    min: 1, max: 100, def: 10, div: 10,
                },
                {
                    name: 'gamma_b',
                    title: 'Gamma B.',
                    proc: func_x_slider_create,
                    min: 1, max: 100, def: 10, div: 10,
                },
                {
                    name: 'gamma_weight',
                    title: 'Gamma Weight',
                    proc: func_x_slider_create,
                    min: 0, max: 100, def: 100, div: 100,
                },
            ]
        },
        {
            name: 'Balance',
            params:
            [
                {
                    title: 'Preserve lightness',
                    name: 'pl',
                    proc: func_x_checkbox_create,
                },
                {
                    title: 'Shadows',
                    proc: func_x_title_create,
                },
                {
                    name: 'rs',
                    title: 'Cyan/Red',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },
                {
                    name: 'gs',
                    title: 'Magenta/Green',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },
                {
                    name: 'bs',
                    title: 'Yellow/Blue',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },

                {
                    title: 'Midtones',
                    proc: func_x_title_create,
                },
                {
                    name: 'rm',
                    title: 'Cyan/Red',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },
                {
                    name: 'gm',
                    title: 'Magenta/Green',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },
                {
                    name: 'bm',
                    title: 'Yellow/Blue',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },

                {
                    title: 'Highlights',
                    proc: func_x_title_create,
                },
                {
                    name: 'rh',
                    title: 'Cyan/Red',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },
                {
                    name: 'gh',
                    title: 'Magenta/Green',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },
                {
                    name: 'bh',
                    title: 'Yellow/Blue',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 100,
                },
            ]
        },
        {
            name: 'Hue',
            params:
            [
                {
                    title: 'Parameters',
                    proc: func_x_title_create,
                },
                {
                    name: 'h',
                    title: 'Hue angle',
                    proc: func_x_slider_create,
                    min: -180, max: 180, def: 0, div: 1,
                },
                {
                    name: 'b',
                    title: 'Brightness',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 0, div: 10,
                },
                {
                    name: 's',
                    title: 'Saturation',
                    proc: func_x_slider_create,
                    min: -100, max: 100, def: 10, div: 10,
                },
            ]
        }
    ];
    for(i = 0; i < funcs_desc.length; i++)
    {
        var j;
        var func = funcs_desc[i];

        var rad = $('<input type="radio" class="TheCoreElementsColor FUNCS_SWITCH" name="func_selector">');
            rad.appendTo(h1);
            rad.attr('value', i);
        var name = $('<span class="TheCoreElementsColor FUNCS_SWITCH"></span>');
            name.appendTo(h1);
            name.text(func['name']);
            name.attr('idx', i);

        var func_div = $('<div class="TheCoreElementsColor func"></div>');
            func_div.appendTo(funcs_div);
            func_div.attr('idx', i);
        var prst_div = $('<div class="TheCoreElementsPresets main_fr"></div>');
            prst_div.appendTo(func_div);
            prst_div.attr('idx', i);
            prst_div.TheCoreElementsPresets_attach
            ({
                'cookie' : { 'i' : i, 'func' : func },
                'collection' : (params['hash'] + '/' + func['name']),
                'get_values' : function (cookie)
                {
///                    console.log('get_values: cookie=' + JSON.stringify(cookie))
                    var j, r = {};

                    for(j = 0; j < cookie['func']['params'].length; j++)
                    {
                        var v, n = cookie['func']['params'][j].name;

                        if(n === undefined)
                            continue;

                        if(func_x_slider_create == cookie['func']['params'][j].proc)
                        {
                            v = func_x_slider_find(cookie['i'], n).val();
                        }
                        else if(func_x_checkbox_create == cookie['func']['params'][j].proc)
                        {
                            var e = func_x_checkbox_find(cookie['i'], n);
                            v = e.prop('checked') ? 1 : 0;
                        }

                        r[cookie['func']['params'][j]['name']] = v;
                    };

                    return r;
                },
                'set_values' : function (preset, cookie)
                {
                    var j;

///                    console.log('set_values: ' + JSON.stringify(preset))
                    for(j = 0; j < cookie['func']['params'].length; j++)
                    {
                        var n = cookie['func']['params'][j].name;
                        if(n === undefined)
                            continue;

                        var v = preset[n];
                        if(v === undefined)
                            continue;

                        if(func_x_slider_create == cookie['func']['params'][j].proc)
                            func_x_slider_update(cookie['i'], n, v, 1);
                        else if(func_x_checkbox_create == cookie['func']['params'][j].proc)
                            func_x_checkbox_update(cookie['i'], n, v, 1);
                    };
                }
            });
        var btn = $('<button class="TheCoreElementsColor func_enable_disable func_enable">ENABLE ' + func['name'] + '</button>');
            btn.attr('idx', i);
            btn.appendTo(func_div);
            btn.hide();
        var btn = $('<button class="TheCoreElementsColor func_enable_disable func_disable">DISABLE ' + func['name'] + '</button>');
            btn.attr('idx', i);
            btn.appendTo(func_div);
            btn.hide();
        var params_div = $('<div class="TheCoreElementsColor func_params"></div>');
            params_div.attr('idx', i);
            params_div.appendTo(func_div);
            params_div.hide();

        for(j = 0; j < func['params'].length; j++)
            func['params'][j].proc(params_div, i, func['params'][j]);
    };

    /* switch selectors, save state */
    function getCookie(name)
    {
        var v = document.cookie.match('(^|;) ?' + name + '=([^;]*)(;|$)');
        return v ? v[2] : null;
    };
    var curr_func = getCookie('TheCoreElementsColor_func_idx');
    if(!curr_func) curr_func = 0;
    console.log('curr_func=' + curr_func);
    funcs_div.find('input[type="radio"][name="func_selector"][value="' + curr_func + '"].TheCoreElementsColor.FUNCS_SWITCH')
    .each(function(index){
        console.log('SETTING: ' + $(this).attr('value'));
        $(this).attr('checked', 'checked');
        process_radio_switch($(this));
    });
    // -------------------------
    function process_radio_switch(rad_inp)
    {
        var val = rad_inp.val();
        console.log("FUNCS_SWITCH: val=" + val);
        document.cookie = "TheCoreElementsColor_func_idx=" + val + ";";
        funcs_div.find('div.TheCoreElementsColor.func').each(function(index){
            $(this).hide();
            console.log("HIDE here " + $(this).attr('idx'));
        });
        funcs_div.find('div[idx="' + val + '"].TheCoreElementsColor.func').each(function(index){
            $(this).show();
            console.log("SHOW here " + $(this).attr('idx'));
        });
    };
    // -------------------------
    main_div.delegate('input[type="radio"][name="func_selector"].TheCoreElementsColor.FUNCS_SWITCH', "change", function()
    {
        process_radio_switch($(this));
    });
    // -------------------------
    funcs_div.delegate('button.TheCoreElementsColor.func_enable_disable', 'click', function()
    {
        var idx = $(this).attr('idx');
        var en = $(this).hasClass('func_enable') ? 1 : 0;
        $.getJSON
        (
            'TheCoreElementsColor.FuncEn.php',
            {
                'xmlrpc_port' : params['port'],
                'idx' : idx,
                'en' : en
            }
        )
        .done(function()
        {
            GetTally();
        });
        $(this).prop('disabled', true);
    });
    // -------------------------


    /* get matrix pins */
    $.getJSON
    (
        'TheCoreElementsColor.GetLabels.php',
        {
            'xmlrpc_port' : params['port']
        }
    )
    .done(function(labels)
    {
        console.log("GetLabels:" + JSON.stringify(labels));
        pins_div.find('select.MATRIX_PIN_SELECT').each(function()
        {
            matrix_pins_selector_list_setup($(this), labels)
            $(this).prop('disabled', false);
        });

        GetTally();
    });

    var GetTallyTimeout = setTimeout(function(){ GetTelly(); }, 30000);

    function GetTally()
    {
        $.getJSON
        (
            'TheCoreElementsColor.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(resp)
        {
            var amend_resp = parseInt(resp.amend);
            var timeout_dur = 800;
            if(amend < amend_resp)
            {
                amend = amend_resp;
                UpdateUI(resp);
                timeout_dur = 200;
            };
            clearTimeout(GetTallyTimeout);
            GetTallyTimeout = setTimeout(function(){ GetTally(); }, timeout_dur);
        });
    };

    function UpdateUI(resp)
    {
        var i;
        console.log("Update UI");

        /* update prv images */
        pins_div.find('img.MATRIX_PIN_PRV').each(function(index)
        {
            var img = $(this);
            var u, pin = parseInt(img.hasClass('OUTPUT') ? resp.out : resp.inp);
            if(pin)
                u = "http://" + window.location.hostname + ":89/" + ((pin < 0) ? ('i' + (-pin)) : ('o' + pin)) + '-2-5.jpg';
            else
                u = 'data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=';

            img.attr('src', u);

            console.log('img: ' + u);
        });

        /* update pins selection */
        pins_div.find('select.MATRIX_PIN_SELECT').each(function(index)
        {
            var sel = $(this);
            var t = parseInt(sel.hasClass('OUTPUT') ? resp.out : resp.inp);

            sel.find('option').each(function(index)
            {
                var o = $(this);
                var v = parseInt(o.val());
                o.attr('selected', t == v ? 'selected' : null);
            });
        });

        for(i = 0; i < resp.funcs.length && i < funcs_desc.length; i++)
        {
            var en = parseInt(resp.funcs[i].en);

            if(en)
            {
                main_div.find('span[idx="' + i + '"].TheCoreElementsColor.FUNCS_SWITCH').addClass('GREEN');

                funcs_div.find('button[idx="' + i + '"].TheCoreElementsColor.func_enable').hide();
                funcs_div.find('button[idx="' + i + '"].TheCoreElementsColor.func_disable').show();
                funcs_div.find('button[idx="' + i + '"].TheCoreElementsColor.func_disable').prop('disabled', false);
                funcs_div.find('div[idx="' + i + '"].TheCoreElementsColor.func_params').show();
                funcs_div.find('div[idx="' + i + '"].TheCoreElementsPresets').show();
            }
            else
            {
                main_div.find('span[idx="' + i + '"].TheCoreElementsColor.FUNCS_SWITCH').removeClass('GREEN');
                funcs_div.find('button[idx="' + i + '"].TheCoreElementsColor.func_disable').hide();
                funcs_div.find('button[idx="' + i + '"].TheCoreElementsColor.func_enable').show();
                funcs_div.find('button[idx="' + i + '"].TheCoreElementsColor.func_enable').prop('disabled', false);
                funcs_div.find('div[idx="' + i + '"].TheCoreElementsColor.func_params').hide();
                funcs_div.find('div[idx="' + i + '"].TheCoreElementsPresets').hide();
            }

            for(j = 0; j < funcs_desc[i]['params'].length; j++)
            {
                var n = funcs_desc[i]['params'][j].name;
                if(n === undefined)
                    continue;
                var v = resp.funcs[i].params[n];
                if(func_x_slider_create == funcs_desc[i]['params'][j].proc)
                    func_x_slider_update(i, n, v);
                else if(func_x_checkbox_create == funcs_desc[i]['params'][j].proc)
                    func_x_checkbox_update(i, n, v);
            };
        };

    };

    function matrix_pins_selector_list_setup(td_sel, labels)
    {
        var opt, i, d;

        /* disable */
        d = td_sel.prop('disabled');

        /* clear options */
        td_sel.find('option').each(function(index) { $(this).remove(); });
        td_sel.find('optgroup').each(function(index) { $(this).remove(); });

        if(td_sel.hasClass('INPUT'))
        {
        opt = $('<optgroup label="Outputs"></optgroup>');
        opt.appendTo(td_sel);

        for(i = 1; i < labels.outputs.length; i++)
        {
            if("" == labels.outputs[i])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(i);
            o.text(i + ' - ' + labels.outputs[i]);
        };
        };

        if(1)
        {
        opt = $('<optgroup label="Inputs"></optgroup>');
        opt.appendTo(td_sel);

        for(i = 1; i < labels.inputs.length; i++)
        {
            if("" == labels.inputs[i])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(-i);
            o.text(i + ' - ' + labels.inputs[i]);
        };
        };

        var o = $('<option ></option>');
            o.val(0);
            o.appendTo(td_sel);
            o.attr("selected","selected");

        /* enable */
        td_sel.prop('disabled', d);
    };

    function func_x_title_create(parent, idx, param)
    {
        var row, el, el1;

        row = $('<div class="TheCoreElementsColor row"></div>');
        row.appendTo(parent);
        row.attr('func', arguments.callee.name);
        {
            el = $('<div class="title bold"></div>');
            el.text(param['title']);
            el.appendTo(row);
        };
    };

    function func_x_checkbox_create(parent, idx, param)
    {
        var row, el, el1;

        row = $('<div class="TheCoreElementsColor row param_checkbox"></div>');
        row.attr('idx', idx);
        row.attr('param', param['name']);
        row.attr('func', arguments.callee.name);
        row.appendTo(parent);
        {
            el = $('<div class="title"></div>');
            el.text(param['title']);
            el.appendTo(row);

            el = $('<div class="display_holder"></div>');
            el.appendTo(row);

            el1 = $('<input type="checkbox" class="param_checkbox">');
            el1.appendTo(el);

            row.delegate('input[type="checkbox"].param_checkbox', 'change', function()
            {
                var v = $(this).prop('checked') ? 1 : 0;
///                console.log('checkbox modified =' + v);

                if(!($(this).attr('tally')))
                $.getJSON
                (
                    'TheCoreElementsColor.FuncParam.php',
                    {
                        'xmlrpc_port' : params['port'],
                        'idx' : idx,
                        'val' : v,
                        'name': param['name']
                    }
                )
                .done(function()
                {
                    clearTimeout(GetTallyTimeout);
                    GetTallyTimeout = setTimeout(function(){ GetTally(); }, 1000);
//                    GetTally();
                });
                $(this).attr('tally', null);

                funcs_div.find('div[idx="' + idx + '"].TheCoreElementsPresets > select.TheCoreElementsPresets').trigger('dirty');
            });
        };
    };

    function func_x_slider_create(parent, idx, param)
    {
        var row, el;

        row = $('<div class="TheCoreElementsColor row param_slider"></div>');
        row.attr('idx', idx);
        row.attr('param', param['name']);
        row.attr('func', arguments.callee.name);
        row.appendTo(parent);
        {
            var el_range, el_input;

            el = $('<div class="title"></div>');
            el.text(param['title']);
            el.appendTo(row);

            el = $('<div class="button_holder"><button class="step_l param_slider" title="Step DOWN"> - </button></div>');
            el.appendTo(row);

            el = $('<div class="range_holder"></div>');
            el.appendTo(row);

            el_range = $('<input type="range" class="param_slider">');
            el_range.appendTo(el);
            el_range.attr('div', param['div']);
            el_range.attr('min', param['min']);
            el_range.attr('max', param['max']);
            el_range.attr('value', param['def']);
            el_range.attr('step', 1);

            el = $('<div class="button_holder"><button class="step_r param_slider" title="Step UP"> + </button></div>');
            el.appendTo(row);

            el = $('<div class="display_holder"></div>');
            el.appendTo(row);

            el_input = $('<input type="text" class="param_display">');
            el_input.appendTo(el);
            el_input.val(param['def'] / param['div']);

            el = $('<div class="button_holder"><button class="rst param_slider" title="Reset"> R </button></div>');
            el.appendTo(row);

            row.delegate('button.param_slider.rst', 'click', function()
            {
                console.log('Reset');
                el_range.val(param['def']);
                el_range.trigger('input');
            });

            row.delegate('button.param_slider.step_r', 'click', function()
            {
                var v = parseInt(el_range.val()) + parseInt(el_range.attr('step'));
                if(v <= parseInt(el_range.attr('max')))
                {
                    el_range.val(v);
                    el_range.trigger('input');
                };
            });

            row.delegate('button.param_slider.step_l', 'click', function()
            {
                var v = parseInt(el_range.val()) - parseInt(el_range.attr('step'));
                if(v >= parseInt(el_range.attr('min')))
                {
                    el_range.val(v);
                    el_range.trigger('input');
                };
            });

            row.delegate('input[type="range"].param_slider', 'change', function()
            {
                console.log('slider modified:' + $(this).val());
            });

            row.delegate('input[type="range"].param_slider', 'input', function()
            {
///                console.log('slider input:' + $(this).val());
                el_input.val($(this).val() / parseInt($(this).attr('div')));
///                console.log('slider details: idx=' + idx + ', name=' + param['name']);

                if(!($(this).attr('tally')))
                $.getJSON
                (
                    'TheCoreElementsColor.FuncParam.php',
                    {
                        'xmlrpc_port' : params['port'],
                        'idx' : idx,
                        'val' : parseInt($(this).val()),
                        'name': param['name']
                    }
                )
                .done(function()
                {
                    clearTimeout(GetTallyTimeout);
                    GetTallyTimeout = setTimeout(function(){ GetTally(); }, 1000);
//                    GetTally();
                });
                $(this).attr('tally', null);

                funcs_div.find('div[idx="' + idx + '"].TheCoreElementsPresets > select.TheCoreElementsPresets').trigger('dirty');
            });

            row.delegate('input[type="text"].param_display', 'change', function()
            {
                console.log('display modified');
                var v = parseFloat($(this).val());
                if(isNaN(v))
                    v = el_range.attr('def');
                else
                    v = parseInt(v * el_range.attr('div'));
                el_range.val(v);
                el_range.trigger('input');
            });
        };
    };

    function func_x_slider_find(i, n)
    {
        return funcs_div.find('div[idx="' + i + '"][param="' + n + '"].TheCoreElementsColor.row.param_slider div.range_holder input[type="range"].param_slider');
    };

    function func_x_slider_update(i, n, v, frc)
    {
///        console.log("func_x_slider_update(i=" + i + ", n=" + n + ", v=" + v + ")");

        func_x_slider_find(i, n).each(function()
        {
            $(this).val(v);
            if(undefined === frc)
            $(this).attr('tally', 1);
            $(this).trigger('input');
///            console.log("slider");
        });
    };

    function func_x_checkbox_find(i, n)
    {
        return funcs_div.find('div[idx="' + i + '"][param="' + n + '"].TheCoreElementsColor.row.param_checkbox input[type="checkbox"].param_checkbox')
    };

    function func_x_checkbox_update(i, n, v, frc)
    {
        console.log("func_x_checkbox_update(i=" + i + ", n=" + n + ", v=" + v + ")");

        func_x_checkbox_find(i, n).each(function()
        {
            $(this).prop('checked', parseInt(v) ? true : false);
//            console.log("checkbox=" + v);
            if(undefined === frc)
            $(this).attr('tally', 1);
            $(this).trigger('change');
        });
    };
}
