$(document).ready(function ()
{

    // if user is running mozilla then use it's built-in WebSocket
    window.WebSocket = window.WebSocket || window.MozWebSocket;

    // if browser doesn't support WebSocket, just show
    // some notification and exit
    if (!window.WebSocket)
    {
        console.log("Websockets not supported");
        return;
    };


    // open connection
    var host = window.location.hostname;
    var ws_main = new WebSocket('ws://' + host + ':38001');
    var ws_logger = new WebSocket('ws://' + host + ':38001', 'logger');

//---------
    ws_main.onopen = function ()
    {
        // first we want users to enter their names
        console.log("Main Connected to " + host);
    };
    ws_logger.onopen = function ()
    {
        // first we want users to enter their names
        console.log("Logger Connected to " + host);
    };
//---------
    ws_main.onclose = function ()
    {
        // first we want users to enter their names
        console.log("Main Closed to " + host);
    };
    ws_logger.onclose = function ()
    {
        // first we want users to enter their names
        console.log("Logger Closed to " + host);
    };
//---------
    ws_main.onerror = function(error)
    {
        console.log("Main Connection error: " + error);
    };
    ws_logger.onerror = function(error)
    {
        console.log("Logger Connection error: " + error);
    };
//---------

    // most important part - incoming messages
    ws_logger.onmessage = function(message)
    {
        var msg = message.data;
        $('#responce').html('&gt; ' + msg + '<br>' + $('#responce').html());
    };

    function cmd_text()
    {
        var msg = $('#cmd_text').val();
        $('#responce').html('&lt; ' + msg + '<br>' + $('#responce').html());
        ws_main.send(msg);
    };

    $('body').delegate("#cmd_btn", "click", function()
    {
        cmd_text();
    });


    $('body').delegate("#cmd_text", "keydown", function(e)
    {
        var code = (e.keyCode ? e.keyCode : e.which);

        /* enter */
        if(13 == code)
        {
            e.preventDefault();
            e.stopPropagation();
            cmd_text();

            return false;
        }
    });

});
