$.fn.TheCoreElementsMixer_attach = function(params)
{
    var b;
    var parent_div = this;

    var tab_switcher = $('<div class="TheCoreElementsMixer tab_switcher"></div>');
    tab_switcher.appendTo(parent_div);

    var oper = $('<div class="TheCoreElementsMixer tab_oper"></div>');
    oper.appendTo(parent_div);

    b = $('<div class="TheCoreElementsMixer tab_switch CONF"></div>');
    b.appendTo(tab_switcher);

    b = $('<div class="TheCoreElementsMixer tab_switch VIDEO"></div>');
    b.appendTo(tab_switcher);

    b = $('<div class="TheCoreElementsMixer tab_switch AUDIO"></div>');
    b.appendTo(tab_switcher);

    tab_switcher.delegate("div.TheCoreElementsMixer.tab_switch", "mousedown", function()
    {
        tab_switcher.find('div.TheCoreElementsMixer.tab_switch').removeClass('active');
        $(this).addClass('active');

        oper.empty();
        oper.remove();
        oper = $('<div class="TheCoreElementsMixer tab_oper"></div>');
        oper.appendTo(parent_div);

        if($(this).hasClass('CONF'))
        {
            console.log("TheCoreElementsMixer.tab_switch: CONF");

            var main_div = $('<div class="TheCoreElementsMixer control main"></div>');
            main_div.appendTo(oper);

            var table = $('<table width="100%" border="0" cellpadding="0" cellspacing="0"></table>');
                table.appendTo(main_div);

            var tr = $('<tr valign="top"></tr>');
                tr.appendTo(table);

            var td_video = $('<td align="center" width="50%"></td>');
                td_video.appendTo(tr);

            var td_audio = $('<td align="center" width="50%"></td>');
                td_audio.appendTo(tr);

            td_video.TheCoreElementsMixer_video_connections_attach
            ({
                'port' : params['port'],
                'src_limit' : 8,
            });

            td_audio.TheCoreElementsMixer_audio_connections_attach
            ({
                'port' : params['port'],
            });
        }
        else if($(this).hasClass('VIDEO'))
        {
            console.log("TheCoreElementsMixer.tab_switch: VIDEO");

            oper.TheCoreElementsMixer_video_control_attach
            ({
                'port' : params['port'],
            });
        }
        else if($(this).hasClass('AUDIO'))
        {
            console.log("TheCoreElementsMixer.tab_switch: AUDIO");

            oper.TheCoreElementsMixer_audio_control_attach
            ({
                'port' : params['port'],
            });
        };
    });

    tab_switcher.find('div.TheCoreElementsMixer.tab_switch.VIDEO').trigger('mousedown');
};

$.fn.TheCoreElementsMixer_video_control_attach = function(params)
{
    var b;
    var f_exit = 0;
    var parent_div = this;
    var amend = -1;
    var tally_amend = -1;
    var titles_amend = -1;

    parent_div.bind('destroyed', function() {
        console.log("f_exit = 1");
        f_exit = 1;
    });

    function rate_input_create(c)
    {
        var b = $('<div class="TheCoreElementsMixer rate_input"><span><div>Rate</div><input type="text"></span></div>');
        b.addClass(c);
        return b;
    };

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsMixer control main"></div>');
    main_div.appendTo(parent_div);

    var tr, table = $('<table width="100%" cellpading="0" cellspacing="0" border="0"></table>'); table.appendTo(main_div);

    tr = $('<tr valign="top"></tr>'); tr.appendTo(table);
    {
        var td;

        td = $('<td></td>'); td.appendTo(tr);
        {
            var div = $('<div></div>'); div.appendTo(td);
            var h = $('<h1 class="TheCoreElementsMixer buttons_holder">Program</h1>'); h.appendTo(div);
            var d = $('<div class="TheCoreElementsMixer buttons_holder"></div>'); d.appendTo(div);
            for(var i = 0; i < 8; i++)
            {
                var b = $('<div class="TheCoreElementsMixer push_btn red program_src"><span></span></div>');
                b.appendTo(d);
                b.attr('idx', i);
                if(i == 5)
                {
                    $('<br>').appendTo(d);
                    b = $('<div class="TheCoreElementsMixer push_btn_space"></div>'); b.appendTo(d);
                    $('<br>').appendTo(d);
                };
            };
        };

        td = $('<td></td>'); td.appendTo(tr);
        {
            var div = $('<div></div>'); div.appendTo(td);
            var h = $('<h1 class="TheCoreElementsMixer buttons_holder">Next transition</h1>'); h.appendTo(div);
            var d = $('<div class="TheCoreElementsMixer buttons_holder"></div>'); d.appendTo(div);
            var b;

            b = $('<div class="TheCoreElementsMixer push_btn_space"></div>'); b.appendTo(d);

            b = $('<div class="TheCoreElementsMixer push_btn red program_key"><span>ON<br>AIR</span></div>');
                b.appendTo(d); b.attr('idx', 0);
            b = $('<div class="TheCoreElementsMixer push_btn red program_key"><span>ON<br>AIR</span></div>');
                b.appendTo(d); b.attr('idx', 1);
            b = $('<div class="TheCoreElementsMixer push_btn red program_key"><span>ON<br>AIR</span></div>');
                b.appendTo(d); b.attr('idx', 2);
            b = $('<div class="TheCoreElementsMixer push_btn red program_key"><span>ON<br>AIR</span></div>');
                b.appendTo(d); b.attr('idx', 3);

            $('<br>').appendTo(d);
            b = $('<div class="TheCoreElementsMixer push_btn_space"></div>'); b.appendTo(d);
            $('<br>').appendTo(d);

            b = $('<div class="TheCoreElementsMixer push_btn yellow bkng"><span>BKNG</span></div>');
                b.appendTo(d);
            b = $('<div class="TheCoreElementsMixer push_btn yellow preview_key"><span>KEY 1</span></div>');
                b.appendTo(d); b.attr('idx', 0);
            b = $('<div class="TheCoreElementsMixer push_btn yellow preview_key"><span>KEY 2</span></div>');
                b.appendTo(d); b.attr('idx', 1);
            b = $('<div class="TheCoreElementsMixer push_btn yellow preview_key"><span>KEY 3</span></div>');
                b.appendTo(d); b.attr('idx', 2);
            b = $('<div class="TheCoreElementsMixer push_btn yellow preview_key"><span>KEY 4</span></div>');
                b.appendTo(d); b.attr('idx', 3);
        };

        td = $('<td rowspan="2"></td>'); td.appendTo(tr);
        {
        };

        td = $('<td></td>'); td.appendTo(tr);
        {
            var div = $('<div></div>'); div.appendTo(td);
            var h = $('<h1 class="TheCoreElementsMixer buttons_holder">DSK</h1>'); h.appendTo(div);
            var d = $('<div class="TheCoreElementsMixer buttons_holder"></div>'); d.appendTo(div);
            var b;

            b = $('<div class="TheCoreElementsMixer push_btn yellow preview_dsk"><span>TIE</span></div>');
                b.appendTo(d); b.attr('idx', 0);
            b = $('<div class="TheCoreElementsMixer push_btn yellow preview_dsk"><span>TIE</span></div>');
                b.appendTo(d); b.attr('idx', 1);
            b = $('<div class="TheCoreElementsMixer push_btn yellow preview_dsk"><span>TIE</span></div>');
                b.appendTo(d); b.attr('idx', 2);
            b = $('<div class="TheCoreElementsMixer push_btn yellow preview_dsk"><span>TIE</span></div>');
                b.appendTo(d); b.attr('idx', 3);

            $('<br>').appendTo(d);

            b = rate_input_create('dsk'); b.appendTo(d);
                b.appendTo(d); b.attr('idx', 0);
            b = rate_input_create('dsk'); b.appendTo(d);
                b.appendTo(d); b.attr('idx', 1);
            b = rate_input_create('dsk'); b.appendTo(d);
                b.appendTo(d); b.attr('idx', 2);
            b = rate_input_create('dsk'); b.appendTo(d);
                b.appendTo(d); b.attr('idx', 3);

            $('<br>').appendTo(d);

            b = $('<div class="TheCoreElementsMixer push_btn red program_dsk"><span>ON<br>AIR</span></div>');
                b.appendTo(d); b.attr('idx', 0);
            b = $('<div class="TheCoreElementsMixer push_btn red program_dsk"><span>ON<br>AIR</span></div>');
                b.appendTo(d); b.attr('idx', 1);
            b = $('<div class="TheCoreElementsMixer push_btn red program_dsk"><span>ON<br>AIR</span></div>');
                b.appendTo(d); b.attr('idx', 2);
            b = $('<div class="TheCoreElementsMixer push_btn red program_dsk"><span>ON<br>AIR</span></div>');
                b.appendTo(d); b.attr('idx', 3);

            $('<br>').appendTo(d);

            b = $('<div class="TheCoreElementsMixer push_btn yellow auto_dsk"><span>AUTO</span></div>');
                b.appendTo(d); b.attr('idx', 0);
            b = $('<div class="TheCoreElementsMixer push_btn yellow auto_dsk"><span>AUTO</span></div>');
                b.appendTo(d); b.attr('idx', 1);
            b = $('<div class="TheCoreElementsMixer push_btn yellow auto_dsk"><span>AUTO</span></div>');
                b.appendTo(d); b.attr('idx', 2);
            b = $('<div class="TheCoreElementsMixer push_btn yellow auto_dsk"><span>AUTO</span></div>');
                b.appendTo(d); b.attr('idx', 3);

        };
    };

    tr = $('<tr valign="bottom"></tr>'); tr.appendTo(table);
    {
        var td;

        td = $('<td></td>'); td.appendTo(tr);
        {
            var div = $('<div></div>'); div.appendTo(td);
            var h = $('<h1 class="TheCoreElementsMixer buttons_holder">Preview</h1>'); h.appendTo(div);
            var d = $('<div class="TheCoreElementsMixer buttons_holder"></div>'); d.appendTo(div);
            for(var i = 0; i < 8; i++)
            {
                var b = $('<div class="TheCoreElementsMixer push_btn green preview_src"><span></span></div>');
                b.appendTo(d);
                b.attr('idx', i);
                if(i == 5)
                {
                    $('<br>').appendTo(d);
                    b = $('<div class="TheCoreElementsMixer push_btn_space"></div>'); b.appendTo(d);
                    $('<br>').appendTo(d);
                }
            };
        };

        td = $('<td></td>'); td.appendTo(tr);
        {
            var div = $('<div></div>'); div.appendTo(td);
            var h = $('<h1 class="TheCoreElementsMixer buttons_holder">Transition style</h1>'); h.appendTo(div);
            var d = $('<div class="TheCoreElementsMixer buttons_holder"></div>'); d.appendTo(div);
            var b;

            b = $('<div class="TheCoreElementsMixer push_btn yellow transitions"><span>MIX</span></div>');
                b.appendTo(d); b.attr('idx', 0);
            b = $('<div class="TheCoreElementsMixer push_btn yellow transitions"><span>DIP</span></div>');
                b.appendTo(d); b.attr('idx', 1);
            b = $('<div class="TheCoreElementsMixer push_btn yellow transitions"><span>WIPE</span></div>');
                b.appendTo(d); b.attr('idx', 2);
            b = $('<div class="TheCoreElementsMixer push_btn yellow transitions"><span>STING</span></div>');
                b.appendTo(d); b.attr('idx', 3);
            b = $('<div class="TheCoreElementsMixer push_btn yellow transitions"><span>DVE</span></div>');
                b.appendTo(d); b.attr('idx', 4);

            $('<br>').appendTo(d);
            b = $('<div class="TheCoreElementsMixer push_btn_space"></div>'); b.appendTo(d);
            $('<br>').appendTo(d);

            b = $('<div class="TheCoreElementsMixer push_btn yellow ctl cut"><span>CUT</span></div>'); b.appendTo(d);
            b = $('<div class="TheCoreElementsMixer push_btn_space"></div>'); b.appendTo(d);
            b = $('<div class="TheCoreElementsMixer push_btn_space"></div>'); b.appendTo(d);
            b = $('<div class="TheCoreElementsMixer push_btn yellow ctl auto"><span>AUTO</span></div>'); b.appendTo(d);

            b = rate_input_create('transition'); b.appendTo(d);
            b.attr('idx', -1);
        };
    };


    GetTally();

    function UpdateTally(tally)
    {
        console.log("UpdateTally: " + JSON.stringify(tally));

        if(tally != null && (!(typeof tally.amend === 'undefined')))
        {
            var tally_current = parseInt(tally.amend);

            if(tally_amend < tally_current)
            {
                tally_amend = tally_current;
                console.log("UpdateTally: tally_amend=" + tally_amend);

                table.find('div.TheCoreElementsMixer.push_btn.program_src').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if(idx == parseInt(tally.pgm.src))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.push_btn.preview_src').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if(idx == parseInt(tally.prv.src))
                        $(this).addClass('active');
                });


                table.find('div.TheCoreElementsMixer.push_btn.transitions').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if(idx == parseInt(tally.mix))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.push_btn.program_key').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if('1' == tally.pgm.key.substr(idx, 1))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.push_btn.preview_key').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if('1' == tally.prv.key.substr(idx, 1))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.push_btn.program_dsk').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if('1' == tally.pgm.dsk.substr(idx, 1))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.push_btn.preview_dsk').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if('1' == tally.prv.dsk.substr(idx, 1))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.push_btn.auto_dsk').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if('1' == tally.dsk_trans.substr(idx, 1))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.push_btn.bkng').each(function(){
                    var idx = $(this).attr('idx');
                    $(this).removeClass('active');
                    if('1' == parseInt(tally.bkng))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.push_btn.ctl.auto').each(function(){
                    $(this).removeClass('active');
                    if('1' == parseInt(tally.auto))
                        $(this).addClass('active');
                });

                table.find('div.TheCoreElementsMixer.rate_input input').each(function(){
                    var v, idx = parseInt($(this).parent().parent().attr('idx'));

                    if(idx == -1)
                        v = tally.auto_dur;
                    else
                        v = tally.dsk_durs[idx];

                    $(this).attr('tally', v);

                    if(!$(this).is(":focus"))
                        $(this).val(v);
                });
            };

            if(tally.titles_amend != titles_amend)
                GetTitles();
        }
        else
        {
            tally_amend = -1;
            UpdateTitles(null);
        };
    };

    function UpdateTitles(titles)
    {
        console.log("UpdateTitltes: " + JSON.stringify(titles));

        if(titles != null && !(typeof titles.amend === 'undefined'))
        {
            titles_amend = parseInt(titles.amend);

            console.log("UpdateTitles: titles_amend=" + titles_amend);

            table.find('div.TheCoreElementsMixer.push_btn.program_src').each(function(){
                var idx = $(this).attr('idx');
                $(this).find('span').html(titles.titles[idx].replace("/", "<br>"));
            });

            table.find('div.TheCoreElementsMixer.push_btn.preview_src').each(function(){
                var idx = $(this).attr('idx');
                $(this).find('span').html(titles.titles[idx].replace("/", "<br>"));
            });
        }
        else
        {
            titles_amend = -1;
        };
    };

    function GetTally()
    {
        if(f_exit)
            return;

        $.getJSON
        (
            'TheCoreElementsMixer.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            UpdateTally(curr);
            window.setTimeout(function() { GetTally(); }, 1500);
        })
        .fail(function(msg)
        {
            UpdateTally(null);
            window.setTimeout(function() { GetTally(); }, 2500);
        });
    };

    function GetTitles()
    {
        if(-2 == titles_amend)
            return;

        titles_amend = -2;

        $.getJSON
        (
            'TheCoreElementsMixer.GetTitles.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            UpdateTitles(curr);
        })
        .fail(function(msg)
        {
            UpdateTitles(null);
        });
    };

    function rate_input_save(b)
    {
        console.log("Will try to save content");

        var target = 13;
        var idx = b.parent().parent().attr('idx');
        var val = b.val();
        var tally = b.attr('tally');

        if(val == tally)
            return;

        b.prop('disabled', true);

        $.getJSON
        (
            'TheCoreElementsMixer.Act.php',
            {
                'xmlrpc_port' : params['port'],
                'idx' : idx,
                'target' : target,
                'val' : val,
            }
        )
        .done
        (
            function(curr)
            {
                b.prop('disabled', false);
                UpdateTally(curr);
            }
        );
    };

    function rate_input_restore(b)
    {
        console.log("Will try to save content");
        b.val(b.attr('tally'));
    };

    table.delegate("div.TheCoreElementsMixer.rate_input input", "keydown", function(e)
    {
        var code = (e.keyCode ? e.keyCode : e.which);

        console.log("keypress=" + code);

        /* enter */
        if(13 == code)
        {
            e.preventDefault();
            e.stopPropagation();
            $(this).blur();
            return false;
        }

        /* esc */
        if(27 == code)
        {
            e.preventDefault();
            e.stopPropagation();
            rate_input_restore($(this));
            return false;
        }

        /* digits input */
        var txt = String.fromCharCode(e.which);
        if(!txt.match(/[0-9]/))
            return false;

    });

    table.delegate("div.TheCoreElementsMixer.rate_input input", "focusout", function(e)
    {
        rate_input_save($(this));
    });

    table.delegate("div.TheCoreElementsMixer.push_btn", "mousedown", function()
    {
        var target = -1;
        var idx = $(this).attr('idx');

        console.log("push_btn: idx=[" + idx + "]");

        if($(this).hasClass('program_src'))
            target = 0;
        else if($(this).hasClass('preview_src'))
            target = 1;
        else if($(this).hasClass('program_key'))
            target = 2;
        else if($(this).hasClass('preview_key'))
            target = 3;
        else if($(this).hasClass('preview_dsk'))
            target = 4;
        else if($(this).hasClass('program_dsk'))
            target = 5;
        else if($(this).hasClass('auto_dsk'))
            target = 6;
        else if($(this).hasClass('ctl') && $(this).hasClass('cut'))
            target = 7;
        else if($(this).hasClass('ctl') && $(this).hasClass('auto'))
            target = 8;
        else if($(this).hasClass('transitions'))
            target = 9;
        else if($(this).hasClass('bkng'))
            target = 10;

        $.getJSON
        (
            'TheCoreElementsMixer.Act.php',
            {
                'xmlrpc_port' : params['port'],
                'idx' : idx,
                'target' : target,
            }
        )
        .done
        (
            function(curr)
            {
                UpdateTally(curr);
            }
        );
    });
}

$.fn.TheCoreElementsMixer_video_connections_attach = function(params)
{
    var parent_div = this;
    var amend = -1;


    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsMixer main"></div>');
    main_div.appendTo(parent_div);

    var input_header_div = $('<div class="TheCoreElementsMixer header">VIDEO CONNECTORS <button class="connectors_save">SAVE</button></div>');
    input_header_div.appendTo(main_div);

    var input_selectors_div = $('<div class="TheCoreElementsMixer connectors"></div>');
    input_selectors_div.appendTo(main_div);

    function update_connections()
    {
        $.getJSON
        (
            'TheCoreElementsMixer.GetVideoConnections.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(conns)
        {
            input_selectors_div.empty();

            console.log("GetConnections:" + JSON.stringify(conns));

            var srcs = parseInt(conns.srcs), keys = parseInt(conns.keys), dsks = parseInt(conns.dsks);

            // build input selector
            {
                var i;
                var table = $('<table class="TheCoreElementsMixer"></table>');
                table.appendTo(input_selectors_div);
                table.attr('cnt-srcs', srcs);
                table.attr('cnt-keys', keys);
                table.attr('cnt-dsks', dsks);

                var thead = $('<thead></thead>');
                thead.appendTo(table);

                var thead_tr = $('<tr></tr>');
                thead_tr.appendTo(thead);

                $('<th class="TYPE">TYPE</th>').appendTo(thead_tr);
                $('<th class="CONN">CONN</th>').appendTo(thead_tr);
                $('<th class="TITLE">TITLE</th>').appendTo(thead_tr);
                $('<th class="MULT">MULT WIN</th>').appendTo(thead_tr);

                var tbody = $('<tbody></tbody>');
                tbody.appendTo(table);

                function append_row(type, idx, pos, matrix, title, mult)
                {
                    var td;
                    var tr = $('<tr></tr>');
                    tr.appendTo(tbody);
                    tr.attr('row-type', type);
                    tr.attr('row-pos', pos);
                    tr.attr('conn-idx', idx);
                    tr.addClass('CONN');

                    td = $('<td class="TYPE"></td>');
                    if(idx < 0)
                        td.text(type);
                    else
                        td.text(type + '-' + (idx + 1));
                    td.appendTo(tr);

                    td = $('<td class="CONN"></td>');
                    td.appendTo(tr);
                    var td_sel = $('<select class="CONN"></select>');
                    td_sel.attr('row-type', type);
                    td_sel.attr('conn-idx', idx);
                    td_sel.attr('matrix-idx', matrix);
                    td_sel.prop('disabled', true);
                    td_sel.appendTo(td);
                    if(type == 'PRV' || type == 'PGM' || type == 'MULT')
                        td_sel.addClass('CONN_OUTPUT');

                    td = $('<td class="TITLE"></td>');
                    td.appendTo(tr);
                    td_input = $('<input type="input" class="TITLE">');
                    td_input.attr('row-type', type);
                    td_input.attr('conn-idx', idx);
                    td_input.attr('matrix-idx', matrix);
                    td_input.val(title);
                    td_input.appendTo(td);

                    td = $('<td class="MULT"></td>');
                    td.appendTo(tr);
                    var td_sel = $('<select class="MULT"></select>');
                    td_sel.appendTo(td);
                    for(var i = 0; i <= 8; i++)
                    {
                        var o = $('<option></option>');
                        o.appendTo(td_sel);
                        o.val(i);
                        o.text(i ? i : "NONE");
                        if(i == mult)
                            o.attr("selected","selected");
                    };
                };

                var srcs_n = (typeof params['src_limit'] !== 'undefined') ? parseInt(params['src_limit']) : srcs

                // SRCs
                for(i = 0; i < srcs_n; i++)
                    append_row('SRC', i, i,
                        conns.inputs[i].value,
                        conns.inputs[i].title,
                        conns.inputs[i].mult);

                // KEYs
                for(i = 0; i < keys; i++)
                    append_row('KEY', i, srcs + i,
                        conns.inputs[srcs + i].value,
                        conns.inputs[srcs + i].title,
                        conns.inputs[srcs + i].mult);

                // DSKs
                for(i = 0; i < dsks; i++)
                    append_row('DSK', i, keys + srcs + i,
                        conns.inputs[keys + srcs + i].value,
                        conns.inputs[keys + srcs + i].title,
                        conns.inputs[keys + srcs + i].mult);

                append_row('PGM', -1, -1, conns.pgm, '', 0);
                append_row('PRV', -1, -1, conns.prv, '', 0);
                append_row('MULT', -1, -1, conns.mult, '', 0);

                /* update labels */
                $.getJSON
                (
                    'TheCoreElementsMixer.GetLabels.php',
                    {
                        'xmlrpc_port' : params['port'],
                    }
                )
                .done(function(labels)
                {
                    table.find('select.CONN').each(function(index)
                    {
                        var opt;
                        var sel_idx;
                        var td_sel = $(this);
                        var inp = td_sel.attr('conn-idx');
                        var matrix_output = td_sel.attr('matrix-idx');

                        opt = $('<optgroup label="Outputs"></optgroup>');
                        opt.appendTo(td_sel);

                        if(!td_sel.hasClass('CONN_OUTPUT'))
                        for(sel_idx = 1; sel_idx < labels.outputs.length; sel_idx++)
                        {
                            if("" == labels.outputs[sel_idx])
                                continue;

                            var o = $('<option></option>');
                            o.appendTo(opt);
                            o.val(sel_idx);
                            o.text(sel_idx + ' - ' + labels.outputs[sel_idx]);
                            if(sel_idx == matrix_output)
                                o.attr("selected","selected");
                        };

                        opt = $('<optgroup label="Inputs"></optgroup>');
                        opt.appendTo(td_sel);

                        for(sel_idx = 1; sel_idx < labels.inputs.length; sel_idx++)
                        {
                            if("" == labels.inputs[sel_idx])
                                continue;

                            var o = $('<option></option>');
                            o.appendTo(opt);
                            o.val(-sel_idx);
                            o.text(sel_idx + ' - ' + labels.inputs[sel_idx]);
                            if(-sel_idx == matrix_output)
                                o.attr("selected","selected");
                        };

                        td_sel.prop('disabled', false);
                    });
                });
            };
        });
    };

    update_connections();

    input_header_div.delegate("button.connectors_save", "click", function()
    {
        var t = input_selectors_div.find('table.TheCoreElementsMixer');

        var srcs = parseInt(t.attr('cnt-srcs'));
        var keys = parseInt(t.attr('cnt-keys'));
        var dsks = parseInt(t.attr('cnt-dsks'));

        var cnt = srcs + keys + dsks;
        var inputs = new Array(cnt);

        for(var i = 0; i < cnt; i++)
            inputs[i] = {'value': 0, 'title':'', 'mult': 0};

        var conn =
        {
            "pgm": 0,
            "prv": 0,
            "mult": 0,
            'srcs': srcs,
            'keys': keys,
            'dsks': dsks,
        };

        t.find('tr.CONN').each(function(index)
        {
            var type = $(this).attr('row-type');
            var pos = parseInt($(this).attr('row-pos'));
            var idx = parseInt($(this).attr('conn-idx'));

            var c = parseInt($(this).find('select.CONN').val());
            var t = $(this).find('input.TITLE').val();
            var m = parseInt($(this).find('select.MULT').val());

            console.log("type=[" + type + "], pos=" + pos + "], idx=" + idx + ", c=[" + c + "], t=[" + t + "]");

            if(type == 'SRC' || type == 'KEY' || type == 'DSK')
            {
                inputs[pos]['value'] = c;
                inputs[pos]['title'] = t;
                inputs[pos]['mult'] = m;
            }
            else if(type == 'PRV') conn['prv'] = c;
            else if(type == 'PGM') conn['pgm'] = c;
            else if(type == 'MULT') conn['mult'] = c;
        });

        console.log("SetConnections: conn=" + JSON.stringify(conn));
        console.log("SetConnections: inputs=" + JSON.stringify(inputs));

        $.post
        (
            'TheCoreElementsMixer.SetVideoConnections.php',
            {
                'xmlrpc_port' : params['port'],
                'conn': conn,
                'inputs': inputs,
            }
        )
        .done
        (
            function(curr)
            {
                update_connections();
            }
        );
    });
}

$.fn.TheCoreElementsMixer_audio_connections_attach = function(params)
{
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsMixer main"></div>');
    main_div.appendTo(parent_div);

    var input_header_div = $('<div class="TheCoreElementsMixer header">AUDIO CONNECTORS <button class="connectors_save">SAVE</button></div>');
    input_header_div.appendTo(main_div);

    var input_selectors_div = $('<div class="TheCoreElementsMixer connectors"></div>');
    input_selectors_div.appendTo(main_div);

    function update_connections()
    {
        $.getJSON
        (
            'TheCoreElementsMixer.GetAudioConnections.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(conns)
        {
            input_selectors_div.empty();

            console.log("GetConnections:" + JSON.stringify(conns));

            var srcs = parseInt(conns.vc.srcs), keys = parseInt(conns.vc.keys), dsks = parseInt(conns.vc.dsks);

            // build input selector
            {
                var i;
                var table = $('<table class="TheCoreElementsMixer"></table>');
                table.appendTo(input_selectors_div);
                table.attr('row-cnt', conns.list.length);

                var thead = $('<thead></thead>');
                thead.appendTo(table);

                var thead_tr = $('<tr></tr>');
                thead_tr.appendTo(thead);

                $('<th class="FADER">FADER</th>').appendTo(thead_tr);
                $('<th class="TITLE">TITLE</th>').appendTo(thead_tr);
                $('<th class="CONN CONNA">CONN</th>').appendTo(thead_tr);
                $('<th class="LEFT">LEFT</th>').appendTo(thead_tr);
                $('<th class="RIGHT">RIGHT</th>').appendTo(thead_tr);

                var tbody = $('<tbody></tbody>');
                tbody.appendTo(table);

                function append_row(idx, item)
                {
                    var td;
                    var tr = $('<tr></tr>');
                    tr.appendTo(tbody);
                    tr.attr('conn-idx', idx);
                    tr.addClass('CONN');

                    td = $('<td class="FADER"></td>');
                    td.text((idx + 1));
                    td.appendTo(tr);

                    td = $('<td class="TITLE"></td>');
                    td.appendTo(tr);
                    td_input = $('<input type="input" class="TITLE">');
                    td_input.val(item.title);
                    td_input.appendTo(td);

                    td = $('<td class="CONN CONNA"></td>');
                    td.appendTo(tr);
                    var td_sel = $('<select class="CONN CONNA"></select>');
                    td_sel.appendTo(td);
                    for(var i = 0; i <= (srcs + keys + dsks); i++)
                    {
                        var o = $('<option></option>');
                        o.appendTo(td_sel);
                        o.val(i);
                        if(i)
                        {
                            var j = i - 1;
                            var ji = conns.vc.inputs[j];
                            var t = ji.title;
                            if(j >= (srcs + keys))
                                t = "[DSK-" + (j - srcs - keys + 1) + "] - " + t;
                            else if(j >= srcs)
                                t = "[KEY-" + (j - srcs + 1) + "] - " + t;
                            else
                                t = "[SRC-" + (j + 1) + "] - " + t;

                            o.text(t);
                        }
                        else
                            o.text("NONE");

                        if(i == parseInt(item.inp))
                            o.attr("selected","selected");
                    };


                    function channel_selector(c, v)
                    {
                        td = $('<td class="' + c + '"></td>');
                        var td_sel = $('<select class="' + c + '"></select>');
                        td_sel.appendTo(td);
                        for(var i = 0; i < 8; i++)
                        {
                            var o = $('<option></option>');
                            o.appendTo(td_sel);
                            o.val(i);
                            o.text((i + 1));
                            if(i == v)
                                o.attr("selected","selected");
                        };
                        return td;
                    };

                    channel_selector('LEFT', item.l).appendTo(tr);
                    channel_selector('RIGHT', item.r).appendTo(tr);
                };

                console.log("conns.list.length=" + conns.list.length);
                for(i = 0; i < (conns.list.length - 2); i++)
                    append_row(i, conns.list[i]);
            };
        });
    };

    update_connections();

    input_header_div.delegate("button.connectors_save", "click", function()
    {
        var t = input_selectors_div.find('table.TheCoreElementsMixer');

        var cnt = t.attr('row-cnt');

        var inputs = new Array(cnt);

        for(var i = 0; i < cnt; i++)
            inputs[i] = {'title': '', 'inp':0, 'l': 0, 'r': 0};

        t.find('tr.CONN').each(function(index)
        {
            var idx = $(this).attr('conn-idx');
            inputs[idx].title = $(this).find('input.TITLE').val();
            inputs[idx].l = parseInt($(this).find('select.LEFT').val());
            inputs[idx].r = parseInt($(this).find('select.RIGHT').val());
            inputs[idx].inp = parseInt($(this).find('select.CONN').val());
        });

        console.log("SetConnections: inputs=" + JSON.stringify(inputs));

        $.post
        (
            'TheCoreElementsMixer.SetAudioConnections.php',
            {
                'xmlrpc_port' : params['port'],
                'inputs': inputs,
            }
        )
        .done
        (
            function(curr)
            {
                update_connections();
            }
        );
    });
}

$.fn.TheCoreElementsMixer_audio_control_attach = function(params)
{
    var f_exit = 0;
    var FADERS_USER = 8;
    var FADERS_MAP = [/*9, */0, 1, 2, 3, 4, 5, 6, 7, 8];
    var parent_div = this;
    var amend = -1;
    var tally_amend = -1;
    var inputs_amend = -1;
    var titles_amend = -1;
    var fader_lut_DB_OFFSET =
    [
          9.5,    0,
          5.0,   40,
          0.0,   86,
         -5.0,  130,
        -10.0,  196,
        -20.0,  248,
        -30.0,  279,
        -40.0,  311,
        -50.0,  336,
        -60.0,  360,
        -90.0,  385,
        -91.0,  400,
    ];
    var fader_update_state = new Array(FADERS_MAP.length);
    var fader_update_busy = 0;

    parent_div.bind('destroyed', function() {
        console.log("f_exit = 1");
        f_exit = 1;
    });

    for(var i = 0; i < FADERS_MAP.length; i++)
        fader_update_state[i] = null;

    function FaderValueUpdate()
    {
        if(fader_update_busy)
            return;

        for(var i = 0; i < FADERS_MAP.length; i++)
            if(fader_update_state[i] != null)
            {
                var idx = i;
                var v = fader_update_state[i];

                fader_update_state[i] = null;
                fader_update_busy = 1;

                $.getJSON
                (
                    'TheCoreElementsMixer.Act.php',
                    {
                        'xmlrpc_port' : params['port'],
                        'target' : 11,
                        'idx' : i,
                        'val' : Math.round(v * 100),
                    }
                )
                .done
                (
                    function(curr)
                    {
                        UpdateTally(curr);

                        if(fader_update_state[i] != null && fader_update_state[i] == v)
                            fader_update_state[i] = null;

                        fader_update_busy = 0;
                        FaderValueUpdate();
                    }
                );

                return;
            };
    };

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsMixer control main"></div>');
    main_div.appendTo(parent_div);

    var tr, table = $('<table width="100%" cellpading="0" cellspacing="0" border="0"></table>');
        table.appendTo(main_div);
    var tbody = $('<tbody></tbody>'); tbody.appendTo(table);
        var tr_h = $('<tr></tr>'); tr_h.appendTo(tbody);
        var tr_1 = $('<tr></tr>'); tr_1.appendTo(tbody);
        var tr_2 = $('<tr></tr>'); tr_2.appendTo(tbody);
        var tr_3 = $('<tr></tr>'); tr_3.appendTo(tbody);
        var tr_4 = $('<tr></tr>'); tr_4.appendTo(tbody);

    for(var i = 0, c = 0; ; c++)
    {

        var th_h = $('<td></td>'); th_h.appendTo(tr_h);

        if(c & 1)
        {
            th_h.attr('rowspan', 5);
            th_h.attr('width', (i == (FADERS_MAP.length - 1)) ? '*' : '5');
            continue;
        };

        var idx = FADERS_MAP[i];

        th_h.attr('width', '100');

        var td_1 = $('<td></td>');
            td_1.appendTo(tr_1);
            td_1.attr('fader-idx', i);
        var name = $('<div class="TheCoreElementsMixer fader_name"></div>');
            name.attr('idx', idx);
            name.appendTo(td_1);
        if(idx == (FADERS_MAP.length - 1))
//            name.text('PRG');
//        else if(idx == (FADERS_MAP.length - 2))
            name.text('MASTER');
        else
            name.addClass('fader_user');

        var td_2 = $('<td></td>');
            td_2.appendTo(tr_2);
            td_2.attr('fader-idx', idx);

        var fader_main = $('<div class="TheCoreElementsMixer fader_main"><div class="TheCoreElementsMixer fader_button"></div></div>');
            fader_main.attr('idx', idx);
            fader_main.appendTo(td_2);
        if(idx < FADERS_USER) fader_main.addClass('fader_user');

        var td_3 = $('<td></td>');
            td_3.appendTo(tr_3);
            td_3.attr('fader-idx', idx);

        var level = $('<div class="TheCoreElementsMixer fader_value"></div>');
            level.attr('idx', idx);
            level.appendTo(td_3);
            level.text('+2.4');
        if(idx < FADERS_USER) level.addClass('fader_user');


        var td_4 = $('<td></td>');
            td_4.appendTo(tr_4);
            td_4.attr('fader-idx', idx);

        var btns = $('<div class="TheCoreElementsMixer fader_btns"></div>');
            btns.attr('idx', idx);
            btns.appendTo(td_4);
        if(idx < FADERS_USER) btns.addClass('fader_user');

        var btn1 = $('<div class="TheCoreElementsMixer fader_btn MUTE">M</div>');
            btn1.attr('idx', idx);
            btn1.appendTo(btns);
            btn1.attr('title', 'MUTE');
        var btn2 = $('<div class="TheCoreElementsMixer fader_btn SOLO">S</div>');
            btn2.attr('idx', idx);
            btn2.appendTo(btns);
            btn2.attr('title', 'SOLO');
        var btn3 = $('<div class="TheCoreElementsMixer fader_btn PFL">P</div>');
            btn3.attr('idx', idx);
            btn3.appendTo(btns);
            btn3.attr('title', 'PFL');
        var btn4 = $('<div class="TheCoreElementsMixer fader_btn RST">R</div>');
            btn4.attr('idx', idx);
            btn4.appendTo(btns);
            btn4.attr('title', 'RESET');
        var btn5 = $('<div class="TheCoreElementsMixer fader_btn FOLLOW">F</div>');
            btn5.attr('idx', idx);
            btn5.appendTo(btns);
            btn5.attr('title', 'FOLLOW VIDEO');

        fader_value_set_position(idx, 0.0);
        fader_value_set_text(idx, 0.0);

        if(i == (FADERS_MAP.length - 1))
            break;
        i++;
    };


    GetTally();

    function UpdateTally(tally)
    {
        console.log("UpdateTally: " + JSON.stringify(tally));

        if(tally != null && (!(typeof tally.amend === 'undefined')))
        {
            var tally_current = parseInt(tally.amend);

            console.log("UpdateTally: tally_amend=" + tally_amend + ", tally_current=" + tally_current);

            if(tally_amend < tally_current || tally_current == -1)
            {
                var idx_dragging_fader = (dragging_fader == null) ? -1 : parseInt(dragging_fader.parent().attr('idx'));
                tally_amend = tally_current;
                console.log("UpdateTally: tally_amend=" + tally_amend);

                table.find('div.TheCoreElementsMixer.fader_main').each(function()
                {
                    var idx = parseInt($(this).attr('idx'));
                    console.log("idx=" + idx + ",f=" + tally.faders[idx]);
                    var v = tally.faders[idx][0];

                    if(idx != idx_dragging_fader)
                    {
                        v = parseInt(v) / 100.0;
                        fader_value_set_position(idx, v);
                        fader_value_set_text(idx, v);
                    };

                    $(this)
                        .find('div.TheCoreElementsMixer.fader_button')
                        .attr('tally', tally.faders[idx][0]);
                });

                table.find('div.TheCoreElementsMixer.fader_btn').each(function()
                {
                    var idx = parseInt($(this).attr('idx'));

                    if($(this).hasClass('MUTE'))
                    {
                        if(parseInt(tally.faders[idx][1]))
                            $(this).addClass('active');
                        else
                            $(this).removeClass('active');
                    };
                    if($(this).hasClass('SOLO'))
                    {
                        if(parseInt(tally.faders[idx][2]))
                            $(this).addClass('active');
                        else
                            $(this).removeClass('active');
                    };
                    if($(this).hasClass('PFL'))
                    {
                        if(parseInt(tally.faders[idx][3]))
                            $(this).addClass('active');
                        else
                            $(this).removeClass('active');
                    };
                    if($(this).hasClass('FOLLOW'))
                    {
                        if(parseInt(tally.faders[idx][4]))
                            $(this).addClass('active');
                        else
                            $(this).removeClass('active');
                    };

                });
            };

            if(tally.titles_amend != titles_amend)
                GetTitles();
        }
        else
        {
            tally_amend = -1;
            UpdateTitles(null);
        };
    };

    function UpdateTitles(titles)
    {
        console.log("UpdateTitltes: " + JSON.stringify(titles));

        if(titles != null && !(typeof titles.amend === 'undefined'))
        {
            titles_amend = parseInt(titles.amend);

            console.log("UpdateTitles: titles_amend=" + titles_amend);

            table.find('div.TheCoreElementsMixer.fader_name').each(function()
            {
                var name = "";
                var idx = parseInt($(this).attr('idx'));

                var inp = parseInt(titles.list[idx].inp);
                if(inp)
                {
                    inp--;
                    var name = titles.list[idx].title;
                    if("" == name)
                        name = titles.vc.inputs[inp].title;
                };

                if($(this).hasClass('fader_user'))
                    $(this).html(name.replace("/", "<br>"));
            });


            table.find('div.TheCoreElementsMixer.fader_user').each(function()
            {
                var idx = parseInt($(this).attr('idx'));
                var inp = parseInt(titles.list[idx].inp);
                $(this).css({'opacity': (inp ? '1.0' : '0.0')});
            });

        }
        else
        {
            titles_amend = -1;
        };
    };

    function GetTally()
    {
        if(f_exit)
            return;

        $.getJSON
        (
            'TheCoreElementsMixer.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            UpdateTally(curr);
            window.setTimeout(function() { GetTally(); }, 1500);
        })
        .fail(function(msg)
        {
            UpdateTally(null);
            window.setTimeout(function() { GetTally(); }, 2500);
        });
    };

    function GetTitles()
    {
        if(-2 == titles_amend)
            return;

        titles_amend = -2;

        $.getJSON
        (
            'TheCoreElementsMixer.GetAudioConnections.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            UpdateTitles(curr);
        })
        .fail(function(msg)
        {
            UpdateTitles(null);
        });
    };

    var dragging_fader = null;

    table.delegate("div.TheCoreElementsMixer.fader_button", "mousedown", function(e)
    {
        dragging_fader = $(this);

        var o = e.pageY - dragging_fader.offset().top;

        console.log("Starting dragging: offset=" + o);
        dragging_fader.attr('dragging-offset', o);
    });

    function fader_value_set_text(idx, val)
    {
        table.find('div.TheCoreElementsMixer.fader_value').each(function(){
            var _idx = $(this).attr('idx');
            if(idx == _idx)
            {
                var v = Math.abs(Math.floor(100 * val));
                var u = Math.floor(v / 100);
                var l = v % 100;
                l = ((l < 10) ? '0' : '') + l;
                if(val == 0.0)
                    val = "0.0";
                else
                    val = ((val < 0) ? "-" : "+") + u + "." + l;

                $(this).text(val);
            };
        });
    }

    function fader_value_set_position(idx, val)
    {
        table.find('div.TheCoreElementsMixer.fader_main').each(function(){
            var _idx = $(this).attr('idx');
            if(idx == _idx)
                $(this).find('div.TheCoreElementsMixer.fader_button').
                    css({'top' : fader_DB_to_OFFSET(val)});
        });
    }

    function fader_drag_align(e)
    {
        var h1 = parseInt(dragging_fader.parent().css('height'));
        var h2 = parseInt(dragging_fader.css('height'));
        var h3 = parseInt(dragging_fader.attr('dragging-offset'));

        var o = e.pageY - dragging_fader.parent().offset().top - h3;

//        console.log("o=" + o + ", h1=" + h1 + ", h2=" + h2 + ", h3=" + h3);

        if(o < 0)
            o = 0;
        else if(o >= (h1 - h2))
            o = h1 - h2;

        dragging_fader.css({'top': o});

        var DB = fader_OFFSET_to_DB(o);
        var O = fader_DB_to_OFFSET(DB);

        fader_value_set_text(dragging_fader.parent().attr('idx'), DB)
        console.log("o=" + o + ", DB=" + DB + ", O=" + O);
        fader_update_state[parseInt(dragging_fader.parent().attr('idx'))] = DB;
        FaderValueUpdate();
    };

//    $(document).delegate("#timeline_area", "mousemove", function(e) {
    $(window).mousemove(function(e){
        if(dragging_fader != null)
        {
//            set_cursor_pos_user(e, 1);
            fader_drag_align(e);
            e.preventDefault();
        };
    });

    $(window).mouseup(function(e){
        if(dragging_fader != null)
        {
//            set_cursor_pos_user(e, 1);
            fader_drag_align(e);
            e.preventDefault();

            var tally_val = dragging_fader.attr('tally');
            var idx = dragging_fader.parent().attr('idx');
            dragging_fader = null;

            if(tally_val != null)
            {
                var tally = parseInt(tally_val);
                fader_value_set_position(idx, tally / 100.0);
                fader_value_set_text(idx, tally / 100.0);
            };

            console.log("drag stopped");
        };
    });

    table.delegate("div.TheCoreElementsMixer.fader_btn", "mousedown", function()
    {
        var val = -1;
        var target = 12;
        var idx = $(this).attr('idx');

        if($(this).hasClass('SOLO')) val = 1;
        else if($(this).hasClass('MUTE')) val = 2;
        else if($(this).hasClass('PFL')) val = 3;
        else if($(this).hasClass('RST')) val = 4;
        else if($(this).hasClass('FOLLOW')) val = 5;

        console.log("fader_btn: idx=[" + idx + "], val=[" + val + "]");

        $.getJSON
        (
            'TheCoreElementsMixer.Act.php',
            {
                'xmlrpc_port' : params['port'],
                'target' : 12,
                'idx' : idx,
                'val' : val,
            }
        )
        .done
        (
            function(curr)
            {
                UpdateTally(curr);
            }
        );
    });

    function fader_DB_to_OFFSET(d)
    {
        for(var i = 0; i < (fader_lut_DB_OFFSET.length / 2); i++)
        {
            if(d > fader_lut_DB_OFFSET[2 * i + 0])
            {
                if(i)
                {
                    var rOFFSET =
                        fader_lut_DB_OFFSET[2 * (i - 0) + 1]-
                        fader_lut_DB_OFFSET[2 * (i - 1) + 1];
                    var rDB =
                        fader_lut_DB_OFFSET[2 * (i - 0) + 0]-
                        fader_lut_DB_OFFSET[2 * (i - 1) + 0];
                    var oDB = d - fader_lut_DB_OFFSET[2 * (i - 1) + 0];
                    var OFFSET = fader_lut_DB_OFFSET[2 * (i - 1) + 1];

                    return OFFSET + rOFFSET * oDB / rDB;
                }
                else
                    return fader_lut_DB_OFFSET[fader_lut_DB_OFFSET.length - 1];
            };
        };

        return fader_lut_DB_OFFSET[1];
    };


    function fader_OFFSET_to_DB(o)
    {
        for(var i = 0; i < (fader_lut_DB_OFFSET.length / 2); i++)
        {
            if(o < fader_lut_DB_OFFSET[2 * i + 1])
            {
                if(i)
                {
                    var rOFFSET =
                        fader_lut_DB_OFFSET[2 * (i - 0) + 1]-
                        fader_lut_DB_OFFSET[2 * (i - 1) + 1];
                    var rDB =
                        fader_lut_DB_OFFSET[2 * (i - 0) + 0]-
                        fader_lut_DB_OFFSET[2 * (i - 1) + 0];
                    var oOFFSET = o - fader_lut_DB_OFFSET[2 * (i - 1) + 1];
                    var DB = fader_lut_DB_OFFSET[2 * (i - 1) + 0];

                    return DB + rDB * oOFFSET / rOFFSET;
                }
                else
                    return fader_lut_DB_OFFSET[0];
            };
        };

        return fader_lut_DB_OFFSET[ fader_lut_DB_OFFSET.length - 2 ];
    };

}
