$.fn.TheCoreElementsIODRMOutput_attach = function(params)
{
    var p;
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsIODRMOutput main"></div>');
        main_div.appendTo(parent_div);

    // -------------------------
    var main_table = $('<table width="100%" border="1" cellpadding="0" cellspacing="0" class="TheCoreElementsIODRMOutput"></table>');
        main_table.appendTo(main_div);

    var thead = $('<thead></thead');
        thead.appendTo(main_table);

    var tbody = $('<tbody></tbody');
        tbody.appendTo(main_table);

    var tr = $('<tr></tr>');
        tr.appendTo(thead);

    $('<th class="CRTC" width="50">CRTC</th>').appendTo(tr);
    $('<th class="STATUS" width="150">STATUS</th>').appendTo(tr);
    $('<th class="PIN">PIN</th>').appendTo(tr);
    $('<th class="CONN">CONNECTOR</th>').appendTo(tr);
    $('<th class="CONTROL" width="*">CONTROL</th>').appendTo(tr);

    for(var i = 0; i < 4; i++)
    {
        var td, td_sel;

        tr = $('<tr class="CRTC"></tr>');
        tr.appendTo(tbody);
        tr.attr('crtc_idx', i);

        td = $('<td class="CRTC"></td>'); td.appendTo(tr);

        td = $('<td class="STATUS"><div class="STATE"></div><div class="ERROR"></div><div class="MSG"></div></td>'); td.appendTo(tr);
        td.attr('crtc_idx', i);

        td = $('<td class="PIN"></td>'); td.appendTo(tr);
        td.attr('crtc_idx', i);
        {
            td_sel = $('<select class="TheCoreElementsIODRMOutput MATRIX_PIN_SELECT"></select>');
            td_sel.prop('disabled', true);
            td_sel.appendTo(td);
            td_sel.addClass('CONN_OUTPUT');
            td_sel.attr('crtc_idx', i);
            td.delegate('select.MATRIX_PIN_SELECT', 'change', function(e)
            {
                console.log('Input changed');
                var sel = $(this);
                var pin = sel.find('option:selected').val();
                var crtc_idx = parseInt(sel.attr('crtc_idx'));

                console.log("crtc_idx=" + crtc_idx + ", pin=" + pin);

                if(pin !== undefined)
                {
                    console.log("pin=" + pin);

                    $.getJSON
                    (
                        'TheCoreElementsIODRMOutput.SetPin.php',
                        {
                            'xmlrpc_port' : params['port'],
                            'crtc_idx' : crtc_idx,
                            'pin' : pin
                        }
                    )
                    .done(function()
                    {
                        GetTally();
                    });
                };
            });
        };

        td = $('<td class="CONN"></td>'); td.appendTo(tr);
        td.attr('crtc_idx', i);
        {
            td_sel = $('<select class="TheCoreElementsIODRMOutput CONNECTOR_SELECT"></select>');
            td_sel.prop('disabled', true);
            td_sel.appendTo(td);
            td_sel.attr('crtc_idx', i);
            td.delegate('select.CONNECTOR_SELECT', 'change', function(e)
            {
                console.log('Connector changed');
                var sel = $(this);
                var connector = sel.find('option:selected').val();
                var crtc_idx = parseInt(sel.attr('crtc_idx'));

                console.log("crtc_idx=" + crtc_idx + ", connector=" + connector);

                if(connector !== undefined)
                {
                    console.log("connector=" + connector);

                    $.getJSON
                    (
                        'TheCoreElementsIODRMOutput.SetConnector.php',
                        {
                            'xmlrpc_port' : params['port'],
                            'crtc_idx' : crtc_idx,
                            'connector' : connector
                        }
                    )
                    .done(function()
                    {
                        GetTally();
                    });
                };
            });
        };

        td = $('<td class="CONTROL"></td>'); td.appendTo(tr);
        td.attr('crtc_idx', i);
        {
            var btn;

            btn = $('<button class="TheCoreElementsIODRMOutput CONTROL START">START</button>');
            btn.appendTo(td);
            btn.attr('crtc_idx', i);
            td.delegate('button.CONTROL.START', 'click', function(e)
            {
                var btn = $(this);
                var crtc_idx = parseInt(btn.attr('crtc_idx'));
                console.log('CONTROL START');
                btn.prop('disabled', true);
                $.getJSON
                (
                    'TheCoreElementsIODRMOutput.Start.php',
                    {
                        'xmlrpc_port' : params['port'],
                        'crtc_idx' : crtc_idx
                    }
                )
                .done(function()
                {
                    GetTally();
                    btn.prop('disabled', false);
                });
            });

            btn = $('<button class="TheCoreElementsIODRMOutput CONTROL STOP">STOP</button>');
            btn.appendTo(td);
            btn.attr('crtc_idx', i);
            td.delegate('button.CONTROL.STOP', 'click', function(e)
            {
                var btn = $(this);
                var crtc_idx = parseInt(btn.attr('crtc_idx'));
                console.log('CONTROL STOP');
                btn.prop('disabled', true);
                $.getJSON
                (
                    'TheCoreElementsIODRMOutput.Stop.php',
                    {
                        'xmlrpc_port' : params['port'],
                        'crtc_idx' : crtc_idx
                    }
                )
                .done(function()
                {
                    GetTally();
                    btn.prop('disabled', false);
                });
            });

        };
    };

    /* get matrix pins */
    $.getJSON
    (
        'TheCoreElementsIODRMOutput.GetLabels.php',
        {
            'xmlrpc_port' : params['port']
        }
    )
    .done(function(labels)
    {
        console.log("GetLabels:" + JSON.stringify(labels));
        tbody.find('select.MATRIX_PIN_SELECT').each(function()
        {
            matrix_pins_selector_list_setup($(this), labels)
            $(this).prop('disabled', false);
        });

        /* get matrix pins */
        $.getJSON
        (
            'TheCoreElementsIODRMOutput.GetConnectors.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(resp)
        {
            console.log("GetConnectors:" + JSON.stringify(labels));
            tbody.find('select.CONNECTOR_SELECT').each(function()
            {
                matrix_connectors_selector_list_setup($(this), resp.connectors);
                $(this).prop('disabled', false);
            });

            GetTally();
        });
    });

    var GetTallyTimeout = setTimeout(function(){ GetTelly(); }, 30000);

    function GetTally()
    {
        $.getJSON
        (
            'TheCoreElementsIODRMOutput.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(resp)
        {
            var amend_resp = parseInt(resp.amend);
            if(amend < amend_resp)
            {
                amend = amend_resp;
                UpdateUI(resp);
            };
            clearTimeout(GetTallyTimeout);
            GetTallyTimeout = setTimeout(function(){ GetTally(); }, 800);
        });
    };

    function UpdateUI(resp)
    {
        console.log("Update UI");

        /* update text of connectors and it selection */
        tbody.find('select.CONNECTOR_SELECT').each(function(index)
        {
            var sel = $(this);
            var crtc_idx = parseInt(sel.attr('crtc_idx'));

            sel.find('option').each(function(index)
            {
                var o = $(this);
                var v = parseInt(o.val());
                if(v)
                    o.text('[#' + v + '] ' + resp.connectors[v - 1].name + ' [' + resp.connectors[v - 1].conn_str + ']');
                o.attr('selected', resp.crts[crtc_idx].connector == v ? 'selected' : null);
            });
        });

        /* update pins selection */
        tbody.find('select.MATRIX_PIN_SELECT').each(function(index)
        {
            var sel = $(this);
            var crtc_idx = parseInt(sel.attr('crtc_idx'));

            sel.find('option').each(function(index)
            {
                var o = $(this);
                var v = parseInt(o.val());
                o.attr('selected', resp.crts[crtc_idx].pin == v ? 'selected' : null);
            });
        });

        /* setup primary status */
        tbody.find('tr.CRTC').each(function(index)
        {
            var tr = $(this);
            var crtc_idx = parseInt(tr.attr('crtc_idx'));

            if(!resp.crts[crtc_idx].crtc_id)
                tr.hide();
            else
            {
                tr.find('td.CRTC').text(resp.crts[crtc_idx].crtc_id);

                var states = ['IDLE', 'STARTING', 'RUNNING', 'STOP', 'STOPPING'];
                tr.find('td.STATUS div.STATE').text(states[resp.crts[crtc_idx].state]);

                tr.find('td.STATUS div.ERROR').text(resp.crts[crtc_idx].error);
                if(resp.crts[crtc_idx].error == "")
                    tr.find('td.STATUS div.ERROR').hide();
                else
                    tr.find('td.STATUS div.ERROR').show();

                tr.find('td.STATUS div.MSG').text((resp.crts[crtc_idx].state != 2) ? '' :
                    (resp.crts[crtc_idx].hdisplay + 'x' +
                    resp.crts[crtc_idx].vdisplay + '@' +
                    resp.crts[crtc_idx].vrefresh));

                if(resp.crts[crtc_idx].state == 0)
                    tr.find('td.CONTROL button.CONTROL.START').show();
                else
                    tr.find('td.CONTROL button.CONTROL.START').hide();

                if(resp.crts[crtc_idx].state == 2)
                {
                    tr.find('td.CONTROL button.CONTROL.STOP').show();
                    tr.find('td.STATUS div.MSG').show();
                }
                else
                {
                    tr.find('td.CONTROL button.CONTROL.STOP').hide();
                    tr.find('td.STATUS div.MSG').hide();
                }
            };
        });

    };

    function matrix_connectors_selector_list_setup(td_sel, list)
    {
        var opt, i, d;

        /* disable */
        d = td_sel.prop('disabled');

        for(i = 0; i < list.length; i++)
        {
            var o = $('<option></option>');
            o.appendTo(td_sel);
            o.val(i + 1);
            o.text('? ' + list[i].name + ' [' + list[i].conn_str + ']');
        };

        var o = $('<option ></option>');
            o.val(0);
            o.appendTo(td_sel);
            o.attr("selected","selected");

        /* enable */
        td_sel.prop('disabled', d);
    };

    function matrix_pins_selector_list_setup(td_sel, labels)
    {
        var opt, i, d;

        /* disable */
        d = td_sel.prop('disabled');


        /* clear options */
        td_sel.find('option').each(function(index) { $(this).remove(); });
        td_sel.find('optgroup').each(function(index) { $(this).remove(); });

        opt = $('<optgroup label="Outputs"></optgroup>');
        opt.appendTo(td_sel);

        for(i = 1; i < labels.outputs.length; i++)
        {
            if("" == labels.outputs[i])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(i);
            o.text(i + ' - ' + labels.outputs[i]);
        };

        opt = $('<optgroup label="Inputs"></optgroup>');
        opt.appendTo(td_sel);

        for(i = 1; i < labels.inputs.length; i++)
        {
            if("" == labels.inputs[i])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(-i);
            o.text(i + ' - ' + labels.inputs[i]);
        };

        var o = $('<option ></option>');
            o.val(0);
            o.appendTo(td_sel);
            o.attr("selected","selected");

        /* enable */
        td_sel.prop('disabled', d);
    };

}
