$.fn.TheCoreElementsABMix_attach = function(params)
{
    var amend = -1;
    var i, obj, row_div;
    var parent_div = this;

    if(params['DSK_CNT'] === undefined)
        params['DSK_CNT'] = 16;

    var f_exit = 0;

    parent_div.bind('destroyed', function() {
        console.log("f_exit = 1");
        f_exit = 1;
    });

    var main_div = $('<div class="TheCoreElementsABMix main"></div>');
    main_div.appendTo(parent_div);

    for(i = 0; i < params['DSK_CNT']; i++)
    {
        row_div = $('<div class="TheCoreElementsABMix row"></div>');
        row_div.appendTo(main_div);

        obj = $('<div class="TheCoreElementsABMix dsk_title"></div>');
        obj.text("DSK-" + i);
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk ctl OP_CUT active">CUT</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk ctl OP_FADE active">FADE</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix space64"> </div>');
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk ctl OP_CUT_UP">CUT<br>UP</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk ctl OP_CUT_DOWN">CUT<br>DOWN</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk ctl OP_FADE_UP">FADE<br>UP</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk ctl OP_FADE_DOWN">FADE<br>DOWN</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk param"><input class="TheCoreElementsABMix MIX_DUR" size="3" value="100"></div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk ctl OP_AUDIO_CTL">AUDIO<br><span class="STATE"></span></div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix dsk ctl OP_PRV">PRV</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);
    };


    {
        row_div = $('<div class="TheCoreElementsABMix row"><hr></div>');
        row_div.appendTo(main_div);

        row_div = $('<div class="TheCoreElementsABMix row"></div>');
        row_div.appendTo(main_div);

        obj = $('<div class="TheCoreElementsABMix dsk_title">A/B MIX</div>');
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_CUT_AB">CUT</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_FADE_AB">FADE</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix space64"> </div>');
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_CUT_A">CUT<br>to A</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_CUT_B">CUT<br>to B</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_FADE_A">FADE<br>to A</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_FADE_B">FADE<br>to B</div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix param"><input class="TheCoreElementsABMix MIX_DUR" size="3" value="100"></div>');
        obj.attr('arg-idx', i);
        obj.appendTo(row_div);
    };

    {
        row_div = $('<div class="TheCoreElementsABMix row"><hr></div>');
        row_div.appendTo(main_div);

        row_div = $('<div class="TheCoreElementsABMix row"></div>');
        row_div.appendTo(main_div);

        obj = $('<div class="TheCoreElementsABMix dsk_title">A SRC</div>');
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_SEL_MIX_INP">0</div>');
        obj.attr('mixer-input', 0);
        obj.attr('video-source', 0);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_SEL_MIX_INP">1</div>');
        obj.attr('mixer-input', 0);
        obj.attr('video-source', 1);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_SEL_MIX_INP">2</div>');
        obj.attr('mixer-input', 0);
        obj.attr('video-source', 2);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_SEL_MIX_INP">3</div>');
        obj.attr('mixer-input', 0);
        obj.attr('video-source', 3);
        obj.appendTo(row_div);

        row_div = $('<div class="TheCoreElementsABMix row"></div>');
        row_div.appendTo(main_div);

        obj = $('<div class="TheCoreElementsABMix dsk_title">B SRC</div>');
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_SEL_MIX_INP">0</div>');
        obj.attr('mixer-input', 1);
        obj.attr('video-source', 0);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_SEL_MIX_INP">1</div>');
        obj.attr('mixer-input', 1);
        obj.attr('video-source', 1);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_SEL_MIX_INP">2</div>');
        obj.attr('mixer-input', 1);
        obj.attr('video-source', 2);
        obj.appendTo(row_div);

        obj = $('<div class="TheCoreElementsABMix mix ctl OP_SEL_MIX_INP">3</div>');
        obj.attr('mixer-input', 1);
        obj.attr('video-source', 3);
        obj.appendTo(row_div);
    };

    function do_simple_json(method, args)
    {
        args['xmlrpc_port'] = params['port'];

        console.log("do_simple_json(" + method + ")" + JSON.stringify(args));

        $.getJSON
        (
            'TheCoreElementsABMix.' + method + '.php',
            args
        )
        .done(function(curr)
        {
            console.log("DONE:" + JSON.stringify(curr));
        })
        .fail(function(msg)
        {
            console.log("FAILED:" + JSON.stringify(msg));
        });
    };

    function get_mix_dur(idx)
    {
        var val = 0;

        if(idx < 0)
        {
            main_div.find('div.TheCoreElementsABMix.mix.param').find('input').each(function(index)
            {
                val = $(this).val();
                return false;
            });
        }
        else
        {
            main_div.find('div.TheCoreElementsABMix.dsk.param').each(function(index)
            {
                if(idx == parseInt($(this).attr('arg-idx')))
                {
                    val = $(this).find('input').val();
                    return false;
                };
            });
        };

        return val;
    };

    main_div.delegate("div.TheCoreElementsABMix.ctl", "click", function()
    {
        var idx = $(this).attr('arg-idx');

        if($(this).hasClass('OP_CUT'))
            do_simple_json('CutKeyer', { 'layer': idx, 'direction' : 2});
        else if($(this).hasClass('OP_FADE'))
            do_simple_json('FadeKeyer', { 'layer': idx, 'direction' : 2, 'duration' : get_mix_dur(idx)});
        else if($(this).hasClass('OP_CUT_UP'))
            do_simple_json('CutKeyer', { 'layer': idx, 'direction' : 1});
        else if($(this).hasClass('OP_CUT_DOWN'))
            do_simple_json('CutKeyer', { 'layer': idx, 'direction' : 0});
        else if($(this).hasClass('OP_FADE_UP'))
            do_simple_json('FadeKeyer', { 'layer': idx, 'direction' : 1, 'duration' : get_mix_dur(idx)});
        else if($(this).hasClass('OP_FADE_DOWN'))
            do_simple_json('FadeKeyer', { 'layer': idx, 'direction' : 0, 'duration' : get_mix_dur(idx)});
        else if($(this).hasClass('OP_CUT_AB'))
            do_simple_json('CutAB', { });
        else if($(this).hasClass('OP_FADE_AB'))
            do_simple_json('FadeAB', { 'duration' : get_mix_dur(-1)});
        else if($(this).hasClass('OP_CUT_A'))
            do_simple_json('CutA', { });
        else if($(this).hasClass('OP_FADE_A'))
            do_simple_json('FadeA', { 'duration' : get_mix_dur(-1)});
        else if($(this).hasClass('OP_CUT_B'))
            do_simple_json('CutB', { });
        else if($(this).hasClass('OP_FADE_B'))
            do_simple_json('FadeB', { 'duration' : get_mix_dur(-1)});
        else if($(this).hasClass('OP_AUDIO_CTL'))
            do_audio_ctl(idx, $(this));
        else if($(this).hasClass('OP_PRV'))
            do_simple_json('PrvKeyer', { 'layer': idx, 'prv' : -1});
        else if($(this).hasClass('OP_SEL_MIX_INP'))
            do_simple_json('SelMixInp', { 'input' : $(this).attr('mixer-input'), 'source' : $(this).attr('video-source')});
        else
            console.log("NOT HANDLED");
    });

    function do_audio_ctl(idx, obj)
    {
        var v = obj.attr('audio_ctl');
        var r = prompt("Audio control: specify level (0.0) or empty to mute", v);
        if(r != null)
            do_simple_json('AudioCtl', { 'layer': idx, 'value' : r});
    };

    function EnableUI(f)
    {
        console.log("EnableUI(" + f + ")");

        if(f)
            main_div.prop("disabled", false);
        else
            main_div.prop("disabled", true);
    };

    function GetStat(retry_delay)
    {
        if(f_exit)
            return;

        $.getJSON
        (
            'TheCoreElementsABMix.GetStat.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetStat:" + JSON.stringify(curr));

            if(!(typeof curr.amend === 'undefined'))
            {
                console.log("amend=" + amend + ", curr.amend=" + curr.amend);
                if(amend < 0)
                {
                    EnableUI(1);
                };
                if(amend < curr.amend)
                {
                    console.log("will apply changes");
                    amend = curr.amend;

                    main_div.find('div.TheCoreElementsABMix.dsk.ctl.OP_AUDIO_CTL').each(function(index)
                    {
                        var arg_idx = parseInt($(this).attr('arg-idx'));
                        var audio_ctl = curr.audio_ctls[arg_idx];

                        $(this).attr('audio_ctl', audio_ctl);

                        if(audio_ctl == "")
                        {
                            $(this).find('span.STATE').text('MUTED');
                            $(this).removeClass('active');
                        }
                        else
                        {
                            $(this).find('span.STATE').text(audio_ctl + ' dB');
                            $(this).addClass('active');
                        };
                    });

                    main_div.find('div.TheCoreElementsABMix.dsk.param').each(function(index)
                    {
                        var arg_idx = parseInt($(this).attr('arg-idx'));
                        var alpha_dur = curr.alpha_durs[arg_idx];

                        $(this).find('input.MIX_DUR').val(alpha_dur);
                    });
                    main_div.find('div.TheCoreElementsABMix.mix.param').each(function(index)
                    {
                        $(this).find('input.MIX_DUR').val(curr.alpha_dur);
                    });

                    main_div.find('div.TheCoreElementsABMix.OP_CUT').each(function(index)
                    {
                        var arg_idx = parseInt($(this).attr('arg-idx'));
                        var alpha_cnt = curr.alpha_cnts[arg_idx];
                        var alpha_dur = curr.alpha_durs[arg_idx];

                        if(alpha_cnt == 0 && $(this).hasClass('active'))
                            $(this).removeClass('active');
                        else if(alpha_cnt != 0 && (!($(this).hasClass('active'))))
                            $(this).addClass('active');
                    });

                    main_div.find('div.TheCoreElementsABMix.OP_PRV').each(function(index)
                    {
                        var arg_idx = parseInt($(this).attr('arg-idx'));
                        var prv = curr.alpha_prvs[arg_idx];

                        if(prv == 0 && $(this).hasClass('active'))
                            $(this).removeClass('active');
                        else if(prv != 0 && (!($(this).hasClass('active'))))
                            $(this).addClass('active');
                    });

                    main_div.find('div.TheCoreElementsABMix.OP_FADE').each(function(index)
                    {
                        var arg_idx = parseInt($(this).attr('arg-idx'));
                        var alpha_dir = curr.alpha_dirs[arg_idx];

                        if(alpha_dir == 0 && $(this).hasClass('active'))
                            $(this).removeClass('active');
                        else if(alpha_dir != 0 && (!($(this).hasClass('active'))))
                            $(this).addClass('active');
                    });

                    var alpha_cnt = parseInt(curr.alpha_cnt);
                    if(alpha_cnt == 0)
                    {
                        main_div.find('div.TheCoreElementsABMix.OP_CUT_AB').addClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_CUT_A').removeClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_CUT_B').addClass('active');
                    }
                    else
                    {
                        main_div.find('div.TheCoreElementsABMix.OP_CUT_AB').removeClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_CUT_A').addClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_CUT_B').removeClass('active');
                    }

                    var alpha_dir = parseInt(curr.alpha_dir);
                    if(alpha_dir < 0)
                    {
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_AB').addClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_A').removeClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_B').addClass('active');
                    }
                    else if(alpha_dir > 0)
                    {
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_AB').addClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_A').addClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_B').removeClass('active');
                    }
                    else
                    {
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_AB').removeClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_A').removeClass('active');
                        main_div.find('div.TheCoreElementsABMix.OP_FADE_B').removeClass('active');
                    };

                    main_div.find('div.TheCoreElementsABMix.OP_SEL_MIX_INP').each(function(index)
                    {
                        var input = $(this).attr('mixer-input');
                        var source = $(this).attr('video-source');
                        var inp = (input === '0') ? curr.inp_a : curr.inp_b;

                        $(this).removeClass('active');
                        if(inp == source)
                            $(this).addClass('active');
                    });
                };
            }
            else
            {
                amend = -1;
                EnableUI(0);
            };

            if(retry_delay > 0)
                window.setTimeout(function() { GetStat(retry_delay); }, retry_delay);
        })
        .fail(function(msg)
        {
            amend = -1;
            EnableUI(0);
            if(retry_delay > 0)
                window.setTimeout(function() { GetStat(retry_delay); }, 4 * retry_delay);
        });
    };

    EnableUI(0);
    GetStat(1000);
}
