$.fn.TheCoreElementsSubsBurn_attach = function(params)
{
    var p;
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsSubsBurn main"></div>');
    main_div.appendTo(parent_div);

    // -------------------------

    $('<div class="TheCoreElementsSubsBurn row"><h1>Connection</h1></div>').appendTo(main_div);

    function append_row(title, type, conn_output)
    {
        var row = $('<div class="TheCoreElementsSubsBurn row"></div>');
        row.appendTo(main_div);

        var t = $('<span class="title"></span>');
        t.appendTo(row);
        t.text(title);

        var td_sel = $('<select class="CONN"></select>');
        td_sel.prop('disabled', true);
        td_sel.appendTo(row);
        td_sel.addClass(type);
        if(conn_output)
            td_sel.addClass('CONN_OUTPUT');

        row.delegate('select.CONN', 'change', function(e)
        {
            console.log('Input changed');
            main_div.find('button.SAVE_CONN').prop('disabled', false);
        });
    };

    append_row('Input:', 'INP', 0);
    append_row('Output:', 'OUT', 1);

    $('<div class="TheCoreElementsSubsBurn row"><button class="SAVE_CONN"> SAVE </button></div>').appendTo(main_div);

    main_div.delegate('button.SAVE_CONN', "click", function()
    {
        var conn =
        {
            "inp": 0,
            "out": 0,
        };

        main_div.find('select.CONN').each(function(index)
        {
            var c = parseInt($(this).val());
            if($(this).hasClass('INP')) conn['inp'] = c;
            else if($(this).hasClass('OUT')) conn['out'] = c;
            else if($(this).hasClass('AUX')) conn['aux'] = c;
        });

        console.log("saving connections...conn=" + JSON.stringify(conn));

        var r =
        {
            'xmlrpc_port'       : params['port'],
            'conn'              : conn,
        };

        $.post
        (
            'TheCoreElementsSubsBurn.SetConnections.php', r
        )
        .done
        (
            function(curr)
            {
                GetStat();
            }
        );
    });

    // -------------------------

    $('<div class="TheCoreElementsSubsBurn row"><h1>Functions</h1></div>').appendTo(main_div);

    $('<div class="TheCoreElementsSubsBurn row"><span class="title">Vanc data dump:</span><input type="checkbox" class="row VANC_DATA_ENABLE FLAG_SWITCH" switch-call="TheCoreElementsSubsBurn.SetDumpEnable.php"></div>').appendTo(main_div);
    $('<div class="TheCoreElementsSubsBurn row"><span class="title">OP-47 burn:</span><input type="checkbox" class="row OP47_ENABLE FLAG_SWITCH" switch-call="TheCoreElementsSubsBurn.SetOP47Enable.php"></div>').appendTo(main_div);
    $('<div class="TheCoreElementsSubsBurn row"><span class="title">CEA-708 burn:</span><input type="checkbox" class="row CEA708_ENABLE FLAG_SWITCH" switch-call="TheCoreElementsSubsBurn.SetCEA708Enable.php"></div>').appendTo(main_div);


    main_div.delegate('input[type="checkbox"].row.FLAG_SWITCH', "click", function()
    {
        var state = $(this).is(':checked');
        var call = $(this).attr('switch-call');

        $(this).prop('disabled', true);

        console.log('check box changed, val=' + state);

        $.post(call, { 'xmlrpc_port' : params['port'], 'switch' : (state ? 1 : 0) } ).done
        (
            function(curr)
            {
                GetStat();
            }
        );
    });

    // -------------------------

    parent_div.delegate("input[type='text'].row_pos", "keypress", function(e)
    {
        var txt = String.fromCharCode(e.which);
        if(!txt.match(/[0-9.,]/))
        {
            return false;
        }
    });

    parent_div.delegate("input[type='text'].row_neg", "keypress", function(e)
    {
        var txt = String.fromCharCode(e.which);
        if(!txt.match(/[0-9.,]/))
        {
            if(txt != '-')
                return false;
        }
    });

    function GetStat()
    {
        $.getJSON
        (
            'TheCoreElementsSubsBurn.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetStat:" + JSON.stringify(curr));
            update_ui(curr);
        })
        .fail(function(msg)
        {
        });
    };

    GetStat();


    function update_ui_labels(curr, labels, type, matrix_output)
    {
        var opt;
        var sel_idx;
        var td_sel = main_div.find('select.CONN.' + type);

        /* disable */
        td_sel.prop('disabled', true);

        /* clear options */
        td_sel.find('option').each(function(index) { $(this).remove(); });
        td_sel.find('optgroup').each(function(index) { $(this).remove(); });

        opt = $('<optgroup label="Outputs"></optgroup>');
        opt.appendTo(td_sel);

        if(!td_sel.hasClass('CONN_OUTPUT'))
        for(sel_idx = 1; sel_idx < labels.outputs.length; sel_idx++)
        {
            if("" == labels.outputs[sel_idx])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(sel_idx);
            o.text(sel_idx + ' - ' + labels.outputs[sel_idx]);
            if(sel_idx == matrix_output)
                o.attr("selected","selected");
        };

        opt = $('<optgroup label="Inputs"></optgroup>');
        opt.appendTo(td_sel);

        for(sel_idx = 1; sel_idx < labels.inputs.length; sel_idx++)
        {
            if("" == labels.inputs[sel_idx])
                continue;

            var o = $('<option></option>');
            o.appendTo(opt);
            o.val(-sel_idx);
            o.text(sel_idx + ' - ' + labels.inputs[sel_idx]);
            if(-sel_idx == matrix_output)
                o.attr("selected","selected");
        };

        /* enable */
        td_sel.prop('disabled', false);
    };

    function update_ui(curr)
    {
        /* update connections labels */
        $.getJSON
        (
            'TheCoreElementsSubsBurn.GetLabels.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(labels)
        {
            console.log("GetLabels:" + JSON.stringify(labels));

            update_ui_labels(curr, labels, 'INP', curr.inp);
            update_ui_labels(curr, labels, 'OUT', curr.out);

            main_div.find('button.SAVE_CONN').prop('disabled', true);
        })
        .fail(function(msg)
        {
        });

        parent_div.find('input[type="checkbox"].row.FLAG_SWITCH').each(function()
        {
            var v =
                $(this).hasClass('VANC_DATA_ENABLE') ? curr['dump'] :
                $(this).hasClass('OP47_ENABLE') ? curr['op47'] :
                $(this).hasClass('CEA708_ENABLE') ? curr['cea708'] :
                '';

            $(this).prop('checked', parseInt(v) == 1);
            $(this).prop('disabled', false);
        });
    };
}
