var Oxtel =
{
    _hex_str: '0123456789ABCDEF',
    _hex_STR: '0123456789ABCDEF',
    _hex: function(v, l)
    {
        var r = "";

        if(v !== undefined && v !== "")
            v = parseInt(v);

        for(i = 0; i < l; i++)
        {
            var d = v % 16;

            v >>= 4;

            d = (d < 10) ? ('' + d)
                : (d == 10) ? 'A'
                : (d == 11) ? 'B'
                : (d == 12) ? 'C'
                : (d == 13) ? 'D'
                : (d == 14) ? 'E'
                : (d == 15) ? 'F' : '?';

            r = d + r;
        };

        return r;

    },
    _is_hex: function(v)
    {
        if(v.length != 1) return false;
        return this._hex_str.indexOf(v) < 0 ? (this._hex_STR.indexOf(v) < 0 ? false : true ) : true;
    },
    _hex_val: function(v)
    {
        if(v.length != 1) return false;
        var r = this._hex_str.indexOf(v);
        if(r < 0)
            r = this._hex_STR.indexOf(v);
        return r;
    },
    CutA: function () { return 'U0'; },
    CutB: function () { return 'U1'; },
    CutAB: function () { return 'U4'; },
    FadeA: function (mix_dur) { return 'U2' + Oxtel._hex(mix_dur, 3); },
    FadeB: function (mix_dur) { return 'U3' + Oxtel._hex(mix_dur, 3); },
    FadeAB: function (mix_dur) { return 'U5' + Oxtel._hex(mix_dur, 3); },
    CutKeyer: function (layer_index, dir) { return '3' + Oxtel._hex(layer_index, 1) + ' ' + dir; },
    FadeKeyer: function (layer_index, dir, mix_dur) { return '1' + Oxtel._hex(layer_index, 1) + ' ' + dir + ((mix_dur !== undefined && mix_dur !== '') ? Oxtel._hex(mix_dur, 3) : '') },
    EnquireVideoTallies: function () { return 'Y6'; },
    EnableVideoTallies: function (f) { return 'Y6' + ((f != 0) ? '1' : '0'); },
    QueryFirstFile: function (f) { return 'R4' + ((f != undefined) ? f : '$VIDEO'); },
    QuerySubsequentFile: function (f) { return 'R5' + ((f != undefined) ? f : '$VIDEO'); },
    EnquireFileInfo: function (f) { return 'R3' + f; },
    parse_tally: function (msg, cb)
    {
        var
            L = msg.length,
            C0 = msg.substr(0, 1),
            C1 = msg.substr(1, 1),
            C2 = msg.substr(2, 1),
            C3 = msg.substr(3, 1);

        if(L > 3 && C0 == 'R' && C1 == '4' && (C2 == '1' || C2 == '0'))
        {
            var end = (C2 == '1') ? 1 : 0;
            var file = msg.substr(3);
            var func = 'QueryFirstFile';

            if(undefined !== cb[func] && typeof cb[func] === "function")
                cb[func](end, this._unescape(file));
        }
        else
        if(L > 3 && C0 == 'R' && C1 == '5' && (C2 == '1' || C2 == '0'))
        {
            var end = (C2 == '1') ? 1 : 0;
            var file = msg.substr(3);
            var func = 'QuerySubsequentFile';

            if(undefined !== cb[func] && typeof cb[func] === "function")
                cb[func](end, this._unescape(file));
        }
        else
        if(L > 3 && C0 == 'R' && C1 == '0' && Oxtel._is_hex(C2))
        {
            var layer = this._hex_val(C2);
            var file = msg.substr(3);
            var func = 'EnquireLoadImage';

            if(undefined !== cb[func] && typeof cb[func] === "function")
                cb[func](layer, this._unescape(file));
        }
        else
        if(L > 3 && C0 == 'Y' && C1 == '9' && Oxtel._is_hex(C2))
        {
            var layer = this._hex_val(C2);
            var file = msg.substr(3);
            var func = 'ImageLoadTally';

            if(undefined !== cb[func] && typeof cb[func] === "function")
                cb[func](layer, this._unescape(file));
        }
        else
        if(L >= 3 && C0 == 'm' && C1 == '6' && Oxtel._is_hex(C2))
        {
            var layer = this._hex_val(C2);
            var files = msg.substr(3);
            var func = 'EnquireLayerDatasourceList';
            var that = this;
            if(undefined !== cb[func] && typeof cb[func] === "function")
                cb[func](layer, files.split("|").map(function(x) { return that._unescape(x);}));
        }
        else
        if(L == 4 && C0 == '3' && Oxtel._is_hex(C1) && C2 == ' ' && (C3 == '0' || C3 == '1' || C3 == '2'))
        {
            var layer = this._hex_val(C1);
            var dir = C3.charCodeAt(0) - 0x30;
            var func = 'KeyerPositionTally';
            var that = this;
            if(undefined !== cb[func] && typeof cb[func] === "function")
                cb[func](layer, dir);
        }
        else
        if(L == 4 && C0 == 'U' && C1 == 'E' && Oxtel._is_hex(C2) && Oxtel._is_hex(C3))
        {
            var mixer_input = this._hex_val(C2);
            var video_source = this._hex_val(C3);
            var func = 'EnquireMixerInput';
            var that = this;
            if(undefined !== cb[func] && typeof cb[func] === "function")
                cb[func](mixer_input, video_source);
        }
        ;
    },
    _escape: function(str) { return str.replace(/[\\]/g, "\\5C").replace(/[|]/g, "\\7C").replace(/[:]/g, "\\3A").replace(/[;]/g, "\\3B"); },
    _unescape: function(str) { return str.replace(/\\5C/g, "\\").replace(/\\7C/g, "|").replace(/\\3A/g, ":").replace(/\\3B/g,";"); },
    EraseStore: function(layer_index) { return 'A' + this._hex(layer_index, 1); },
    EnquireLoadImage: function(layer_index) { return 'R0' + this._hex(layer_index, 1); },
    LoadImage: function(layer_index, file) { return 'R0' + this._hex(layer_index, 1) + this._escape(file); },
    StartAnimation: function(layer_index) { return 'S0' + this._hex(layer_index, 1); },
    StopAnimation: function(layer_index, flag) { return 'S1' + this._hex(layer_index, 1) + this._hex(flag, 1); },
    RestartAnimation: function(layer_index) { return 'S4' + this._hex(layer_index, 1); },
    RenderBox: function(layer_index, box_no) { return 'Z3' + this._hex(layer_index, 1) + this._hex(box_no, 2); },
    UpdateTextField: function(layer_index, box_no, flag_render, flag_append, text)
        { return 'Z0' + this._hex(layer_index, 1) + this._hex(box_no, 2) + this._hex( ((flag_render == 0) ? 0 : 1) + ((flag_append == 0) ? 0 : 2), 1) + this._escape(text); },
    EnquireLayerDatasourceList: function(layer_index) { return 'm6' + this._hex(layer_index, 1); },
    SetLayerDatasourceValue: function(flag_first_packet, flag_last_packet, layer_index, field_name, value)
        { return 'm2' +  this._hex( ((flag_first_packet == 0) ? 0 : 1) + ((flag_last_packet == 0) ? 0 : 2), 2) + this._hex(layer_index, 1) +
            this._escape(field_name) + '|' + this._escape(value); },
    SelectAnimationFrame: function(layer_index, frame) { return 'S2' + this._hex(layer_index, 1) + this._hex(frame, 4); },
    SelectMixerInput: function(mixer_input, video_source) { return 'UE' + this._hex(mixer_input, 1) + this._hex(video_source, 1); },
    EnquireMixerInput: function(mixer_input) { return 'UE' + this._hex(mixer_input, 1); },
};

$.fn.TheCoreElementsOxtelProxy_attach = function(params)
{
    var b, e;
    var parent_div = this;
    var ws_main, ws_logger;
    var files_list_progress;

    e = $('<table width="100%" border="0" cellpadding="20" cellspacing="0"><tr valign="top"><td width="50%" class="col0"></td><td width="50%" class="col1"></td></tr></table>');
    e.appendTo(parent_div);

    var col0 = e.find('.col0');
    var col1 = e.find('.col1');

    e = $('<h1 class="TheCoreElementsOxtelProxy head">Test command</h1>');
    e.appendTo(col0);

    var cmd_text = $('<input type="text" size="80" class="TheCoreElementsOxtelProxy cmd_text">');
    cmd_text.appendTo(col0);

    var cmd_button = $('<button class="TheCoreElementsOxtelProxy cmd_button">SEND</button>');
    cmd_button.appendTo(col0);

    e = $('<h1 class="TheCoreElementsOxtelProxy">Log</h1>');
    e.appendTo(col0);

    var cmd_log = $('<div class="TheCoreElementsOxtelProxy cmd_log"></div>');
    cmd_log.appendTo(col0);

    function disable_input(val)
    {
        cmd_text.prop('disabled', val);
        cmd_button.prop('disabled', val);
    };

    function disable_log(val)
    {
        cmd_log.empty();

        if(val)
            cmd_log.text('Connecting...');

        cmd_text.prop('disabled', val);
    };

    disable_input(true);
    disable_log(true);

    function cmd_send()
    {
        var v = cmd_text.val();

        if(ws_main !== undefined)
            ws_main.send(v);
    };

    parent_div.delegate("button.TheCoreElementsOxtelProxy.cmd_button", "click", function()
    {
        cmd_send();
    });

    parent_div.delegate("input.TheCoreElementsOxtelProxy.cmd_text", "keydown", function(e)
    {
        var code = (e.keyCode ? e.keyCode : e.which);

        /* enter */
        if(13 == code)
        {
            e.preventDefault();
            e.stopPropagation();
            cmd_send();
            return false;
        }
    });

    // if user is running mozilla then use it's built-in WebSocket
    window.WebSocket = window.WebSocket || window.MozWebSocket;

    // if browser doesn't support WebSocket, just show
    // some notification and exit
    if (!window.WebSocket)
    {
        console.log("Websockets not supported");
        cmd_log.text("WebSockets not supported");
        return;
    };

    // open connection
    var host = window.location.hostname;

    function ws_logger_connect()
    {
        ws_logger = new WebSocket('ws://' + host + ':' + params['port'], 'logger');
        ws_logger.onclose = function ()
        {
            console.log("Logger Closed to " + host);
            disable_log(true);
            setTimeout(function() {  ws_logger_connect(); }, 1000);
        };
        ws_logger.onopen = function ()
        {
            console.log("Logger Opened to " + host);
            disable_log(false);
        };
        ws_logger.onerror = function()
        {
            ws_logger.close();
        };
        ws_logger.onmessage = function(message)
        {
            var msg = message.data;
            var item = $('<pre class="TheCoreElementsOxtelProxy cmd_log_item"></pre>');
            item.text(msg);
            cmd_log.prepend(item);
        };
    };

    function files_list_update()
    {
        var i;

        console.log("Finished reading filelist, length=" + files_list_progress.length);

        var files_list = parent_div.find('select.files_list');
        var files_list_reload = parent_div.find('button.files_list_reload');

        files_list_progress.sort();

        // append values
        for(i = 0; i < files_list_progress.length; i++)
        {
            files_list.append
            (
                $("<option/>",
                {
                    value: files_list_progress[i],
                    text: files_list_progress[i]
                })
            );
        };

        /* enable */
        files_list.prop('disabled', false);
        files_list_reload.prop('disabled', false);

        /* reset list */
        files_list_progress = undefined;
    };

    function ws_main_connect()
    {
        ws_main = new WebSocket('ws://' + host + ':' + params['port']);
        ws_main.onclose = function ()
        {
            console.log("Main Closed to " + host);
            disable_input(true);
            setTimeout(function() {  ws_main_connect(); }, 1000);
        };
        ws_main.onopen = function ()
        {
            console.log("Main Opened to " + host);
            disable_input(false);
        };
        ws_main.onerror = function()
        {
            ws_main.close();
        };
        ws_main.onmessage = function(message)
        {
            var msg = message.data;
            var flr_dis = parent_div.find('button.files_list_reload').prop('disabled');
            console.log("ws_main: msg=[" + msg + "]");

            Oxtel.parse_tally(msg,
            {
                'QueryFirstFile': function(end, filename)
                {
                    console.log("QueryFirstFile: end=" + end + ", filename=" + filename);

                    if(files_list_progress === undefined && flr_dis)
                    {
                        /* init temp array */
                        files_list_progress = new Array();

                        if(end)
                            files_list_update();
                        else
                        {
                            files_list_progress.push(filename);

                            /* send command for first file*/
                            ws_main.send(Oxtel.QuerySubsequentFile());

                            console.log("QueryFirstFile: sent continue message");
                        };
                    };
                },
                'QuerySubsequentFile': function(end, filename)
                {
                    console.log("QuerySubsequentFile: end=" + end + ", filename=" + filename);

                    if(files_list_progress !== undefined && flr_dis)
                    {
                        if(end)
                            files_list_update();
                        else
                        {
                            files_list_progress.push(filename);

                            /* send command for first file*/
                            ws_main.send(Oxtel.QuerySubsequentFile());
                        };
                    };
                },
                'EnquireLoadImage': function(layer, filename)
                {
                    console.log("EnquireLoadImage: layer=" + layer + ", filename=" + filename);
                },
                'ImageLoadTally': function(layer, filename)
                {
                    console.log("ImageLoadTally: layer=" + layer + ", filename=" + filename);
                },
                'EnquireLayerDatasourceList': function(layer, list)
                {
                    var i;

                    var fields_list = parent_div.find('select.EnquireLayerDatasourceList');

                    fields_list.find('option').each(function(index)
                    {
                        $(this).remove();
                    });

                    console.log("EnquireLayerDatasourceList: layer=" + layer);

                    for(i = 0; i < list.length; i++)
                    {
                        console.log("EnquireLayerDatasourceList: [" + i + "]=[" + list[i] + "]");

                        fields_list.append
                        (
                            $("<option/>",
                            {
                                value: list[i],
                                text: list[i]
                            })
                        );
                    };
                },
                'EnquireMixerInput': function(mixer_input, video_source)
                {
                    console.log("EnquireMixerInput: mixer_input[" + mixer_input + "]=>[" + video_source + "]");
                },
            });
        };
    };

    ws_logger_connect();
    ws_main_connect();


    e = $('<h1 class="TheCoreElementsOxtelProxy head">Command builder</h1>');
    e.appendTo(col1);

    $('<input type="checkbox" class="TheCoreElementsOxtelProxy auto_send"><span>Auto send command</span>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<span>Transition duration</span><input class="TheCoreElementsOxtelProxy mix_dur" size="8" value="25">').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<button class="TheCoreElementsOxtelProxy build_button Cut_to_A">Cut to A</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Cut_to_B">Cut to B</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Cut_AB">Cut AB</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Fade_to_A">Fade to A</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Fade_to_B">Fade to B</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Fade_AB">Fade AB</button>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<button class="TheCoreElementsOxtelProxy build_button Enable_Video_Tallies">Enable Video Tallies</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Disable_Video_Tallies">Disable Video Tallies</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Enquire_Video_Tallies">Enquire Video Tallies</button>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<span>Layer Index</span><select class="TheCoreElementsOxtelProxy layer_index"><option value="0">0</option><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option><option value="6">6</option><option value="7">7</option><option value="8">8</option><option value="9">9</option><option value="10">10</option><option value="11">11</option><option value="12">12</option><option value="13">13</option><option value="14">14</option><option value="15">15</option></select>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<button class="TheCoreElementsOxtelProxy build_button Cut_Keyer_UP">Cut Keyer UP</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Cut_Keyer_DOWN">Cut Keyer DOWN</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Fade_Keyer_UP">Fade Keyer UP</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button Fade_Keyer_DOWN">Fade Keyer DOWN</button>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<button class="TheCoreElementsOxtelProxy build_button QueryFirstFile">Query First File</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button QuerySubsequentFile">Query Subsequent File</button>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<button class="TheCoreElementsOxtelProxy build_button EnquireFileInfo">Enquire File Info</button>').appendTo(col1);
    $('<input class="TheCoreElementsOxtelProxy EnquireFileInfo" size="32" value="NotExisingFile">').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<button class="TheCoreElementsOxtelProxy build_button EraseStore">Erase Store</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button EnquireLoadImage">Enquire Load Image</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button LoadImage">Load Image</button>').appendTo(col1);
    $('<select class="TheCoreElementsOxtelProxy files_list"></select>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button files_list_reload">Reload</button>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<button class="TheCoreElementsOxtelProxy build_button StartAnimation">Start Animation</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button StopAnimation0">Stop(0) Animation</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button StopAnimation1">Stop(1) Animation</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button RestartAnimation">Restart Animation</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button SelectAnimationFrame0">Select Animation Frame 0</button>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<span>Text</span><input class="TheCoreElementsOxtelProxy text_data" size="60">').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<span>Box no</span><select class="TheCoreElementsOxtelProxy box_no"><option value="0">0</option><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option><option value="6">6</option><option value="7">7</option><option value="8">8</option><option value="9">9</option><option value="10">10</option><option value="11">11</option><option value="12">12</option><option value="13">13</option><option value="14">14</option><option value="15">15</option></select>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button UpdateTextField">Update Text Field</button>').appendTo(col1);
    $('<input type="checkbox" class="TheCoreElementsOxtelProxy UpdateTextField_append"><span>Append</span>').appendTo(col1);
    $('<input type="checkbox" class="TheCoreElementsOxtelProxy UpdateTextField_render"><span>Render</span>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button RenderBox">Render Box</button>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button RenderBoxAll">Render Box All</button>').appendTo(col1);

    $('<br>').appendTo(col1);

    $('<button class="TheCoreElementsOxtelProxy build_button SetLayerDatasourceValue">Set Layer Datasource Value</button>').appendTo(col1);
    $('<select class="TheCoreElementsOxtelProxy EnquireLayerDatasourceList"><option value="t_demo">t_demo</option></select>').appendTo(col1);
    $('<button class="TheCoreElementsOxtelProxy build_button EnquireLayerDatasourceList">Enquire Layer Datasource List</button>').appendTo(col1);

    $('<br>').appendTo(col1);
    $(
        '<span>input A: </span>' +
        '<button class="TheCoreElementsOxtelProxy build_button EnquireMixerInput" mixer-input="0">EnquireMixerInput</button>' +
        '<button class="TheCoreElementsOxtelProxy build_button SelectMixerInput" mixer-input="0" video-source="0">0</button>' +
        '<button class="TheCoreElementsOxtelProxy build_button SelectMixerInput" mixer-input="0" video-source="1">1</button>' +
        '<button class="TheCoreElementsOxtelProxy build_button SelectMixerInput" mixer-input="0" video-source="2">2</button>' +
        '<button class="TheCoreElementsOxtelProxy build_button SelectMixerInput" mixer-input="0" video-source="3">3</button>' +
        '<br>' +
        '<span>input B: </span>' +
        '<button class="TheCoreElementsOxtelProxy build_button EnquireMixerInput" mixer-input="1">EnquireMixerInput</button>' +
        '<button class="TheCoreElementsOxtelProxy build_button SelectMixerInput" mixer-input="1" video-source="0">0</button>' +
        '<button class="TheCoreElementsOxtelProxy build_button SelectMixerInput" mixer-input="1" video-source="1">1</button>' +
        '<button class="TheCoreElementsOxtelProxy build_button SelectMixerInput" mixer-input="1" video-source="2">2</button>' +
        '<button class="TheCoreElementsOxtelProxy build_button SelectMixerInput" mixer-input="1" video-source="3">3</button>'
    ).appendTo(col1);

    $('<br>').appendTo(col1);

    parent_div.delegate("button.TheCoreElementsOxtelProxy.build_button", "click", function()
    {
        var cmd = "";

        var mix_dur = parent_div.find('.mix_dur').val();

        var text_data = parent_div.find('.text_data').val();

        var layer_index = parseInt(parent_div.find('.layer_index').val());

        var box_no = parseInt(parent_div.find('.box_no').val());

        var auto_send = parent_div.find('.auto_send').prop("checked");

        var files_item = parent_div.find('.files_list').find("option:selected").first().val();

        if(0) {}
        else if($(this).hasClass('Cut_to_A'))           cmd = Oxtel.CutA();
        else if($(this).hasClass('Cut_to_B'))           cmd = Oxtel.CutB();
        else if($(this).hasClass('Cut_AB'))             cmd = Oxtel.CutAB();
        else if($(this).hasClass('Fade_to_A'))          cmd = Oxtel.FadeA(mix_dur);
        else if($(this).hasClass('Fade_to_B'))          cmd = Oxtel.FadeB(mix_dur);
        else if($(this).hasClass('Fade_AB'))            cmd = Oxtel.FadeAB(mix_dur);
        else if($(this).hasClass('Cut_Keyer_UP'))       cmd = Oxtel.CutKeyer(layer_index, 1);
        else if($(this).hasClass('Cut_Keyer_DOWN'))     cmd = Oxtel.CutKeyer(layer_index, 0);
        else if($(this).hasClass('Fade_Keyer_UP'))      cmd = Oxtel.FadeKeyer(layer_index, 1, mix_dur);
        else if($(this).hasClass('Fade_Keyer_DOWN'))    cmd = Oxtel.FadeKeyer(layer_index, 0, mix_dur);
        else if($(this).hasClass('Enquire_Video_Tallies')) cmd = Oxtel.EnquireVideoTallies();
        else if($(this).hasClass('Enable_Video_Tallies')) cmd = Oxtel.EnableVideoTallies(1);
        else if($(this).hasClass('Disable_Video_Tallies')) cmd = Oxtel.EnableVideoTallies(0);
        else if($(this).hasClass('QuerySubsequentFile')) cmd = Oxtel.QuerySubsequentFile();
        else if($(this).hasClass('QueryFirstFile'))     cmd = Oxtel.QueryFirstFile();
        else if($(this).hasClass('EnquireFileInfo'))    cmd = Oxtel.EnquireFileInfo(parent_div.find('input.EnquireFileInfo').val());
        else if($(this).hasClass('EraseStore'))         cmd = Oxtel.EraseStore(layer_index);
        else if($(this).hasClass('LoadImage'))          cmd = Oxtel.LoadImage(layer_index, files_item);
        else if($(this).hasClass('EnquireLoadImage'))   cmd = Oxtel.EnquireLoadImage(layer_index);
        else if($(this).hasClass('StartAnimation'))     cmd = Oxtel.StartAnimation(layer_index);
        else if($(this).hasClass('RestartAnimation'))   cmd = Oxtel.RestartAnimation(layer_index);
        else if($(this).hasClass('SelectAnimationFrame0'))   cmd = Oxtel.SelectAnimationFrame(layer_index, 0);
        else if($(this).hasClass('StopAnimation0'))     cmd = Oxtel.StopAnimation(layer_index, 0);
        else if($(this).hasClass('StopAnimation1'))     cmd = Oxtel.StopAnimation(layer_index, 1);
        else if($(this).hasClass('RenderBox'))          cmd = Oxtel.RenderBox(layer_index, box_no);
        else if($(this).hasClass('RenderBoxAll'))       cmd = Oxtel.RenderBox(layer_index, 255);
        else if($(this).hasClass('UpdateTextField'))    cmd = Oxtel.UpdateTextField(
            layer_index, box_no,
            parent_div.find('.UpdateTextField_render').prop("checked"),
            parent_div.find('.UpdateTextField_append').prop("checked"), text_data);
        else if($(this).hasClass('EnquireLayerDatasourceList')) cmd = Oxtel.EnquireLayerDatasourceList(layer_index);
        else if($(this).hasClass('SetLayerDatasourceValue')) cmd = Oxtel.SetLayerDatasourceValue(true, true, layer_index,
            parent_div.find('select.EnquireLayerDatasourceList').find("option:selected").first().val(), text_data);

        else if($(this).hasClass('EnquireMixerInput')) cmd = Oxtel.EnquireMixerInput(parseInt($(this).attr('mixer-input')));
        else if($(this).hasClass('SelectMixerInput')) cmd = Oxtel.SelectMixerInput(parseInt($(this).attr('mixer-input')), parseInt($(this).attr('video-source')));

        else if($(this).hasClass('files_list_reload'))
        {
            var files_list = parent_div.find('.files_list');

            /* disable button */
            $(this).prop('disabled', true);
            files_list.prop('disabled', true);

            /* clear list */
            files_list.find('option').each(function(index)
            {
                $(this).remove();
            });

            /* send command for first file*/
            ws_main.send(Oxtel.QueryFirstFile());

            return;
        };

        if(cmd != "")
        {
            cmd_text.val(cmd);

            if(auto_send)
                ws_main.send(cmd);
        };
    });

}
