#!/usr/bin/env python2

import os

from gimpfu import *
import os.path
import time
import datetime
import socket

# File will be here
# C:\Users\verem\Application Data\GIMP\2.10\plug-ins

# please edit this values accoring to your environment
target_oxtel_host = "10.1.5.57" # IP adress of OXTEL server
target_oxtel_port = 5007 # PORT that oxtel server listen to
target_oxtel_layer = 1 # LAYER that will be used for loading still
target_png_save_path = "\\\\dev-5\\FLASH\\" # shared image folder of oxtel server

gettext.install("gimp20-python", gimp.locale_directory, unicode=True)

def show_error_msg(msg):
    origMsgHandler = pdb.gimp_message_get_handler()
    pdb.gimp_message_set_handler(ERROR_CONSOLE)
    pdb.gimp_message("Error: %s" % (msg))
    pdb.gimp_message_set_handler(origMsgHandler)
    return

def new_proc_1080():
  return new_proc(1920, 1080)

def new_proc_720():
  return new_proc(1280, 720)

def new_proc(width, height):
  show_error_msg("here1")

  img = gimp.Image(width , height, type = RGB) # creates an image object called img.

  img.add_hguide(100)
  img.add_hguide(980)
  img.add_vguide(100)
  img.add_vguide(1820)

  layer = gimp.Layer(img, "name", img.width, img.height, type = RGBA_IMAGE, opacity = 0.0, mode = NORMAL_MODE) # creates a layer object called layer.
  img.add_layer(layer, ) # inserts a layer into an image.
#  layer.fill(TRANSPARENT_FILL)
  pdb.gimp_layer_add_alpha(layer)
  pdb.gimp_drawable_fill(layer, TRANSPARENT_FILL)
  pdb.gimp_display_new(img)
  show_error_msg("here2")
  return img

def oxtel_command_body_send(body):
  show_error_msg("oxtel_command_body_send: connecting to [%s:%d]..." % (target_oxtel_host, target_oxtel_port))
  s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
  s.settimeout(1)
  try:
    s.connect((target_oxtel_host, target_oxtel_port))
    show_error_msg("oxtel_command_body_send: sending [%s]" % (body))
    s.send(body)
    show_error_msg("oxtel_command_body_send: done")
    s.close()
  except socket.error as exc:
    show_error_msg("oxtel_command_body_send: socket.error=[%s]" % (exc))
  except TypeError as exc:
    show_error_msg("oxtel_command_body_send: TypeError=[%s]" % (exc))
  return

def cue_proc(inImage, inDrawable):
  show_error_msg('cue_proc: entering')
  tmp = inImage.duplicate()
  tmp.merge_visible_layers(NORMAL_MODE)
  ts = time.time()
  ts_fmt = datetime.datetime.fromtimestamp(ts).strftime("%Y%m%d_%H%M%S")
  filename = "TheCoreStillStore-" + ts_fmt + ".png"
  show_error_msg("cue_proc: [%s] @ [%s]" % (filename, target_png_save_path))
  pdb.file_png_save(tmp, tmp.layers[0], target_png_save_path + filename, filename, 0, 9, 1, 1, 1, 1, 1)
  oxtel_command_body_send("R0%1x%s:" % (target_oxtel_layer, filename))

#  gimp.delete(img)
  show_error_msg('cue_proc: exiting')

def cue_cut_on_proc(inImage, inDrawable):
  cue_proc(inImage, inDrawable)
  cut_on_proc()

def cue_fade_in_proc(inImage, inDrawable):
  cue_proc(inImage, inDrawable)
  fade_in_proc()

def cut_on_proc():
  oxtel_command_body_send("3%x %x:" % (target_oxtel_layer, 1))

def cut_off_proc():
  oxtel_command_body_send("3%x %x:" % (target_oxtel_layer, 0))

def fade_in_proc():
  oxtel_command_body_send("1%x %x:" % (target_oxtel_layer, 1))

def fade_out_proc():
  oxtel_command_body_send("1%x %x:" % (target_oxtel_layer, 0))

register(
    "TheCoreStillStore-new1080", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("NEW HD1080"),
    None, #image type
    [],
    [
      (PF_IMAGE, 'image', 'Output image')  #results. Format (type, name, description)
    ],
    new_proc_1080, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )

register(
    "TheCoreStillStore-new720", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("NEW HD720"),
    None, #image type
    [],
    [
      (PF_IMAGE, 'image', 'Output image')  #results. Format (type, name, description)
    ],
    new_proc_720, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )

register(
    "TheCoreStillStore-cue", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("CUE"),
    "RGB*", #image type
    [
      #input args. Format (type, name, description, default [, extra])
      (PF_IMAGE, "image", "Input image", None),
      (PF_DRAWABLE, "idrawable", "Input drawable", None)
    ],
    [
      #results. Format (type, name, description)
    ],
    cue_proc, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )

register(
    "TheCoreStillStore-cue-fade-in", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("CUE & Fade IN"),
    "RGB*", #image type
    [
      #input args. Format (type, name, description, default [, extra])
      (PF_IMAGE, "image", "Input image", None),
      (PF_DRAWABLE, "idrawable", "Input drawable", None)
    ],
    [
      #results. Format (type, name, description)
    ],
    cue_fade_in_proc, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )

register(
    "TheCoreStillStore-cue-cut-on", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("CUE & CUT ON"),
    "RGB*", #image type
    [
      #input args. Format (type, name, description, default [, extra])
      (PF_IMAGE, "image", "Input image", None),
      (PF_DRAWABLE, "idrawable", "Input drawable", None)
    ],
    [
      #results. Format (type, name, description)
    ],
    cue_cut_on_proc, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )

register(
    "TheCoreStillStore-cut-off", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("CUT OFF"),
    None, #image type
    [],
    [],
    cut_off_proc, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )

register(
    "TheCoreStillStore-fade-out", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("FADE OUT"),
    None, #image type
    [],
    [],
    cut_off_proc, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )

register(
    "TheCoreStillStore-cut-on", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("CUT ON"),
    None, #image type
    [],
    [],
    cut_on_proc, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )

register(
    "TheCoreStillStore-fade-in", #name
    N_("This is demo plugin"),  #description
    "This plugin demo blablabla",
    "Maksym Veremeyenko", #author
    "Maksym Veremeyenko", #copyright
    "2019", #year
    N_("FADE IN"),
    None, #image type
    [],
    [],
    fade_in_proc, #callback
    menu="<Image>/TheCoreStillStore",
    domain=("gimp20-python", gimp.locale_directory)
    )


main()
