$.fn.TheCoreElementsMulti_attach = function(params)
{
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsMulti main"></div>');
    main_div.appendTo(parent_div);

    var preset_header_div = $('<div class="TheCoreElementsMulti header">PRESETS</div>');
    preset_header_div.appendTo(main_div);

    var preset_selectors_div = $('<div class="TheCoreElementsMulti preset_selectors"></div>');
    preset_selectors_div.appendTo(main_div);

    var layout_header_div = $('<div class="TheCoreElementsMulti header">LAYOUT</div>');
    layout_header_div.appendTo(main_div);

    var layout_selectors_div = $('<div class="TheCoreElementsMulti layout_selectors"></div>');
    layout_selectors_div.appendTo(main_div);

    var input_header_div = $('<div class="TheCoreElementsMulti header">INPUTS <button class="input_selectors_save">SAVE</button></div>');
    input_header_div.appendTo(main_div);

    var input_selectors_div = $('<div class="TheCoreElementsMulti input_selectors"></div>');
    input_selectors_div.appendTo(main_div);

    for(var i = 0; i < 16; i++)
    {
        var btn = $('<div class="TheCoreElementsMulti preset_selector"><span class="index"></span><br><span class="title"></span></div>');
        btn.attr('preset-idx', i);
        btn.addClass('passive');
        btn.find('.index').text(i + 1);
        btn.appendTo(preset_selectors_div);
    };

    function GetStat(retry_delay)
    {
        $.getJSON
        (
            'TheCoreElementsMulti.GetStat.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(curr)
        {
            console.log("GetStat:" + JSON.stringify(curr));

            if(!(typeof curr.amend === 'undefined'))
            {
                console.log("amend=" + amend + ", curr.amend=" + curr.amend);
                if(amend < curr.amend)
                {
                    console.log("will apply changes");
                    amend = curr.amend;

                    /* highlight preset */
                    preset_selectors_div.find("div.TheCoreElementsMulti.preset_selector").each(function(index)
                    {
                        var a = parseInt($(this).attr('preset-idx'));
                        var b = parseInt(curr.curr);

                        console.log("a=" + a + ", b=" + b);

                        $(this).removeClass('active');
                        $(this).removeClass('passive');

                        if(a == b)
                        {
                            $(this).addClass('active');
                            update_layout(a);
                        }
                        else
                            $(this).addClass('passive');
                    });
                };
            }
            else
            {
                amend = -1;
            }

            if(retry_delay > 0)
                window.setTimeout(function() { GetStat(retry_delay); }, retry_delay);
        })
        .fail(function(msg)
        {
            layout_selectors_div.empty();
            input_selectors_div.empty();

            amend = -1;
            if(retry_delay > 0)
                window.setTimeout(function() { GetStat(retry_delay); }, 4 * retry_delay);
        });
    };

    function update_layout(selected_preset)
    {
        $.getJSON
        (
            'TheCoreElementsMulti.GetPreset.php',
            {
                'xmlrpc_port' : params['port'],
                'preset_idx': selected_preset,
            }
        )
        .done(function(preset)
        {
            layout_selectors_div.empty();
            input_selectors_div.empty();

            console.log("GetPreset:" + JSON.stringify(preset));

            // build window layout selector
            for(var i = 0; i < preset.layouts.length; i++)
            {
                var btn = $('<div class="TheCoreElementsMulti layout_selector"></div>');
                btn.attr('layout-idx', i);
                btn.attr('preset-idx', parseInt(preset.preset));
                btn.appendTo(layout_selectors_div);

                function draw_layout_button(parent_btn, layout)
                {
                    var W = parseInt(parent_btn.css('width')) - 4, H = parseInt(parent_btn.css('height')) - 4;
//                    console.log("W=" + W + ", H=" + H + ", layout=" + JSON.stringify(layout));

                    for(var i = 0; i < layout.length; i++)
                    {
                        var w = $('<div class="TheCoreElementsMulti layout_selector_item"></div>');
                        w.appendTo(parent_btn);
                        w.text((i + 1));
                        var
                            left = (parseInt(layout[i].x_num) * W / parseInt(layout[i].x_den)),
                            top = (parseInt(layout[i].y_num) * H / parseInt(layout[i].y_den)),
                            width = (parseInt(layout[i].w_num) * W / parseInt(layout[i].w_den)),
                            height = (parseInt(layout[i].h_num) * H / parseInt(layout[i].h_den));

//                        console.log("i=" + i + ", top=" + top + ", left=" + left + ", width=" + width + ", height=" + height);

                        w.css({'top': top, 'left': left, 'width': width, 'height': height, 'z-index': (100+i) });
                    };
                };

//                console.log("LAYOUT=" + i);

                draw_layout_button(btn, preset.layouts[i]);

                if(i == parseInt(preset.window_layout_idx))
                    btn.addClass('active');
                else
                    btn.addClass('passive');
            };

            // build input selector
            {
                var table = $('<table class="TheCoreElementsMulti"></table>');
                table.appendTo(input_selectors_div);
                table.attr('preset-idx', parseInt(preset.preset));

                var thead = $('<thead></thead>');
                thead.appendTo(table);

                var thead_tr = $('<tr></tr>');
                thead_tr.appendTo(thead);

                $('<th class="WIN">WIN</th>').appendTo(thead_tr);
                $('<th class="INPUT">INPUT</th>').appendTo(thead_tr);
                $('<th class="UMD">UMD</th>').appendTo(thead_tr);
                $('<th class="AUD">AUD</th>').appendTo(thead_tr);
                $('<th class="OSD">OSD</th>').appendTo(thead_tr);
                $('<th class="IO">IO</th>').appendTo(thead_tr);
                $('<th class="BAR0">BAR0</th>').appendTo(thead_tr);
                $('<th class="BAR1">BAR1</th>').appendTo(thead_tr);
                $('<th class="BAR2">BAR2</th>').appendTo(thead_tr);
                $('<th class="BAR3">BAR3</th>').appendTo(thead_tr);

                var tbody = $('<tbody></tbody>');
                tbody.appendTo(table);

                for(var inp = 0; inp < 16; inp++)
                {
                    var td;
                    var tr = $('<tr></tr>');
                    tr.appendTo(tbody);
                    tr.attr('input-idx', inp);
                    tr.addClass('INPUT_ITEM');

                    td = $('<td class="WIN"></td>');
                    td.text(inp + 1);
                    td.appendTo(tr);

                    td = $('<td class="INPUT"></td>');
                    td.appendTo(tr);
                    var td_sel = $('<select class="INPUT"></select>');
                    td_sel.attr('input-idx', inp);
                    td_sel.attr('matrix-output-idx', preset.inputs[inp].matrix_output);
                    td_sel.prop('disabled', true);
                    td_sel.appendTo(td);

                    td = $('<td class="UMD"></td>');
                    td.appendTo(tr);
                    td_input = $('<input type="input" class="UMD">');
                    td_input.attr('input-idx', inp);
                    td_input.val(preset.inputs[inp].umd);
//                    console.log("preset.inputs["+inp+"].umd=" + preset.inputs[inp].umd);
                    td_input.appendTo(td);

                    td = $('<td class="AUD"></td>');
                    td.appendTo(tr);
                    td_input = $('<input type="radio" name="AUD" class="AUD">');
                    td_input.attr('input-idx', inp);
                    td_input.val(preset.inputs[inp].umd);
                    td_input.appendTo(td);
                    td_input.prop('checked', preset.aud == inp)

                    td = $('<td class="OSD"></td>');
                    td.appendTo(tr);
                    td_input = $('<select class="OSD"></select>');
                    td_input.attr('input-idx', inp);
                    td_input.appendTo(td);
                    var osd_titles = ["NONE", "TC", "FILE", "TC+FILE"];
                    for(var osd_idx = 0; osd_idx < osd_titles.length; osd_idx++)
                    {
                        var o = $('<option></option>'); o.appendTo(td_input);
                        o.val(osd_idx);
                        o.text(osd_titles[osd_idx]);
                        if(osd_idx == preset.inputs[inp].osd)
                            o.attr("selected","selected");
                    };

                    td = $('<td class="IO"></td>');
                    td.appendTo(tr);
                    td_input = $('<select class="IO"></select>');
                    td_input.attr('input-idx', inp);
                    td_input.appendTo(td);
                    for(var io_idx = 0; io_idx < 10; io_idx++)
                    {
                        var q = (!io_idx) ? 0 : (8090 + (io_idx - 1));
                        var t = (!io_idx) ? "" : q;

                        var o = $('<option></option>'); o.appendTo(td_input);

                        o.val(q);
                        o.text(t);

                        if(q == preset.inputs[inp].thecoreio)
                            o.attr("selected","selected");
                    };

                    for(var b_idx = 0; b_idx < 4; b_idx++)
                    {
                        var audio_bars_types =
                        [
                            "NONE",
                            "QPM (1)",
                            "QPM (2)",
                            "QPM (3)",
                            "QPM (4)",
                            "QPM (5)",
                            "QPM (6)",
                            "QPM (7)",
                            "QPM (8)",
                            "LM (1)",
                            "LS (1)",
                            "LM (2)",
                            "LS (2)",
                            "LM (3)",
                            "LS (3)",
                            "LM (4)",
                            "LS (4)",
                        ];

                        var b =
                            (b_idx == 0) ? preset.inputs[inp].bar0 :
                            (b_idx == 1) ? preset.inputs[inp].bar1 :
                            (b_idx == 2) ? preset.inputs[inp].bar2 :
                            preset.inputs[inp].bar3;

                        td = $('<td class="BAR' + b_idx + '"></td>');
                        td.appendTo(tr);
                        var td_sel = $('<select class="BAR' + b_idx + '"></select>');
                        td_sel.attr('input-idx', inp);
                        td_sel.appendTo(td);
                        for(var sel_idx = 0; sel_idx < audio_bars_types.length; sel_idx++)
                        {
                            var o = $('<option></option>'); o.appendTo(td_sel);
                            o.val(sel_idx);
                            o.text(audio_bars_types[sel_idx]);
                            if(sel_idx == b)
                                o.attr("selected","selected");
                        };
                    }
                };

                /* update labels */
                $.getJSON
                (
                    'TheCoreElementsMulti.GetLabels.php',
                    {
                        'xmlrpc_port' : params['port'],
                    }
                )
                .done(function(labels)
                {
                    table.find('select.INPUT').each(function(index)
                    {
                        var sel_idx;
                        var td_sel = $(this);
                        var inp = td_sel.attr('input-idx');
                        var matrix_output = td_sel.attr('matrix-output-idx');

                        for(sel_idx = 1; sel_idx < labels.outputs.length; sel_idx++)
                        {
                            var o = $('<option></option>');
                            o.appendTo(td_sel);
                            o.val(sel_idx);
                            o.text(sel_idx + ' - ' + labels.outputs[sel_idx]);
                            if(sel_idx == matrix_output)
                                o.attr("selected","selected");
                        };

                        for(sel_idx = 0; sel_idx < labels.inputs.length; sel_idx++)
                        {
                            var o = $('<option></option>');
                            o.appendTo(td_sel);
                            o.val(-sel_idx);
                            o.text(sel_idx + ' - ' + labels.inputs[sel_idx]);
                            if(-sel_idx == matrix_output)
                                o.attr("selected","selected");
                        };

                        td_sel.prop('disabled', false);
                    });
                });
            };
        });
    };

    GetStat(1000);

    input_header_div.delegate("button.input_selectors_save", "click", function()
    {
        var t = input_selectors_div.find('table.TheCoreElementsMulti');
        var p = t.attr('preset-idx');

        console.log("Will save input state for preset_idx=" + p);

        var inputs = new Array(16);

        for(var i = 0; i < 16; i++)
            inputs[i] = {'matrix_output': 0, 'umd':'', 'bar0':0, 'bar1':0, 'bar2':0, 'bar2':0, 'osd':0, 'io':0};

        var aud = 0;
        t.find('tr.INPUT_ITEM').each(function(index)
        {
            var idx = parseInt($(this).attr('input-idx'));

            inputs[idx]['matrix_output']  = $(this).find('select.INPUT').val();
            inputs[idx]['umd']  = $(this).find('input.UMD').val();
            inputs[idx]['bar0'] = $(this).find('select.BAR0').val();
            inputs[idx]['bar1'] = $(this).find('select.BAR1').val();
            inputs[idx]['bar2'] = $(this).find('select.BAR2').val();
            inputs[idx]['bar3'] = $(this).find('select.BAR3').val();
            inputs[idx]['osd'] = $(this).find('select.OSD').val();
            inputs[idx]['io'] = $(this).find('select.IO').val();

            if($(this).find('input.AUD').prop('checked'))
                aud = idx;
        });

        $.post
        (
            'TheCoreElementsMulti.SetInputs.php',
            {
                'xmlrpc_port' : params['port'],
                'preset_idx': p,
                'inputs': inputs,
                'aud': aud,
            }
        )
        .done
        (
            function(curr)
            {
                GetStat(-1);
            }
        );
    });

    preset_selectors_div.delegate("div.TheCoreElementsMulti.preset_selector", "click", function()
    {
        var a = parseInt($(this).attr('preset-idx'));

        console.log("Will switch preset to index " + a);

        $.getJSON
        (
            'TheCoreElementsMulti.SetCurr.php',
            {
                'xmlrpc_port' : params['port'],
                'preset_idx': a,
            }
        )
        .done
        (
            function(curr)
            {
                GetStat(-1);
            }
        );
    });

    layout_selectors_div.delegate("div.TheCoreElementsMulti.layout_selector", "click", function()
    {
        var preset_idx = parseInt($(this).attr('preset-idx'));
        var layout_idx = parseInt($(this).attr('layout-idx'));

        console.log("layout_idx="+layout_idx+", preset_idx=" + preset_idx);

        $.getJSON
        (
            'TheCoreElementsMulti.SetLayout.php',
            {
                'xmlrpc_port' : params['port'],
                'preset_idx': preset_idx,
                'layout_idx': layout_idx,
            }
        )
        .done
        (
            function(curr)
            {
                GetStat(-1);
            }
        );
    });

}
