$.fn.TheCoreElementsDSP_attach = function(params)
{
    var b;
    var parent_div = this;

    var tab_switcher = $('<div class="TheCoreElementsDSP tab_switcher"></div>');
    tab_switcher.appendTo(parent_div);

    var oper = $('<div class="TheCoreElementsDSP tab_oper"></div>');
    oper.appendTo(parent_div);

    b = $('<div class="TheCoreElementsDSP tab_switch CONF" title="Configuration"></div>');
    b.appendTo(tab_switcher);

    b = $('<div class="TheCoreElementsDSP tab_switch EMBED" title="Embedder"></div>');
    b.appendTo(tab_switcher);

    tab_switcher.delegate("div.TheCoreElementsDSP.tab_switch", "mousedown", function()
    {
        tab_switcher.find('div.TheCoreElementsDSP.tab_switch').removeClass('active');
        $(this).addClass('active');

        oper.empty();
        oper.remove();
        oper = $('<div class="TheCoreElementsDSP tab_oper"></div>');
        oper.appendTo(parent_div);

        if($(this).hasClass('CONF'))
        {
            console.log("TheCoreElementsDSP.tab_switch: CONF");
            oper.TheCoreElementsDSP_conf_attach(params);
        }
        else if($(this).hasClass('EMBED'))
        {
            console.log("TheCoreElementsDSP.tab_switch: EMBED");
            oper.TheCoreElementsDSP_audio_embed_attach(params);
        };
    });

    tab_switcher.find('div.TheCoreElementsDSP.tab_switch.EMBED').trigger('mousedown');
};


$.fn.TheCoreElementsDSP_conf_attach = function(params)
{
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsDSP main"></div>');
    main_div.appendTo(parent_div);

    var input_header_div = $('<div class="TheCoreElementsDSP header">CONNECTIONS <button class="connectors_save">SAVE</button></div>');
    input_header_div.appendTo(main_div);

    var input_selectors_div = $('<div class="TheCoreElementsDSP connectors"></div>');
    input_selectors_div.appendTo(main_div);

    function update_connections()
    {
        $.getJSON
        (
            'TheCoreElementsDSP.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(conns)
        {
            input_selectors_div.empty();

            console.log("GetConnections:" + JSON.stringify(conns));

            var srcs = parseInt(conns.srcs), keys = parseInt(conns.keys), dsks = parseInt(conns.dsks);

            // build input selector
            {
                var i;
                var table = $('<table class="TheCoreElementsDSP"></table>');
                table.appendTo(input_selectors_div);
                table.attr('cnt-srcs', srcs);
                table.attr('cnt-keys', keys);
                table.attr('cnt-dsks', dsks);

                var thead = $('<thead></thead>');
                thead.appendTo(table);

                var thead_tr = $('<tr></tr>');
                thead_tr.appendTo(thead);

                $('<th class="TYPE">TYPE</th>').appendTo(thead_tr);
                $('<th class="CONN">CONN</th>').appendTo(thead_tr);

                var tbody = $('<tbody></tbody>');
                tbody.appendTo(table);

                function append_row(type, matrix, conn_output)
                {
                    var td;
                    var tr = $('<tr></tr>');
                    tr.appendTo(tbody);
                    tr.attr('row-type', type);
                    tr.addClass('CONN');

                    td = $('<td class="TYPE"></td>');
                    td.text(type);
                    td.appendTo(tr);

                    td = $('<td class="CONN"></td>');
                    td.appendTo(tr);
                    var td_sel = $('<select class="CONN"></select>');
                    td_sel.attr('matrix-idx', matrix);
                    td_sel.prop('disabled', true);
                    td_sel.appendTo(td);
                    if(conn_output)
                        td_sel.addClass('CONN_OUTPUT');
                };

                append_row('INP', conns.inp, 0);
                append_row('OUT', conns.out, 1);
                append_row('AUX', conns.aux, 0);

                /* update labels */
                $.getJSON
                (
                    'TheCoreElementsDSP.GetLabels.php',
                    {
                        'xmlrpc_port' : params['port'],
                    }
                )
                .done(function(labels)
                {
                    table.find('select.CONN').each(function(index)
                    {
                        var sel_idx;
                        var td_sel = $(this);
                        var matrix_output = td_sel.attr('matrix-idx');

                        if(!td_sel.hasClass('CONN_OUTPUT'))
                        for(sel_idx = 1; sel_idx < labels.outputs.length; sel_idx++)
                        {
                            var o = $('<option></option>');
                            o.appendTo(td_sel);
                            o.val(sel_idx);
                            o.text(sel_idx + ' - ' + labels.outputs[sel_idx]);
                            if(sel_idx == matrix_output)
                                o.attr("selected","selected");
                        };

                        for(sel_idx = 0; sel_idx < labels.inputs.length; sel_idx++)
                        {
                            var o = $('<option></option>');
                            o.appendTo(td_sel);
                            o.val(-sel_idx);
                            o.text(sel_idx + ' - ' + labels.inputs[sel_idx]);
                            if(-sel_idx == matrix_output)
                                o.attr("selected","selected");
                        };

                        td_sel.prop('disabled', false);
                    });
                });
            };
        });
    };

    update_connections();

    input_header_div.delegate("button.connectors_save", "click", function()
    {
        var t = input_selectors_div.find('table.TheCoreElementsDSP');

        var conn =
        {
            "inp": 0,
            "out": 0,
            "aux": 0,
        };

        t.find('tr.CONN').each(function(index)
        {
            var type = $(this).attr('row-type');
            var c = parseInt($(this).find('select.CONN').val());

            if(type == 'INP') conn['inp'] = c;
            else if(type == 'OUT') conn['out'] = c;
            else if(type == 'AUX') conn['aux'] = c;
        });

        $.post
        (
            'TheCoreElementsDSP.SetConnections.php',
            {
                'xmlrpc_port' : params['port'],
                'conn': conn
            }
        )
        .done
        (
            function(curr)
            {
                update_connections();
            }
        );
    });
}


$.fn.TheCoreElementsDSP_audio_embed_attach = function(params)
{
    var parent_div = this;
    var amend = -1;

    console.log("HERE");

    var main_div = $('<div class="TheCoreElementsDSP main"></div>');
    main_div.appendTo(parent_div);

    var header_div = $('<div class="TheCoreElementsDSP header">AUDIO EMBEDDING <button class="audio_embed_save">SAVE</button></div>');
    header_div.appendTo(main_div);

    var selectors_div = $('<div class="TheCoreElementsDSP audio_embed"></div>');
    selectors_div.appendTo(main_div);

    function update()
    {
        $.getJSON
        (
            'TheCoreElementsDSP.GetTally.php',
            {
                'xmlrpc_port' : params['port']
            }
        )
        .done(function(conns)
        {
            var i, j;

            console.log("GetTally:" + JSON.stringify(conns));

            selectors_div.empty();

            // build input selector
            var table = $('<table class="TheCoreElementsDSP"></table>');
            table.appendTo(selectors_div);

            var thead = $('<thead></thead>');
            thead.appendTo(table);

            var thead_tr1 = $('<tr></tr>'); thead_tr1.appendTo(thead);
            $('<th class="DST">DST</th>').appendTo(thead_tr1);
            $('<th class="SRC" colspan="17">SRC</th>').appendTo(thead_tr1);

            var thead_tr2 = $('<tr></tr>'); thead_tr2.appendTo(thead);
            $('<th class="OUT" rowspan="2">OUT</th>').appendTo(thead_tr2);
            $('<th class="IN" colspan="8">INP</th>').appendTo(thead_tr2);
            $('<th class="AUX" colspan="8">AUX</th>').appendTo(thead_tr2);
            $('<th class="NONE"> </th>').appendTo(thead_tr2);

            var thead_tr3 = $('<tr></tr>'); thead_tr3.appendTo(thead);
            for(i = 0; i < 8; i++)
                $('<th class="SRCS">' + (i + 1)  + '</th>').appendTo(thead_tr3);
            for(i = 0; i < 8; i++)
                $('<th class="SRCS">' + (i + 1)  + '</th>').appendTo(thead_tr3);
            $('<th class="X">X</th>').appendTo(thead_tr3);

            var tbody = $('<tbody></tbody>');
            tbody.appendTo(table);

            for(j = 0; j < 8; j++)
            {
                var tbody_tr = $('<tr></tr>'); tbody_tr.appendTo(tbody);

                $('<td class="DSTS">' + (1 + j) + '</td>').appendTo(tbody_tr);

                for(i = 0; i < 17; i++)
                {
                    var td = $('<td class="SRCS"></td>');
                    td.appendTo(tbody_tr);
                    if(i < 8)
                        td.addClass("INP");
                    else if(i < 16)
                        td.addClass("AUX");
                    else
                        td.addClass("NONE");

                    var btn = $('<input type="radio">');
                    btn.attr('name', 'src_' + j);
                    btn.attr('value', i);
                    btn.appendTo(td);

                    if(i == conns.audio_embed[j])
                        btn.attr('checked', 'checked');
                };
            };
        });
    };

    update();

    header_div.delegate("button.audio_embed_save", "click", function()
    {
        var t = selectors_div.find('table.TheCoreElementsDSP');

        var inputs = new Array(8);

        for(var i = 0; i < 8; i++)
        {
            var o = t.find('input:radio[name=src_' + i + ']:checked');
            inputs[i] = o.val();
        };

        $.post
        (
            'TheCoreElementsDSP.SetAudioEmbed.php',
            {
                'xmlrpc_port' : params['port'],
                'inputs': inputs
            }
        )
        .done
        (
            function(curr)
            {
                update();
            }
        );
    });
}
