var bus = 0;
var f_online = 0;
var last;
var timer = null;

var THECOREBOX_EVENT_FLAG_CUE           = (1 << 0);
var THECOREBOX_EVENT_FLAG_PLAY          = (1 << 1);
var THECOREBOX_EVENT_FLAG_EXIST         = (1 << 2);
var THECOREBOX_EVENT_FLAG_CUE_DONE      = (1 << 3);
var THECOREBOX_EVENT_FLAG_CUE_FAILED    = (1 << 4);
var THECOREBOX_EVENT_FLAG_PLAY_FAILED   = (1 << 5);
var THECOREBOX_EVENT_FLAG_PLAY_DONE     = (1 << 6);
var THECOREBOX_EVENT_FLAG_ABSENT        = (1 << 7);

var THECOREBOX_BUS_STATE_ER_FLAGS       = 0;
var THECOREBOX_BUS_STATE_ER_SYS_ID      = 1;
var THECOREBOX_BUS_STATE_ER_START       = 2;
var THECOREBOX_BUS_STATE_ER_CURR_SYS_ID = 3;

var THECOREBOX_EVENT_START_FOLLOW       = ' ';
var THECOREBOX_EVENT_START_FIXED        = 'F';
var THECOREBOX_EVENT_START_MANUAL       = 'M';

function timer_format(tc)
{
//    return tc;

    var c;

    /* drop sign */
    c = tc.substring(0, 1);
    if(c == '+' || c == '-')
        tc = tc.substring(1);

    /* find last : */
    c = tc.lastIndexOf(':');
    if(c > 0)
        tc = tc.substring(0, c);

    return tc;
};

function start_time_build(tc, time)
{
//    return tc;

    var
        mili_sec = time % 1000,
        epoch_sec = (time - mili_sec) / 1000,
        d = new Date(0);

    d.setUTCSeconds(epoch_sec);

    if(d.toLocaleFormat !== undefined)
        return d.toLocaleFormat('%Y-%b-%d %H:%M:%S');
    else
        return ("000" + d.getFullYear()).slice(-4) + '-' + ('0' + (1 + d.getMonth())).slice(-2) + '-' + ('0' + d.getDate()).slice(-2) + ' ' + ('0' + d.getHours()).slice(-2) + ':' + ('0' + d.getMinutes()).slice(-2) + ':' + ('0' + d.getSeconds()).slice(-2);
};

// http://upshots.org/javascript/jquery-test-if-element-is-in-viewport-visible-on-screen
$.fn.isOnScreen = function()
{
    var viewport = {};
    viewport.top = $(window).scrollTop();
    viewport.bottom = viewport.top + $(window).height();
    var bounds = {};
    bounds.top = this.offset().top;
    bounds.bottom = bounds.top + this.outerHeight();
    return ((bounds.top <= viewport.bottom) && (bounds.bottom >= viewport.top));
};

function state_text(obj, name)
{
    if(obj === undefined)
        return "";

    if(obj["state"] === undefined)
        return "";

    if(obj["state"][name] === undefined)
        return "";

    return obj["state"][name];
};

function update_row(index_top, resp)
{
///    console.log("update_row: index=" + index + " event=" + JSON.stringify(resp));

    var j, events = resp['events'];

    for(j = 0; j < events.length; j++)
    {
        var event = events[j];
        var e = event['event'].split("\t");
        var index = parseInt(events[j]['index']);

        $("#playlist_body").find(".playlist_item").eq(index).each(function(){

///         console.log("update_row: index=" + index + " items=" + JSON.stringify(e));
///         console.log("update_row: updating");

            $(this).attr('amend', event['state']['amend']);
            $(this).find('.START').text(start_time_build(e[0], event['state']['er'][THECOREBOX_BUS_STATE_ER_START]));
            $(this).find('.IN').text(e[2]);
            $(this).find('.OUT').text(e[3]);
            $(this).find('.DUR').text(e[4]);
            $(this).find('.T').text(e[5]);
            $(this).find('.MEDIA_ID').text(e[6]);
            $(this).find('.TITLE').text(e[7]);
            $(this).find('.ASSETS').text(e[8]);
            if(e[1] == THECOREBOX_EVENT_START_FIXED)
                $(this).find('.S').attr('src', 'static/start_type_fixed_time.png');
            else if(e[1] == THECOREBOX_EVENT_START_MANUAL)
                $(this).find('.S').attr('src', 'static/start_type_manual.png');
            else
                $(this).find('.S').attr('src', 'static/start_type_follow.png');

            notes = "";
            flags = event['state']['er'][THECOREBOX_BUS_STATE_ER_FLAGS];
            if(flags & THECOREBOX_EVENT_FLAG_PLAY_FAILED)
                notes = "PLAY FAILED";
            else if(flags & THECOREBOX_EVENT_FLAG_PLAY_DONE)
                notes = "PLAYING";
            else if(flags & THECOREBOX_EVENT_FLAG_PLAY)
                notes = "PLAY";
            else if(flags & THECOREBOX_EVENT_FLAG_CUE_FAILED)
                notes = "CUE FAILED";
            else if(flags & THECOREBOX_EVENT_FLAG_CUE_DONE)
                notes = "CUED";
            else if(flags & THECOREBOX_EVENT_FLAG_CUE)
                notes = "CUEING";
            else if(!(flags & THECOREBOX_EVENT_FLAG_EXIST))
                notes = "ABSENT";
            $(this).find('.NOTES').text(notes);

            $(this).removeClass('event_type_' + $(this).attr('event-type'));
            var T = e[5];
            if(T == ' ') T = '';
            $(this).attr('event-type', T);
            $(this).addClass('event_type_' + T);
        });
    };
};

function update_ui(curr)
{
///    console.log("update_ui: curr=" + JSON.stringify(curr));

    $("#clips_usage_present").text(state_text(curr, "lib_present_count"));
    $("#clips_usage_checking").text(state_text(curr, "lib_queued_count"));
    $("#clips_usage_absent").text(state_text(curr, "lib_absent_count"));

    $("#playlist_time").text(timer_format(state_text(curr, "ply_remain")));
    $("#on_air_time").text(timer_format(state_text(curr, "curr_remain")));
    $("#system_time").text(timer_format(state_text(curr, "time")));

    /* save/update status */
    var f_running = state_text(curr, "f_running");
    var f_running_style = "playlist_status_offline";
    if(f_running == '1')
        f_running_style = "playlist_status_playing";
    if(f_running == '0')
        f_running_style = "playlist_status_paused";
//    console.log("f_running_style=" + f_running_style + " f_running=" + f_running);
    if($("#playlist_status").attr("status_class") != f_running_style)
        $("#playlist_status").removeClass($("#playlist_status").attr("status_class"));
    $("#playlist_status").addClass(f_running_style);
    $("#playlist_status").attr("status_class", f_running_style);

    /* get lastest */
    var amend_prev = parseInt(state_text(last, "amend"));
    var amend_curr = parseInt(state_text(curr, "amend"));
    var count_prev = parseInt(state_text(last, "count"));
    var count_curr = parseInt(state_text(curr, "count"));

    if(isNaN(amend_prev)) amend_prev = 0;
    if(isNaN(amend_curr)) amend_curr = 0;
    if(isNaN(count_prev)) count_prev = 0;
    if(isNaN(count_curr)) count_curr = 0;

///    console.log("update_ui: amend_prev=" + amend_prev + " amend_curr=" + amend_curr + " count_prev=" + count_prev + " count_curr=" + count_curr);

    /* save status */
    last = curr;

    if(amend_prev != amend_curr)
    {
///        console.log("update_ui: amend changed");

        /* drop rows */
        $("#playlist_body").find(".playlist_item").each(function(index){
            if(index >= count_curr)
            {
                console.log("update_ui: dropping index=" + index + " count_curr=" + count_curr);
                $(this).remove();
            };
        });

        /* add new rows */
        var tr_template = $('#playlist_item_template').clone();
        for(var j = count_prev; j  < count_curr; j++)
        {
            var tr = tr_template.clone();
            tr.removeAttr('id');
            tr.attr('amend', 0);
            tr.attr('event-type', '');
            tr.appendTo('#playlist_body');
        };
    };

    var req_items = 0;
    $("#playlist_body").find(".playlist_item").each(function(index){
        if(amend_curr != $(this).attr('amend') && $(this).isOnScreen())
        {
///            console.log("update_ui: found index=" + index + "to enqueue update");
            get_event(index);
            req_items = 1;
            return false;
        }
    });

    return req_items;
};

function get_event(index)
{
///    console.log("get_event: index=" + index);

    $.getJSON
    (
        'GetEvents.php',
        {
            'bus':bus,
            'index':index,
            'count':50,
        }
    )
    .done
    (
        function(event)
        {
            update_row(index, event);
            if(!update_ui(event))
                timer = window.setTimeout(get_state, 900);
        }
    )
    .fail
    (
        function(data)
        {
            console.log("FAIL: data=" + data);
            update_ui({});
            window.setTimeout(get_state, 2000);
        }
    );

};

function get_state()
{
    timer = null;

    $.getJSON
    (
        'GetState.php',
        {
            'bus':bus,
        }
    )
    .done
    (
        function(state)
        {
            if(!update_ui(state))
                timer = window.setTimeout(get_state, 900);
        }
    )
    .fail
    (
        function(data)
        {
            console.log("FAIL: data=" + data);
            update_ui({});
            window.setTimeout(get_state, 2000);
        }
    );
};

$(document).ready(function () {
    get_state();
    $(window).scroll(function(){
///        console.log("scrollevent: timer=" + timer);
        if(timer != null)
        {
            window.clearTimeout(timer);
            timer = null;
            if(!update_ui(last))
                timer = window.setTimeout(get_state, 900);
        };
    });
});
