<?php

include_once 'lib/conf.php';
include_once 'lib/server.php';
include_once 'lib/tmpl.php';

class ui
{
    public static function frames2timecode($f)
    {
        $ff = $f % 25; $f -= $ff ; $f /= 25;
        $ss = $f % 60; $f -= $ss ; $f /= 60;
        $mm = $f % 60; $f -= $mm ; $f /= 60;
        $hh = $f % 24;
        return sprintf("%02d:%02d:%02d:%02d", $hh, $mm, $ss, $ff);
    }

    public static function sec2timecode($f)
    {
        return self::frames2timecode($f / 0.04);
    }

    public static function layout_server($xajax)
    {
        global $conf;

        $template = tmpl_new();

        $c = count($conf['channels']);

        $list = array();

        for($i = 0; $i < $c; $i++)
            array_push($list, array('id' => $i, 'width' => 100 / $c));

        $template->assign('LIST', $list);

        $template->display('layout_server.html');
    }

    public static function layout_config($xajax)
    {
        global $conf;

        $channel_id = $_REQUEST['channel_id'];

        $r = server::SettingsGet($channel_id, $r_settings);
        if($r)
            return;

        $r = server::SettingsGetModes($channel_id, $r_modes);
        if($r)
            return;
/*
        ob_start();
        var_dump($r_settings);
        error_log("settings=" . ob_get_clean());
        ob_start();
        var_dump($r_modes);
        error_log("modes=" . ob_get_clean());
*/

        $settings = array();
        $modes = array();
        $encs = array();

        /* expand r_settings */
        foreach($r_settings['list'] as $item)
            $settings[$item['name']] = $item['value'];
/*
        ob_start();
        var_dump($settings);
        error_log("settings=" . ob_get_clean());
*/

        /* expand r_modes */
        foreach($r_modes['list'] as $mode)
        {
            array_push
            (
                $modes,
                array
                (
                    'idx'       =>      $mode['idx'],
                    'name'      =>      $mode['name'],
                    'sel'       =>      ($mode['name'] == $settings['mode']),
                )
            );

            foreach($mode['list'] as $enc)
                array_push
                (
                    $encs,
                    array
                    (
                        'idx'       =>      $enc['idx'],
                        'name'      =>      $enc['name'],
                        'mode_idx'  =>      $mode['idx'],
                        'mode_name' =>      $mode['name'],
                        'sel'       =>      ($mode['name'] == $settings['mode'] && $enc['name'] == $settings['enc']),
                    )
                );
        };

        /* build template */
        $template = tmpl_new();
        $template->assign('xajax_js', $xajax->getJavascript());
        $template->assign('channel_id', $channel_id);
        $template->assign('info_ch', $conf['channels'][$channel_id]['info_ch']);
        $template->assign('settings', $settings);
        $template->assign('modes', $modes);
        $template->assign('encs', $encs);

        /* output */
        $template->display('layout_config.html');
    }

    public static function mode_to_lib($mode)
    {
        if(($mode == 'dv_pal') || ($mode == 'dv_ntsc')) return 'SD';
        return 'HD';
    }

    public static function layout_channel($xajax)
    {
        global $conf;

        $channel_id = $_REQUEST['channel_id'];

        $template = tmpl_new();

        $template->assign('xajax_js', $xajax->getJavascript());

        $template->assign('channel_id', $channel_id);
        $template->assign('info_ch', $conf['channels'][$channel_id]['info_ch']);
//        $template->assign('info_profile', $conf['channels'][$channel_id]['info_profile']);

        /* setup config var */
        $r = server::SettingsGet($channel_id, $r_settings);
        $settings = array();
        foreach($r_settings['list'] as $item)
            $settings[$item['name']] = $item['value'];
        $template->assign('settings', $settings);

        /* setup lib */
        $type = self::mode_to_lib($settings['mode']);
        $template->assign('channel_lib', $type);
        $r = self::lib_state_content($channel_id, $type, null, $lib_state, $lib_content);
        $template->assign('lib_state', $lib_state);
        $template->assign('lib_content', $lib_content);
        $template->assign('overlay_logos', self::overlay_logos($channel_id, $type));

        /* output */
        $template->display('layout_channel.html');
    }

    public static function overlay_logos($id, $lib)
    {
        global $conf;

        $list = array();
        $overlay_path = $conf['libs'][$lib]['overlay'];
        $r = server::LibListOverlays($id, $overlay_path, $result);
        error_log("overlay_logos: id=[$id], lib=[$lib], overlay_path=[$overlay_path], r=$r");
        $cnt = 0;
        if(!$r)
        {
            foreach($result['list'] as $item)
            {
                array_push
                (
                    $list,
                    array
                    (
                        'lib'       =>      $lib,
                        'path'      =>      $overlay_path,
                        'object'    =>      $item['name'],
                        'ch_id'     =>      $id,
                        'size'      =>      $item['size'],
                        'cnt'       =>      $cnt++,
                    )
                );
            };
        };

        return $list;
    }

    public static function lib_search($file, $search, &$lib_state, &$lib_content)
    {
        return stristr($file, $search);
    }

    public static function lib_state_content($id, $lib, $search, &$lib_state, &$lib_content)
    {
        global $conf;

        /* reset values */
        $lib_state = "";
        $lib_content = "";

        $lib_path = $conf['libs'][$lib]['path'];

        error_log("lib_state_content: id=[$id], lib=[$lib], lib_path=[$lib_path], search=[$search]");

        /* lib state */
        $r = server::LibState($id, $lib_info);
        if($r)
            return;
        $template_state = tmpl_new();
        $space_free = $lib_info['free_space'];
        $space_total = $lib_info['total_space'];
        $template_state->assign('free_gb', sprintf("%.2f", $space_free / (1024*1024*1024)));
        $template_state->assign('free_pr', sprintf("%d", $space_free * 100.0 / $space_total));
        $template_state->assign('free_pr2', sprintf("%d", $space_free * 112.0 / $space_total));
        $template_state->assign('count', $lib_info['total_items']);
        $template_state->assign('count4', sprintf("%04d", $lib_info['total_items']));
        $lib_state = $template_state->fetch('lib_state.html');

        /* lib content */
        $r = server::LibListItems($id, $lib_path, $lib_info);
        if($r)
            return;

///        ob_start();
///        var_dump($lib_info);
///        error_log("lib_info=" . ob_get_clean());

        /* lib content */
        $list = array();
        $template_content = tmpl_new();
        foreach ($lib_info['list'] as $item)
        {
///            ob_start();
///            var_dump($item);
///            error_log("item=" . ob_get_clean());

            if(!isset($search) || '' == $search || self::lib_search($item['name'], $search))
            {
                array_push
                (
                    $list,
                    array
                    (
                        'ch'        => $id,
                        'dur'       => self::sec2timecode($item['duration']),
                        'object'    => $item['name'],
                        'object_a'  => str_split($item['name']),
                        'lib'       => $lib,
                        'date'      => date(DATE_RFC822, $item['st_ctime']),
                        'timestamp' => $item['st_ctime'],
                    )
                );
            }
        };
        $template_content->assign('LIST', $list);
        $template_content->assign('channel_id', $id);
        $lib_content = $template_content->fetch('lib_content.html');


        return 0;
    }
}

?>
