<?php

include_once 'XML/RPC2/Client.php';
include_once 'lib/conf.php';

class server
{
    private static function create($id)
    {
        global $conf;

        $options = array
        (
            'prefix' => 'TheCoreIO.'
        );

        return XML_RPC2_Client::create($conf['channels'][$id]['url'], $options);
    }

    public static function GetStatus($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->GetStatus();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
//            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
//            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    public static function CuePlay($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->CuePlay();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    public static function PlaylistInsert($id, $idx, $name, $in, $dur, $overlay_name, $overlay_pos, $cookie, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->PlaylistInsert((int)$idx, $name, (int)$in, (int)$dur, $overlay_name, $overlay_pos, $cookie);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    public static function PlaylistAppend($id, $name, $in, $dur, $overlay_name, $overlay_pos, $cookie, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->PlaylistAppend($name, (int)$in, (int)$dur, $overlay_name, $overlay_pos, $cookie);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    public static function CueRecord($id, $obj, $cookie, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->CueRecord($obj, $cookie);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    public static function LibDeleteItem($id, $obj, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->LibDeleteItem($obj);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function LibState($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->LibState();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function LibListItems($id, $path, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->LibListItems($path);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function Info($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->Info();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function Play($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->Play();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function Stop($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->Stop();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function Record($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->Record();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function Pause($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->Pause();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function PlaylistLoop($id, $dir, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->PlaylistLoop((int)$dir);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function PlaylistSeek($id, $tc, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->PlaylistSeek((int)$tc);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function LibThumbItem($id, $item, $scale_type, $scale_width, $scale_height, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->LibThumbItem($item, $scale_type, (int)$scale_width, (int)$scale_height);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function LibThumbOverlay($id, $object, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->LibThumbOverlay($object);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function LibListOverlays($id, $path, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->LibListOverlays2($path);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function SettingsGet($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->SettingsGet();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function SettingsGetModes($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->SettingsGetModes();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function SettingsSave($id, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->SettingsSave();
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function SettingsSetMode($id, $mode_idx, $enc_idx, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->SettingsSetMode((int)$mode_idx, (int)$enc_idx);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

    function SettingsSetValue($id, $name, $val, &$result)
    {
        $client = self::create($id);

        try
        {
            $result = $client->SettingsSetValue($name, $val);
            return 0;
        }
        catch (XML_RPC2_FaultException $e)
        {
            error_log('Exception #' . $e->getFaultCode() . ' : ' . $e->getFaultString());
            return -1;
        }
        catch (Exception $e)
        {
            error_log('Exception : ' . $e->getMessage());
            return -2;
        }
    }

};

?>
