<?php

include_once 'lib/ui.php';

function update_lib($id, $lib, $search)
{
    ui::lib_state_content($id, $lib, $search, $lib_state, $lib_content);
    $response = new xajaxResponse();
    $response->assign('lib_state', 'innerHTML', $lib_state);
    $response->assign('lib_content', 'innerHTML', $lib_content);
    $response->call('init_buttons');
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'update_lib');

function ctl_cue_play($id, $lib_id, $obj, $overlay_file, $overlay_pos)
{
    global $conf;

    $item = $conf['libs'][$lib_id]['path'] . '/' . $obj;
    error_log("ctl_cue_play: item=[$item], lib_id=[$lib_id], obj=[$obj], overlay_file=[$overlay_file], overlay_pos=[$overlay_pos]");

    if('none' == $overlay_file)
        $overlay_file = '';

    server::CuePlay($id, $result);
    server::Pause($id, $result);
    server::PlaylistAppend($id, $item, 0, 0, $overlay_file, $overlay_pos, $lib_id . ':' . $obj, $result);

    $response = new xajaxResponse();
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'ctl_cue_play');

function ctl_cue_record($id, $lib_id, $obj)
{
    global $conf;
    $result = "";

    $item = $conf['libs'][$lib_id]['path'] . '/' . $obj;

    error_log("ctl_cue_record: item=[$item], lib_id=[$lib_id], obj=[$obj]");

    server::CueRecord($id, $item, $lib_id . ':' . $obj, $result);
    $response = new xajaxResponse();
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'ctl_cue_record');

function ctl_play($id)
{
    server::Play($id, $result);
    $response = new xajaxResponse();
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'ctl_play');

function ctl_record($id)
{
    server::Record($id, $result);
    $response = new xajaxResponse();
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'ctl_record');

function ctl_stop($id)
{
    server::Stop($id, $result);

    $response = new xajaxResponse();
    $response->call('refresh_lib');
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'ctl_stop');

function ctl_pause($id)
{
    server::Pause($id, $result);
    $response = new xajaxResponse();
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'ctl_pause');

function ctl_seek_begin($id)
{
    server::PlaylistSeek($id, 0, $result);
    $response = new xajaxResponse();
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'ctl_seek_begin');

function ctl_loop($id, $dir)
{
    server::PlaylistLoop($id, $dir, $result);
    $response = new xajaxResponse();
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'ctl_loop');

function delete_lib_item($id, $lib_id, $obj)
{
    global $conf;

    $item = $conf['libs'][$lib_id]['path'] . '/' . $obj;

    error_log("delete_lib_item: item=[$item], lib_id=[$lib_id], obj=[$obj]");

    server::LibDeleteItem($id, $item, $result);

    $response = new xajaxResponse();
    $response->call('refresh_lib');
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'delete_lib_item');

function config_save($id, $settings)
{
    error_log("config_save: mode=[".$settings['mode']."], enc=[".$settings['enc']."]" );
//    error_log("config_save: playback_consumer_buffer=[" . $settings['playback_consumer_buffer'] . "]");
//    error_log("config_save: playback_consumer_prefill=[" . $settings['playback_consumer_prefill'] . "]");
//    error_log("config_save: mode_idx=[" . $settings['mode_idx'] . "]");
//    error_log("config_save: enc_idx=[" . $settings['enc_idx'] . "]");
    server::SettingsSetValue($id, 'playback_consumer_buffer', $settings['playback_consumer_buffer'], $result);
    server::SettingsSetValue($id, 'playback_consumer_prefill', $settings['playback_consumer_prefill'], $result);
    server::SettingsSetMode($id, $settings['mode_idx'], $settings['enc_idx'], $result);
    server::SettingsSave($id, $result);

    $response = new xajaxResponse();
    $response->call('config_save_done');
    return $response;
};
$xajax->register(XAJAX_FUNCTION, 'config_save');
