var bus = 0;
var f_online = 0;
var last;
var timer = null;

var REQUEST_PENDING     = 0;
var REQUEST_STARTED     = 1;
var REQUEST_DONE        = 2;
var REQUEST_ERROR       = 3;
var REQUEST_CANCEL      = 4;
var REQUEST_ANY         = 5;
var ITEMS_STATE = ['PENDING', 'STARTED', 'DONE', 'ERROR', 'CANCEL'];

function dur2tc(D)
{
//    console.log("dur2tc: D=[" + D + "]");

    var t = parseFloat(D);
    if(isNaN(t)) return "";

//    console.log("dur2tc: t=[" + t + "]");

    var f = parseInt(t / 0.04);
    if(isNaN(f)) return "";

//    console.log("dur2tc: f=[" + f + "]");

    var ff = f % 25; f -= ff; f /= 25;
    var ss = f % 60; f -= ss; f /= 60;
    var mm = f % 60; f -= mm; f /= 60;
    var hh = f;

    var tc =
        ('0' + hh).slice(-2) + ':' +
        ('0' + mm).slice(-2) + ':' +
        ('0' + ss).slice(-2) + ':' +
        ('0' + ff).slice(-2);

//    console.log("dur2tc: tc=[" + tc + "]");

    return tc;
};

function time_build(epoch_sec)
{
//    return tc;

    var
        d = new Date(0);

    d.setUTCSeconds(epoch_sec);

    if(d.toLocaleFormat !== undefined)
        return d.toLocaleFormat('%Y-%b-%d %H:%M:%S');
    else
        return ("000" + d.getFullYear()).slice(-4) + '-' + ('0' + (1 + d.getMonth())).slice(-2) + '-' + ('0' + d.getDate()).slice(-2) + ' ' + ('0' + d.getHours()).slice(-2) + ':' + ('0' + d.getMinutes()).slice(-2) + ':' + ('0' + d.getSeconds()).slice(-2);
};

// http://upshots.org/javascript/jquery-test-if-element-is-in-viewport-visible-on-screen
$.fn.isOnScreen = function()
{
    var viewport = {};
    viewport.top = $(window).scrollTop();
    viewport.bottom = viewport.top + $(window).height();
    var bounds = {};
    bounds.top = this.offset().top;
    bounds.bottom = bounds.top + this.outerHeight();
    return ((bounds.top <= viewport.bottom) && (bounds.bottom >= viewport.top));
};

function state_text(obj, name)
{
    if(obj === undefined)
        return "";

    if(obj[name] === undefined)
        return "";

    return obj[name];
};

function collaps_path(path)
{
    console.log("collaps_path: path=[" + path + "]");

    $("#libtree_body").find('.libtree_item[parent-path="' + path + '"]').each(function(index){
        $(this).remove();
    });

    $("#libtree_body").find('.libtree_dir[root-path="' + path + '"]').each(function(index){
        $(this).attr('expanded', '0');
        $(this).removeClass('dir_expanded');
        $(this).addClass('dir_collapsed');
        $(this).find('.FOLDER').removeClass('FOLDER_OPEN');
        $(this).find('.FOLDER').addClass('FOLDER_CLOSED');
    });
};

function ld_meta()
{
    var item = $("#libtree_body").find('.libtree_file[meta-pending=1]').first();
    var path = item.attr('root-path');

    if(path !== undefined)
    {
//        console.log("LibMetaItem.php: path=[" + path + "] item=[" + item + "]");

        item.attr('meta-pending', '0');

        $.getJSON
        (
            'LibMetaItem.php',
            {
                'path':path,
            }
        )
        .done
        (
            function(resp)
            {
//                console.log("LibMetaItem.php: resp=" + JSON.stringify(resp));
                if(resp['result'] >= 0)
                {
                    var meta = resp['item'];
                    item.find('.FRAME').text(meta['width'] + 'x' + meta['height']);
                    item.find('.DUR').text(dur2tc(meta['duration']));
                    item.find('.DATE').text(time_build(meta['st_mtime']));
                    item.find('.AUDIO').text(meta['channels']);
                }
                else
                    console.log("LibMetaItem.php: ERROR resp=" + JSON.stringify(resp));

                ld_meta();
            }
        )
        .fail
        (
            function(data)
            {
                console.log("LibMetaItem.php: FAIL: data=" + data);
            }
        );
    };
//    else
//        ld_thumb();
};

function ld_thumb()
{
    var item = $("#libtree_body").find('.libtree_file[thumb-pending=1]').first();
    var path = item.attr('root-path');

    if(path !== undefined)
    {
//        console.log("LibThumbItem.php: path=[" + path + "] item=[" + item + "]");

        item.attr('thumb-pending', '0');

        $.getJSON
        (
            'LibThumbItem.php',
            {
                'path':path,
                'scale_type':'c',
                'scale_width':64,
                'scale_height':64
            }
        )
        .done
        (
            function(resp)
            {
//                console.log("LibThumbItem.php: resp=" + JSON.stringify(resp));

                if(resp['result'] >= 0)
                {
                    item.find('.THUMB').each(function(index){
                        var thumb = $(this);
//                        console.log("Thumb setting");
                        thumb.attr('src', 'data:image/jpg;base64,' + resp['thumb']);
                    });

                }
                else
                    console.log("LibThumbItem.php: ERROR resp=" + JSON.stringify(resp));

                ld_thumb();
            }
        )
        .fail
        (
            function(data)
            {
                console.log("LibThumbItem.php: FAIL: data=" + data);
            }
        );
    };
};

function expand_path(path)
{
    $("#libtree_body").find('.libtree_dir[root-path="' + path + '"]').each(function(index){
        var pr = $(this);
        $.getJSON
        (
            'LibListDirs.php',
            {
                'path':path,
            }
        )
        .done
        (
            function(resp)
            {
//                console.log("LibListDirs.php: resp=" + JSON.stringify(resp));

                if(resp['result'] >= 0)
                {
                    var last = pr;
                    var level = pr.attr('level');
                    pr.attr('expanded', '1');
                    pr.removeClass('dir_collapsed');
                    pr.addClass('dir_expanded');

                    pr.find('.FOLDER').removeClass('FOLDER_CLOSED');
                    pr.find('.FOLDER').addClass('FOLDER_OPEN');

                    var i, list;

                    list = resp['list'];
                    list.sort(function(a, b)
                    {
                        var a_v = ('' + a['name']).toUpperCase(), b_v = ('' + b['name']).toUpperCase();
                        var r = (a_v > b_v)?1:((a_v < b_v)?-1:0);
//                        console.log("LibListDirs.php: r=[" + r + "] a=[" + a_v + '] b=[' + b_v + ']');
                        return r;
                    });

                    for(i = 0; i < list.length; i++)
                    {
//                        console.log("LibListDirs.php: item=" + list[i]['name']);

                        var dir = $('#libtree_dir_template').clone();
                        var p = ((path == '/')?'':path) + '/' + list[i]['name'];
                        dir.removeAttr('id');
                        dir.attr('level', 1 + parseInt(level));
                        dir.attr('parent-path', path);
                        dir.attr('root-path', p);
                        dir.attr('item', list[i]['name']);
                        dir.find('.NAME').text(list[i]['name']);
                        dir.find('.FOLDER').css( "padding-left", (20 * level) +  "px");
                        dir.find('.FOLDER').removeClass('FOLDER_OPEN');
                        dir.find('.FOLDER').addClass('FOLDER_CLOSED');
                        dir.find('.FOLDER').attr('root-path', p);

                        last.after(dir);
                        last = dir;
                    };

//
                    $.getJSON
                    (
                        'LibListFiles.php',
                        {
                            'path':path,
                        }
                    )
                    .done
                    (
                        function(resp)
                        {
//                            console.log("LibListFiles.php: resp=" + JSON.stringify(resp));

                            if(resp['result'] >= 0)
                            {
                                list = resp['list'];
                                list.sort(function(a, b)
                                {
                                    var a_v = ('' + a['name']).toUpperCase(), b_v = ('' + b['name']).toUpperCase();
                                    var r = (a_v > b_v)?1:((a_v < b_v)?-1:0);
//                                      console.log("LibListDirs.php: r=[" + r + "] a=[" + a_v + '] b=[' + b_v + ']');
                                    return r;
                                });

                                for(i = 0; i < list.length; i++)
                                {
//                                    console.log("LibListFiles.php: item=" + list[i]['name']);

                                    var file = $('#libtree_file_template').clone();
                                    file.removeAttr('id');
                                    file.attr('level', 1 + parseInt(level));
                                    file.attr('meta-pending', '1');
                                    file.attr('thumb-pending', '1');
                                    file.attr('parent-path', path);
                                    file.attr('root-path', path + '/' + list[i]['name']);
                                    file.attr('item', list[i]['name']);
                                    file.find('.NAME').text(list[i]['name']);
                                    file.find('.THUMB').css( "padding-left", (20 * level) +  "px");

//                                    file.find('.THUMB').each(function(index){
//                                        var thumb = $(this);
//                                        console.log("Thumb setting");
//                                        thumb.attr('dst', 'LibThumbItem.php?scale_type=c&scale_width=128&scale_height=128&path='
//                                        + encodeURIComponent(path + list[i]['name']));
//                                        thumb.attr('width', 128);
//                                        thumb.attr('height', 128);
//                                    });

                                    last.after(file);
                                    last = file;
                                };

                                ld_meta();
                                ld_thumb();
                            }
                            else
                                console.log("LibListFiles.php: ERROR resp=" + JSON.stringify(resp));
                        }
                    )
                    .fail
                    (
                        function(data)
                        {
                            console.log("FAIL: data=" + data);
                        }
                    );
//

                }
                else
                    console.log("LibListDirs.php: ERROR resp=" + JSON.stringify(resp));
            }
        )
        .fail
        (
            function(data)
            {
                console.log("FAIL: data=" + data);
            }
        );
    });
};

function menu_select(idx)
{
    if(idx == 0)
    modal_dialog_window_open
    ({
        'proc': filetransfer_dialog_proc,
        'cookie': null,
        'wnd_class': 'filetransfer_dialog_wnd',
        'mask_class': 'filetransfer_dialog_mask',
    });
};

function unselect_all()
{
    $('body').find('tr._SELECTED').each(function(index){
        $(this).removeClass('_SELECTED');
        $(this).find('td._SELECT input').each(function(index){
            $(this).prop("checked", false);
        });
    });
};

function filetransfer_dialog_proc(parent, conf, cookie)
{
    var dlg = $('body').find('div.template div.thecorefiletransfer').clone();

    parent.append(dlg);

    /* destination */
    dlg.find('select.destination').find('option').each(function(index) {
        $(this).remove();
    });
    $.getJSON
    (
        'TheCoreFileTransfer.TargetsList.php',
        {
            'offset' : 0,
            'limit' : 100
        }
    )
    .done
    (
        function(curr)
        {
            for(var i = 0; i < curr['list'].length; i++)
            {
                var o = $("<option/>",
                {
                    'value': curr['list'][i]['id'],
                    'text': curr['list'][i]['id']
                });
                dlg.find('select.destination').append(o);
            };
        }
    );


    dlg.find('select.sources').find('option').each(function(index) {
        $(this).remove();
    });
    $('body').find('tr._SELECTED').each(function(index) {

        if($(this).hasClass('libtree_dir'))
        {
            var root_path = $(this).attr('root-path');

            /* find a rows that belong to that dir */
            $('body').find('tr.libtree_item').each(function(index) {
                var parent_path = $(this).attr('parent-path');
                if(parent_path == root_path)
                    dlg.find('select.sources').append
                    (
                        $("<option/>",
                        {
                            'text': $(this).attr('item'),
                            'value': $(this).attr('root-path')
                        })
                    );
            });

            console.log("DIR SELECTED");
        }
        else if($(this).hasClass('libtree_item'))
        {
            var o = $("<option/>",
            {
                'text': $(this).attr('item'),
                'value': $(this).attr('root-path')
            });
            dlg.find('select.sources').append(o);
        };
    });

    function add_request(idx, list)
    {
        console.log("add_request: " + idx);
        if(idx == list.length)
        {
            /* unselect */
            unselect_all();

            /* close window */
            modal_dialog_window_close(conf);
        }
        else
        {
            $.getJSON('TheCoreFileTransfer.RequestAdd.php', list[idx])
            .done
            (
                function(curr)
                {
                    add_request(idx + 1, list);
                }
            );
        };
    };

    dlg.delegate("div.buttons button.OK", "click", function() {
        var o = dlg.find('select.destination').find("option:selected").first();
        if(o != null)
        {
            var list = [];
            console.log("dest: " + o.val());

            dlg.find('select.sources').find('option').each(function(index) {
                list.push
                ({
                    'target'            : o.val(),
                    'f_import'          : 0,
                    'f_delete'          : dlg.find('input.f_delete').first().prop("checked") ? 1 : 0,
                    'local_object'      : $(this).val(),
                    'remote_object'     : $(this).text()
                });
            });

            add_request(0, list);
        };
    });

    dlg.delegate("div.buttons button.Cancel", "click", function() {
        modal_dialog_window_close(conf);
    });
};

$(document).ready(function () {
//    $('.FOLDER').on("click", function() {

    $("body").delegate(".FOLDER", "click", function() {
        var path = $(this).attr('root-path');

        console.log("PATH=" + path);

        if($(this).hasClass('FOLDER_CLOSED'))
            expand_path(path);
        else
            collaps_path(path);
    });

    $("body").delegate("td._SELECT input", "change", function() {
        var tr = $(this).parents('tr').first();

        if($(this).prop("checked"))
        {
            tr.addClass("_SELECTED");
            if(tr.hasClass('libtree_dir') && tr.attr('expanded') != '1')
                expand_path(tr.attr('root-path'));
        }
        else
            tr.removeClass("_SELECTED");

        console.log("HERE:" + $(this).prop("checked"));
    });

    $("body").find(".menu_selector").ddm_attach
        ({
            'position_fixed' : 'defined',
            'geom': 'foo',
            'class': 'menu_list',
            'items':
            [
                {
                    'text' : 'TheCoreFileTransfer',
                    'cookie': {},
                    'class': 'menu_list_item',
                },
            ],
            'cookie': {},
            'cb': function(idx, a, c) { menu_select(idx); }
        });


    expand_path("/");

});
