var bus = 0;
var f_online = 0;
var last;
var timer = null;

var REQUEST_PENDING     = 0;
var REQUEST_STARTED     = 1;
var REQUEST_DONE        = 2;
var REQUEST_ERROR       = 3;
var REQUEST_CANCEL      = 4;
var REQUEST_ANY         = 5;
var ITEMS_STATE = ['PENDING', 'STARTED', 'DONE', 'ERROR', 'CANCEL'];

function time_build(epoch_sec)
{
//    return tc;

    var
        d = new Date(0);

    d.setUTCSeconds(epoch_sec);

    if(d.toLocaleFormat !== undefined)
        return d.toLocaleFormat('%Y-%b-%d %H:%M:%S');
    else
        return ("000" + d.getFullYear()).slice(-4) + '-' + ('0' + (1 + d.getMonth())).slice(-2) + '-' + ('0' + d.getDate()).slice(-2) + ' ' + ('0' + d.getHours()).slice(-2) + ':' + ('0' + d.getMinutes()).slice(-2) + ':' + ('0' + d.getSeconds()).slice(-2);
};

// http://upshots.org/javascript/jquery-test-if-element-is-in-viewport-visible-on-screen
$.fn.isOnScreen = function()
{
    var viewport = {};
    viewport.top = $(window).scrollTop();
    viewport.bottom = viewport.top + $(window).height();
    var bounds = {};
    bounds.top = this.offset().top;
    bounds.bottom = bounds.top + this.outerHeight();
    return ((bounds.top <= viewport.bottom) && (bounds.bottom >= viewport.top));
};

function state_text(obj, name)
{
    if(obj === undefined)
        return "";

    if(obj[name] === undefined)
        return "";

    return obj[name];
};

function update_row(index_top, resp)
{
    console.log("update_row: index_top=" + index_top + " event=" + JSON.stringify(resp));

    var j, items = resp['list'];

    for(j = 0; j < items.length; j++)
    {
        var item = items[j];
        var index = j + index_top;

        $("#itemslist_body").find(".itemslist_item").eq(index).each(function(){

            console.log("update_row: updating index=" + index + " item=" + JSON.stringify(item));

            $(this).attr('amend', last['amend']);
            $(this).find('.ID').text(item['id']);

            $(this).find('.STATE').each(function()
            {
                for(var i = 0; i < ITEMS_STATE.length; i++)
                    $(this).removeClass(ITEMS_STATE[i]);
                $(this).addClass(ITEMS_STATE[item['state']]);
            });

            $(this).find('.DIRECTION').each(function()
            {
                $(this).removeClass('f_import_0__f_delete_0');
                $(this).removeClass('f_import_0__f_delete_1');
                $(this).removeClass('f_import_1__f_delete_0');
                $(this).removeClass('f_import_1__f_delete_1');
                $(this).addClass('f_import_' + item['f_import'] + '__f_delete_' + item['f_delete']);
            });

            $(this).find('.TARGET').text(item['target']);
            $(this).find('.LOCAL').text(item['object_local']);
            $(this).find('.REMOTE').text(item['object_remote']);
            $(this).find('.UPDATED').text(time_build(item['updated']));
            $(this).find('.CREATED').text(time_build(item['created']));

            if(item['state'] == REQUEST_STARTED)
                $(this).find('.COMMENT').text("PROCESSING: " + item['progress'] + "%");
            else
                $(this).find('.COMMENT').text(item['error']);

            $(this).removeClass('item_state_' + $(this).attr('item-state'));
            $(this).attr('item-state', + item['state']);
            $(this).addClass('item_state_' + item['state']);

        });
    };
};

function update_ui(curr)
{
    console.log("update_ui: curr=" + JSON.stringify(curr));

    /* get lastest */
    var amend_prev = parseInt(state_text(last, "amend"));
    var amend_curr = parseInt(state_text(curr, "amend"));
    var count_prev = parseInt(state_text(last, "count"));
    var count_curr = parseInt(state_text(curr, "count"));

    /* save/update status */
    var service_status;
    if(isNaN(amend_curr) || isNaN(count_curr))
        service_status = "service_status_offline";
    else
        service_status = "service_status_online";
    if($("#service_status").attr("status_class") != service_status)
        $("#service_status").removeClass($("#service_status").attr("status_class"));
    $("#service_status").addClass(service_status);
    $("#service_status").attr("status_class", service_status);

    console.log("update_ui: amend_prev=[" + amend_prev + "] amend_curr=[" + amend_curr + "] count_prev=[" + count_prev + "] count_curr=[" + count_curr + "]");

    if(isNaN(amend_prev)) amend_prev = -1;
    if(isNaN(amend_curr)) amend_curr = -1;
    if(isNaN(count_prev)) count_prev = 0;
    if(isNaN(count_curr)) count_curr = 0;

    console.log("update_ui: amend_prev=" + amend_prev + " amend_curr=" + amend_curr + " count_prev=" + count_prev + " count_curr=" + count_curr);

    /* save status */
    last = curr;

    if(amend_prev != amend_curr)
    {
        console.log("update_ui: amend changed");

        /* drop rows */
        $("#itemslist_body").find(".itemslist_item").each(function(index){
            if(index >= count_curr)
            {
                console.log("update_ui: dropping index=" + index + " count_curr=" + count_curr);
                $(this).remove();
            };
        });

        /* add new rows */
        var tr_template = $('#itemslist_item_template').clone();
        for(var j = count_prev; j  < count_curr; j++)
        {
            console.log("update_ui: adding row");
            var tr = tr_template.clone();
            tr.removeAttr('id');
            tr.attr('amend', -1);
            tr.attr('event-type', '');
            tr.appendTo('#itemslist_body');
        };
    };

    var req_items = 0;
    $("#itemslist_body").find(".itemslist_item").each(function(index){
        if(amend_curr != $(this).attr('amend') && $(this).isOnScreen())
        {
///            console.log("update_ui: found index=" + index + "to enqueue update");
            get_event(index);
            req_items = 1;
            return false;
        }
    });

    return req_items;
};

function get_event(index)
{
    console.log("get_event: index=" + index);

    $.getJSON
    (
        'RequestsList.php',
        {
            'index':index,
            'count':50,
        }
    )
    .done
    (
        function(event)
        {
            update_row(index, event);
            get_state();
        }
    )
    .fail
    (
        function(data)
        {
            console.log("FAIL: data=" + data);
            update_ui({});
            window.setTimeout(get_state, 2000);
        }
    );
};

function get_state()
{
    timer = null;

    $.getJSON
    (
        'GetState.php'
    )
    .done
    (
        function(state)
        {
            if(!update_ui(state))
                timer = window.setTimeout(get_state, 900);
        }
    )
    .fail
    (
        function(data)
        {
            console.log("FAIL: data=" + data);
            update_ui({});
            window.setTimeout(get_state, 2000);
        }
    );
};

$(document).ready(function () {
    get_state();
    $(window).scroll(function(){
///        console.log("scrollevent: timer=" + timer);
        if(timer != null)
        {
            window.clearTimeout(timer);
            timer = null;
            if(!update_ui(last))
                timer = window.setTimeout(get_state, 900);
        };
    });

    $("body").delegate(".OPER", "click", function()
    {
        var m = "";

        if($(this).hasClass('OPER_DELETE'))
            m = 'RequestDel';
        else if($(this).hasClass('OPER_CANCEL'))
            m = 'RequestCancel';
        else if($(this).hasClass('OPER_RESTART'))
            m = 'RequestRestart';
        else if($(this).hasClass('OPER_CLEAR'))
        {
            if(confirm("Are you sure to cleanup requests?"))
                $.getJSON('TheCoreFileTransfer.RequestsClear.php', {})
                    .done(function(curr)
                    {
                    });
            return;
        }
        else
            return;

        var id = $(this).parents('tr').find('td.ID').text();
        console.log("id=" + id);

        $.getJSON('TheCoreFileTransfer.' + m + '.php', {'id' : id })
            .done(function(curr)
            {
            });
    });
});
