<?php

include_once 'conf.php';

$client = XML_RPC2_Client::create(URL, array('prefix' => 'TheCoreLib.'));

try
{
    $r = $client->LibThumbItem($_REQUEST['path'], $_REQUEST['scale_type'], (int)$_REQUEST['scale_width'], (int)$_REQUEST['scale_height']);
}
catch (XML_RPC2_FaultException $e)
{
    $r = array
    (
        'faultString'     => $e->getFaultString(),
        'faultCode'     => $e->getFaultCode(),
        'result' => '-1000'
    );
}
catch (Exception $e)
{
    $r = array
    (
        'faultMessage'     => $e->getMessage(),
        'result' => '-1000'
    );
}

//header("Content-type: image/jpg");
//echo $r['thumb']->scalar;

header("Content-type: text/x-json");
if($r['result'] >= 0)
    $r['thumb'] = base64_encode($r['thumb']->scalar);

echo json_encode($r);
