#!/usr/bin/perl

use strict;
#use vars (@ARGV);
use HTML::Template;
use Data::Dump qw(dump);
use Frontier::Client;
use Getopt::Long;

# NIVEA_SOARES_EM_TUA_PRESENCA_Nívea.mp4
# Barak_Te_Quiero_Adorar_Live_DVD_Generación_Sedienta.mp4

my @SHM = ();

my $tmpl_main_txt = <<EOT;
<?xml version="1.0" ?>
<mlt>

    <producer id="clip" in="<TMPL_VAR NAME="CLIP_IN" ESCAPE="HTML">" out="<TMPL_VAR NAME="CLIP_OUT" ESCAPE="HTML">">
        <property name="resource"><TMPL_VAR NAME="resource" ESCAPE="HTML"></property>
        <property name="audio_index">all</property>
<TMPL_IF force_progressive>
        <property name="progressive">0</property>
        <property name="force_progressive">0</property></TMPL_IF>
<TMPL_IF force_aspect_ratio>
        <property name="force_aspect_ratio"><TMPL_VAR NAME="force_aspect_ratio" ESCAPE="HTML"></property></TMPL_IF>

<TMPL_IF audiomap_enable>
        <filter mlt_service="audiomap">
            <property name="0"><TMPL_VAR NAME="audiomap_0"></property>
            <property name="1"><TMPL_VAR NAME="audiomap_1"></property>
            <property name="2"><TMPL_VAR NAME="audiomap_2"></property>
            <property name="3"><TMPL_VAR NAME="audiomap_3"></property>
            <property name="4"><TMPL_VAR NAME="audiomap_4"></property>
            <property name="5"><TMPL_VAR NAME="audiomap_5"></property>
            <property name="6"><TMPL_VAR NAME="audiomap_6"></property>
            <property name="7"><TMPL_VAR NAME="audiomap_7"></property>
        </filter></TMPL_IF>

        <filter mlt_service="audiochannels"></filter>

<TMPL_IF audioamp_volume>
        <filter mlt_service="volume">
            <property name="gain"><TMPL_VAR NAME="audioamp_volume"></property>
            <property name="end">0</property>
        </filter></TMPL_IF>

    </producer>

<TMPL_LOOP NAME="LIST">

<TMPL_IF MATTE>
    <producer id="producer<TMPL_VAR NAME="IDX">f">
        <property name="force_progressive">1</property>
<TMPL_LOOP PRODUCER_PROPERTIES>
        <property name="<TMPL_VAR NAME="NAME">"><TMPL_VAR NAME="VALUE" ESCAPE="HTML"></property></TMPL_LOOP>
    </producer>

<TMPL_IF LOOPED>
    <playlist id="producer<TMPL_VAR NAME="IDX">f_looped" force_loop="1">
        <entry producer="producer<TMPL_VAR NAME="IDX">f" <TMPL_IF LOOPED_IN>in="<TMPL_VAR NAME="LOOPED_IN">"</TMPL_IF> <TMPL_IF LOOPED_OUT>out="<TMPL_VAR NAME="LOOPED_OUT">"</TMPL_IF> />
    </playlist></TMPL_IF>

    <playlist id="playlist<TMPL_VAR NAME="IDX">f">
<TMPL_IF BLANK_IN>        <blank length="<TMPL_VAR NAME="BLANK_IN">"/></TMPL_IF>
<TMPL_LOOP ENTRIES>
        <entry producer="producer<TMPL_VAR NAME="IDX">f<TMPL_IF LOOPED>_looped</TMPL_IF>" in="<TMPL_VAR NAME="IN">" out="<TMPL_VAR NAME="OUT">"/></TMPL_LOOP>
<TMPL_IF BLANK_OUT2>        <blank length="<TMPL_VAR NAME="BLANK_OUT2">"/></TMPL_IF>
<TMPL_IF BLANK_OUT>        <blank length="<TMPL_VAR NAME="BLANK_OUT">"/></TMPL_IF>
    </playlist>


    <producer id="producer<TMPL_VAR NAME="IDX">k">
        <property name="force_progressive">1</property>
<TMPL_LOOP PRODUCER_MATTE_PROPERTIES>
        <property name="<TMPL_VAR NAME="NAME">"><TMPL_VAR NAME="VALUE" ESCAPE="HTML"></property></TMPL_LOOP>
    </producer>

<TMPL_IF LOOPED>
    <playlist id="producer<TMPL_VAR NAME="IDX">k_looped" force_loop="1">
        <entry producer="producer<TMPL_VAR NAME="IDX">k" <TMPL_IF LOOPED_IN>in="<TMPL_VAR NAME="LOOPED_IN">"</TMPL_IF> <TMPL_IF LOOPED_OUT>out="<TMPL_VAR NAME="LOOPED_OUT">"</TMPL_IF> />
    </playlist></TMPL_IF>

    <playlist id="playlist<TMPL_VAR NAME="IDX">k">
<TMPL_IF BLANK_IN>        <blank length="<TMPL_VAR NAME="BLANK_IN">"/></TMPL_IF>
<TMPL_LOOP ENTRIES>
        <entry producer="producer<TMPL_VAR NAME="IDX">k<TMPL_IF LOOPED>_looped</TMPL_IF>" in="<TMPL_VAR NAME="IN">" out="<TMPL_VAR NAME="OUT">"/></TMPL_LOOP>
<TMPL_IF BLANK_OUT2>        <blank length="<TMPL_VAR NAME="BLANK_OUT2">"/></TMPL_IF>
<TMPL_IF BLANK_OUT>        <blank length="<TMPL_VAR NAME="BLANK_OUT">"/></TMPL_IF>
    </playlist>


    <tractor id="playlist<TMPL_VAR NAME="IDX">">
        <multitrack>
            <track producer="playlist<TMPL_VAR NAME="IDX">f"/>
            <track producer="playlist<TMPL_VAR NAME="IDX">k"/>
        </multitrack>
        <transition in="<TMPL_VAR NAME="TRANSITION_IN">" out="<TMPL_VAR NAME="TRANSITION_OUT">">
            <property name="mlt_service">matte</property>
            <property name="a_track">0</property>
            <property name="b_track">1</property>
        </transition>
    </tractor>

<TMPL_ELSE>

    <producer id="producer<TMPL_VAR NAME="IDX">">
<TMPL_LOOP PRODUCER_PROPERTIES>
        <property name="<TMPL_VAR NAME="NAME">"><TMPL_VAR NAME="VALUE" ESCAPE="HTML"></property></TMPL_LOOP>
    </producer>

<TMPL_IF LOOPED>
    <playlist id="producer<TMPL_VAR NAME="IDX">_looped" force_loop="1">
        <entry producer="producer<TMPL_VAR NAME="IDX">" <TMPL_IF LOOPED_IN>in="<TMPL_VAR NAME="LOOPED_IN">"</TMPL_IF> <TMPL_IF LOOPED_OUT>out="<TMPL_VAR NAME="LOOPED_OUT">"</TMPL_IF> />
    </playlist></TMPL_IF>

    <playlist id="playlist<TMPL_VAR NAME="IDX">">
<TMPL_IF BLANK_IN>        <blank length="<TMPL_VAR NAME="BLANK_IN">"/></TMPL_IF>
<TMPL_LOOP ENTRIES>
        <entry producer="producer<TMPL_VAR NAME="IDX"><TMPL_IF LOOPED>_looped</TMPL_IF>" in="<TMPL_VAR NAME="IN">" out="<TMPL_VAR NAME="OUT">"/></TMPL_LOOP>
<TMPL_IF BLANK_OUT2>        <blank length="<TMPL_VAR NAME="BLANK_OUT2">"/></TMPL_IF>
<TMPL_IF BLANK_OUT>        <blank length="<TMPL_VAR NAME="BLANK_OUT">"/></TMPL_IF>
    </playlist>
</TMPL_IF>

    <tractor id="tractor<TMPL_VAR NAME="IDX">">
        <multitrack>
<TMPL_IF PREV_IDX_SET>
            <track producer="tractor<TMPL_VAR NAME="PREV_IDX">"/><TMPL_ELSE>
            <track producer="clip"/></TMPL_IF>
            <track producer="playlist<TMPL_VAR NAME="IDX">"/>
        </multitrack>
        <transition in="<TMPL_VAR NAME="TRANSITION_IN">" out="<TMPL_VAR NAME="TRANSITION_OUT">">
<TMPL_LOOP TRANSITION_PROPERTIES>
            <property name="<TMPL_VAR NAME="NAME">"><TMPL_VAR NAME="VALUE" ESCAPE="HTML"></property></TMPL_LOOP>
            <property name="mlt_service">composite</property>
            <property name="a_track">0</property>
            <property name="b_track">1</property>
            <property name="nofit">1</property>
            <property name="sliced_composite">1</property>
        </transition>
    </tractor>

</TMPL_LOOP>

</mlt>
<TMPL_LOOP SHM><!-- cache_shm_id=<TMPL_VAR NAME="cache_shm_id"> <TMPL_VAR NAME="value"> -->
</TMPL_LOOP>
EOT

$Frontier::RPC2::scalars{'i8'} = 1;

sub get_lib_item
{
    my %item;
    my ($r, $srv);
    my ($lib, $name, $fps) = @_;

    $srv =  Frontier::Client->new('url' => 'http://' . $lib . '/RPC2');

    $r = $srv->call("TheCoreLib.LibBasenameItem", $name);
    return undef unless $r;
    return undef unless !$r->{result};

    push(@SHM, { 'cache_shm_id' => $r->{'cache_shm_id'}, 'value' => $r->{'value'} });

    $item{'object'} = $r->{'object'};
    $item{'abs'} = $r->{'value'};

    $r = $srv->call("TheCoreLib.LibMetaItem", $item{'object'});

    return undef unless $r;
    return undef unless !$r->{result};

    $r->{'item'}->{'duration_v'} = 86400.0
        if(defined($r->{'item'}->{'duration_v'}) && !int($r->{'item'}->{'duration_v'}));
    $item{'duration'} = int($r->{'item'}->{'duration_v'} * $fps->[0] / $fps->[1]);

    $item{'display_aspect_ratio'} = $r->{'item'}->{'display_aspect_ratio'};
    $item{'sample_aspect_ratio'} = $r->{'item'}->{'sample_aspect_ratio'};

#warn "name=[$name]\n";
#warn "r->{'item'}->{'duration'}=" . $r->{'item'}->{'duration'} . "\n";
#warn "r->{'item'}->{'duration_v'}=" . $r->{'item'}->{'duration_v'} . "\n";
#warn "fps->[0]=[" . $fps->[0] . "], fps->[1]=[" . $fps->[1] . "]\n";
#warn "item{duration}=" . $item{'duration'} . "\n";

    return \%item;
};

sub load_asset
{
    my $r = 0;
    my ($filename) = @_;
    my %ATTRS;

    if(!open(INFILE, "<", $filename))
    {
        warn "load_asset: Failed to read file $filename\n";
        return undef;
    };

    while (<INFILE>)
    {
        chomp;

        $_ =~ s/\r//g;

        next unless ($_ =~ m/^([^:^ ^#]+)[: ]*(.*)/);

        $r++;

        if($1 eq "key")
        {
            my ($k, $v) = ($1, $2);

            if($v =~ m/^([^ ]+)[ ]*([^ ]+)$/)
            {
                my $keys;
                my @KEYS = ();

                if(defined($ATTRS{$k}))
                {
                    $keys = $ATTRS{$k};
                }
                else
                {
                    $ATTRS{$k} = \@KEYS;
                    $keys = \@KEYS;
                };

                push(@{$keys}, {OFFSET => $1, GEOM => $2});
            }
            else
            {
                warn sprintf("Unrecognized key [%s]\n", $v);
            };

        }
        elsif($1 eq "import" || $1 eq "offset")
        {
            my @list = split(' ', $2);
            $ATTRS{$1} = \@list;
        }
        else
        {
            $ATTRS{$1} = $2;
        };
    };

    close (INFILE);

    return undef if(0 == $r);

    return \%ATTRS;
};

sub readdir_rec
{
    my @ITEMS;
    my ($conf, $item) = @_;
    my $path = $conf->{'assets_path'} . '/' . $item;

    if(opendir(D, $path))
    {
        my @list = sort { $a <=> $b } readdir(D);
        closedir(D);

        foreach my $i (@list)
        {
            my $p = $path . '/' . $i;
            my $n = $item . '/' . $i;

            next if (($i eq '.') || ($i eq '..'));

            push(@ITEMS, (-d $p)?readdir_rec($conf, $n):$n);
        };
    };

    return @ITEMS;
};

sub expand_asset_group
{
    my @ITEMS = ();
    my ($conf, $item, $assets_counter) = @_;

    $assets_counter->{$item}++ if(defined($assets_counter->{$item}));
    $assets_counter->{$item} = 0 unless(defined($assets_counter->{$item}));

    my $filename = $conf->{'assets_path'} . '/' . $item;

    if(-d $filename)
    {
        my @I = readdir_rec($conf, $item);
#print "I=" . dump(\@I) . "\n";

        my @S = map
        {
            {
                'name'      => $item,
                'file'      => $_,
                'idx'       => $assets_counter->{$item},
            },
        } @I;
#print "S=" . dump(\@S) . "\n";

        push(@ITEMS, @S);
    }
    else
    {
        unless ('@' eq substr($item, 0, 1))
        {
            push
            (
                @ITEMS,
                {
                    'name'      => $item,
                    'file'      => $item,
                    'idx'       => $assets_counter->{$item},
                }
            );
        }
        else
        {
            if(!open(INFILE, "<", $filename))
            {
                warn "expand_asset_group: Failed to read file $filename\n";
            }
            else
            {
                while(<INFILE>)
                {
                    chomp;
                    push
                    (
                        @ITEMS,
                        {
                            'file'      => $_,
                            'name'      => $item,
                            'idx'       => $assets_counter->{$item},
                        }
                    );
                };

                close INFILE;
            };
        };
    };

    return @ITEMS;
};

sub build_template
{
    my ($conf, $clip_name, $clip_in, $clip_out, $assets_complex, $meta) = @_;

    my ($resource);

    # ask for clip first
    my $clip_data;
    unless($clip_name =~ /^\#(.*)/)
    {
        $clip_data = get_lib_item($conf->{'lib'}, $clip_name, $conf->{'fps'});
        unless($clip_data)
        {
            warn "failed to get_lib_item($clip_name)";
            return undef;
        };
        $resource = $clip_data->{'abs'};
    }
    else
    {
        $resource = $1;
    };

    # def clip in
    $clip_in = 0 unless defined($clip_in);

    # def clip out
    $clip_out = ($clip_data->{'duration'} - 1)
        if(!defined($clip_out) && defined($clip_data));
    $clip_out = ($clip_data->{'duration'} - 1)
        if(defined($clip_data) && defined($clip_data->{'duration'}) && $clip_out >= $clip_data->{'duration'});

    # calc dur of material
    my $clip_dur = $clip_out - $clip_in + 1;
#warn "clip_in=[$clip_in], clip_out=[$clip_out], clip_dur=[$clip_dur]\n";
    # open templats
    my $tmpl_main = HTML::Template->new_scalar_ref(\$tmpl_main_txt);
    $tmpl_main->param
    (
        resource        =>      $resource,
        CLIP_OUT        =>      $clip_out,
        CLIP_IN         =>      $clip_in,
    );

    # setup clip attrs
    # force aspect
    if(defined($meta->{'current.clip.ar'}))
    {
        if('*' eq $meta->{'current.clip.ar'})
        {
            my $display_aspect_ratio = $conf->{'display_aspect'}->[0] . ':' . $conf->{'display_aspect'}->[1];

            if($clip_data->{'display_aspect_ratio'} eq $display_aspect_ratio)
            {
                my $force_aspect_ratio = '@' . join('/', split(':', $clip_data->{'sample_aspect_ratio'}));

                $tmpl_main->param(force_aspect_ratio => $force_aspect_ratio);
            }
            else
            {
                $tmpl_main->param(force_aspect_ratio => $meta->{'TheCoreIO.mode_par'});
            };
        }
        elsif('PAL43' eq $meta->{'current.clip.ar'})
        {
            $tmpl_main->param(force_aspect_ratio => "\@16/15");
        }
        elsif('PAL169' eq $meta->{'current.clip.ar'})
        {
            $tmpl_main->param(force_aspect_ratio => "\@64/45");
        };
    };
    # progressive
    $tmpl_main->param(force_progressive => "yes")
        if(defined($meta->{'TheCoreIO.progressive'}) && '0' == $meta->{'TheCoreIO.progressive'});
    # audio amp
    $tmpl_main->param(audioamp_volume => $meta->{'current.clip.audio_amp'})
        if(defined($meta->{'current.clip.audio_amp'}));
    # audio mapping
    if(defined($meta->{'current.clip.audio_map'}))
    {
        $tmpl_main->param(audiomap_enable => 1);
        my @map = split('', $meta->{'current.clip.audio_map'});
        for(my $i = 0; $i < 8; $i++)
        {
            my $c = 0;
            if(defined($map[$i]))
            {
                # get char code
                $c = ord($map[$i]);

                # normalize
                if($c <= ord('9') && $c >= ord('0'))
                {
                    $c -= ord('0');
                }
                elsif($c <= ord('Z') && $c >= ord('A'))
                {
                    $c -= ord('A');
                    $c += 10;
                }
                else
                {
                    $c = 0;
                };
            };
            $tmpl_main->param(('audiomap_' . $i) => $c);
        };
    };

    # expand assets groups
    my %assets_counter;
    my @assets_mapped;
    foreach my $a (@{$assets_complex})
    {
        my @d = expand_asset_group($conf, $a, \%assets_counter);
        push(@assets_mapped, @d);
    };

    my $asset_idx = 0;
    my @ASSETS = ();
    foreach my $a_obj (@assets_mapped)
    {
#warn "";
        my $ASSET =
        {
            IDX                         => $asset_idx,
            PRODUCER_PROPERTIES         => [],
            PRODUCER_MATTE_PROPERTIES   => [],
            ENTRIES                     => [],
            TRANSITION_PROPERTIES       => [],
        };

        if ($asset_idx > 0)
        {
            $ASSET->{'PREV_IDX'} = ($asset_idx - 1);
            $ASSET->{'PREV_IDX_SET'} = 1;
        };

        my $a = load_asset($conf->{'assets_path'} . '/' . $a_obj->{'file'});
        next unless defined($a);

#warn "a_obj->{'file'}=" . $a_obj->{'file'} . "\n";

        # replace template vars
        for my $f (qw(text resource fgcolour))
        {
            # ignore not used fields
            next unless defined($a->{$f});

            foreach my $w (keys %{$meta})
            {
                my $t = $w;

                # check for modifier
                if($w =~ m/([^@]+)@([^#]+)$/)
                {
                    next unless($2 eq $a_obj->{'name'});
                    $t = $1;
                }
                elsif($w =~ m/([^@]+)@([^#]+)#(\d+)/)
                {
                    next unless(($2 eq $a_obj->{'name'}) && ($3 == $a_obj->{'idx'}));
                    $t = $1;
                };

                my $s = sprintf("<%s/>", $t);
                my $r = $meta->{$w};

                $a->{$f} =~ s/$s/$r/g;
            };

            # cleanup fields
            $a->{$f} =~ s/<([a-zA-Z0-9_.])+\/>//g;
        };

        # in
        $a->{'in'} = 0
            unless defined($a->{'in'});
        $a->{'in'} = $clip_dur + $a->{'in'}
            if($a->{'in'} < 0);
        $a->{'in'} = 0
            if($a->{'in'} >= $clip_dur || $a->{'in'} < 0);

        # other
        ($a->{'dur'} , $a->{'out'}) = ($clip_dur, $clip_out)
            unless(defined($a->{'out'}) || defined($a->{'dur'}));

#warn("[0] a->{'in'}=[" . $a->{'in'} . "] a->{'out'}=[" . $a->{'out'} . "] a->{'dur'}=[" . $a->{'dur'} . "]");

        # out
        $a->{'out'} = $a->{'in'} + $a->{'dur'} - 1
            if(!defined($a->{'out'}));
        $a->{'out'} = $clip_dur + $a->{'out'} - 1
            if(defined($a->{'out'}) && $a->{'out'} < 0);
        $a->{'out'} = $clip_dur - 1
            if($a->{'out'} >= $clip_dur);
        $a->{'out'} = 0
            if($a->{'out'} < 0);

#warn("[1] a->{'in'}=[" . $a->{'in'} . "] a->{'out'}=[" . $a->{'out'} . "] a->{'dur'}=[" . $a->{'dur'} . "]");

        # override in/out from metadata
        my ($p1_in, $p1_out, $p2_in, $p2_out) =
        (
            "current.meta.in\@" . $a_obj->{'name'} . "#" . $a_obj->{'idx'},
            "current.meta.out\@" . $a_obj->{'name'} . "#" . $a_obj->{'idx'},
            "current.meta.in\@" . $a_obj->{'name'},
            "current.meta.out\@" . $a_obj->{'name'}
        );
        if(defined($meta->{$p1_in}) && defined($meta->{$p1_out}))
        {
            $a->{'in'} = $meta->{$p1_in};
            $a->{'out'} = $meta->{$p1_out};
#warn("[U1] meta->{p1_in}=[" . $meta->{$p1_in} . "], meta->{p1_out}=[".$meta->{$p1_out}."]\n");
        }
        elsif(defined($meta->{$p2_in}) && defined($meta->{$p2_out}))
        {
            $a->{'in'} = $meta->{$p2_in};
            $a->{'out'} = $meta->{$p2_out};
#warn("[U2] meta->{p2_in}=[" . $meta->{$p2_in} . "], meta->{p2_out}=[" . $meta->{$p2_out} . "]\n");
        };

        # check for out trim
        $a->{'out'} = $clip_dur - 1
            if($a->{'out'} >= $clip_dur);

#warn("[2] a->{'in'}=[" . $a->{'in'} . "] a->{'out'}=[" . $a->{'out'} . "] a->{'dur'}=[" . $a->{'dur'} . "]");

        # dur
        $a->{'dur'} = $a->{'out'} - $a->{'in'} + 1;
#warn("[3] a->{'in'}=[" . $a->{'in'} . "] a->{'out'}=[" . $a->{'out'} . "] a->{'dur'}=[" . $a->{'dur'} . "]");

        # type processing
        if(defined($a->{'text'}))
        {
            $a->{'text_target'} = 'text' unless defined($a->{'text_target'});
            push(@{$ASSET->{'PRODUCER_PROPERTIES'}}, {NAME => 'text', VALUE => $a->{'text'}})
                if($a->{'text_target'} eq 'text');
            push(@{$ASSET->{'PRODUCER_PROPERTIES'}}, {NAME => 'markup', VALUE => $a->{'text'}})
                if($a->{'text_target'} eq 'markup');
            push(@{$ASSET->{'PRODUCER_PROPERTIES'}}, {NAME => 'resource', VALUE => $a->{'text'}})
                if($a->{'text_target'} eq 'file');

            foreach my $at
            (
                'size', 'align', 'pad',
                'bgcolour', 'fgcolour', 'olcolour', 'rotate',
                'width_fit', 'width_crop', 'wrap_width', 'wrap_type',
                'weight', 'stretch',
                'line_spacing',
                'family', 'style', 'outline'
            )
            {
                next unless defined($a->{$at});
                push
                (
                    @{$ASSET->{'PRODUCER_PROPERTIES'}},
                    {
                        NAME    => $at,
                        VALUE   => $a->{$at}
                    }
                );
            };
            push
            (
                @{$ASSET->{'PRODUCER_PROPERTIES'}},
#                {
#                    NAME    => 'force_aspect_ratio',
#                    VALUE   => $meta->{'TheCoreIO.mode_par'},
#                },
                {
                    NAME    => 'mlt_service',
                    VALUE   => 'pango'
                }
            );

            # very simple in/out
            push
            (
                @{$ASSET->{'ENTRIES'}},
                {
                    IDX     => $asset_idx,
                    IN      => 0,
                    OUT     => $a->{'dur'} - 1,
                }
            );

            # blanks
            $ASSET->{BLANK_IN} = $a->{'in'} if($a->{'in'} > 0);
            $ASSET->{BLANK_OUT} = ($clip_dur - $a->{'out'} - 1) if(($clip_dur - $a->{'out'} - 1) > 0);
        }
        elsif(defined($a->{'resource'}))
        {
            # resolve resorce
            my $asset_data = get_lib_item($conf->{'lib'}, $a->{'resource'}, $conf->{'fps'});
#warn "res=[" . $a->{'resource'} . "\n";

            $a->{'resource_behave'} = 0
                unless defined($a->{'resource_behave'});

            unless($asset_data)
            {
                warn "get_lib_item(" . $a->{'resource'} . ") is false, will try workaround\n";
                if($a->{'resource'} =~ /^!(.*)/)
                {
                    $asset_data = { 'abs' => $1 };
                    push(@{$ASSET->{'PRODUCER_PROPERTIES'}}, {NAME => 'live', VALUE => '1' });
                }
                elsif($a->{'resource'} =~ /^\#(.*)/)
                {
                    $asset_data = { 'abs' => $1 };
                };
            };

            # audio_index = -1
            push(@{$ASSET->{'PRODUCER_PROPERTIES'}}, { NAME    => 'audio_index', VALUE   => '-1' });
            push(@{$ASSET->{'PRODUCER_MATTE_PROPERTIES'}}, { NAME    => 'audio_index', VALUE   => '-1' })
                if(defined($a->{'resource_matte'}));

            foreach my $at ('force_aspect_ratio', 'audio_index')
            {
                next unless defined($a->{$at});
                push
                (
                    @{$ASSET->{'PRODUCER_PROPERTIES'}},
                    {
                        NAME    => $at,
                        VALUE   => $a->{$at}
                    }
                );
                push
                (
                    @{$ASSET->{'PRODUCER_MATTE_PROPERTIES'}},
                    {
                        NAME    => $at,
                        VALUE   => $a->{$at}
                    }
                ) if(defined($a->{'resource_matte'}));
            };

            push
            (
                @{$ASSET->{'PRODUCER_PROPERTIES'}},
                {
                    NAME    => 'force_aspect_ratio',
                    VALUE   => $meta->{'TheCoreIO.mode_par'},
                },
                {
                    NAME    => 'resource',
                    VALUE   => $asset_data->{'abs'}
                }
            );

            push
            (
                @{$ASSET->{'PRODUCER_PROPERTIES'}},
                {
                    NAME    => 'mlt_service',
                    VALUE   => 'hold'
                },
                {
                    NAME    => 'frame',
                    VALUE   => $a->{'resource_in'}
                }
            ) if('1' eq $a->{'resource_behave'});

            $ASSET->{'LOOPED'} = 1
                if('2' eq $a->{'resource_behave'});

            if(defined($a->{'resource_matte'}))
            {
                my $asset_matte_data = get_lib_item($conf->{'lib'}, $a->{'resource_matte'}, $conf->{'fps'});

                $ASSET->{'MATTE'} = 1;

                push
                (
                    @{$ASSET->{'PRODUCER_MATTE_PROPERTIES'}},
                    {
                        NAME    => 'resource',
                        VALUE   => $asset_matte_data->{'abs'}
                    },
                    {
                        NAME    => 'force_aspect_ratio',
                        VALUE   => $meta->{'TheCoreIO.mode_par'},
                    },
                ) if defined($asset_matte_data->{'abs'});

                push
                (
                    @{$ASSET->{'PRODUCER_MATTE_PROPERTIES'}},
                    {
                        NAME    => 'mlt_service',
                        VALUE   => 'hold'
                    },
                    {
                        NAME    => 'frame',
                        VALUE   => $a->{'resource_in'}
                    }
                ) if('1' eq $a->{'resource_behave'});
            };

            # blanks-in-out

            # single playback
            if('0' eq $a->{'resource_behave'})
            {
                my ($r_in, $r_out);

                $r_in = defined($a->{'resource_in'})?$a->{'resource_in'}:0;
                $r_out = $r_in + $a->{'dur'} - 1;
                $r_out = $a->{'resource_out'}
                    if(defined($a->{'resource_out'}) && $r_out > $a->{'resource_out'});

                # playback entry
                push
                (
                    @{$ASSET->{'ENTRIES'}},
                    {
                        IDX     => $asset_idx,
                        IN      => $r_in,
                        OUT     => $r_out,
                    }
                );

                $ASSET->{BLANK_OUT2} = ($a->{'dur'} - ($r_out - $r_in + 1))
                    if($a->{'dur'} > ($r_out - $r_in + 1));

                $ASSET->{BLANK_IN} = $a->{'in'}
                    if($a->{'in'} > 0);

                $ASSET->{BLANK_OUT} = ($clip_dur - $a->{'out'} - 1)
                    if(($clip_dur - $a->{'out'} - 1) > 0);
            }
            # still playback
            elsif('1' eq $a->{'resource_behave'})
            {
                # playback entry
                push
                (
                    @{$ASSET->{'ENTRIES'}},
                    {
                        IDX     => $asset_idx,
                        IN      => 0,
                        OUT     => $a->{'dur'} - 1,
                    }
                );
                # blanks
                $ASSET->{BLANK_IN} = $a->{'in'} if($a->{'in'} > 0);
                $ASSET->{BLANK_OUT} = ($clip_dur - $a->{'out'} - 1) if(($clip_dur - $a->{'out'} - 1) > 0);
            }
            # loop playback
            elsif('2' eq $a->{'resource_behave'})
            {
##                warn "asset_data->duration=" . $asset_data->{'duration'};

                if(defined($a->{'resource_in'}) || defined($a->{'resource_out'}))
                {
                    my $res_dur = $asset_data->{'duration'};

                    my $res_in = defined($a->{'resource_in'}) ? ($a->{'resource_in'}) : 0;
                    $res_in = 0 if ($res_dur <= $res_in);

                    my $res_out = defined($a->{'resource_out'}) ? ($a->{'resource_out'}) : ($res_dur - 1);
                    $res_out = ($res_dur - 1) if ($res_dur <= $res_out);

                    my $head_dur = $res_in;
                    my $tail_dur = $res_dur - $res_out;
                    my $area_dur = $a->{'out'} - $a->{'in'} + 1;

                    # head
                    if($head_dur > 0 && $head_dur <= $area_dur)
                    {
                        push
                        (
                            @{$ASSET->{'ENTRIES'}},
                            {
                                IDX     => $asset_idx,
                                IN      => 0,
                                OUT     => $res_in - 1,
                            }
                        );

                        $area_dur -= $head_dur;
                    };

                    # looppo
                    if($area_dur > 0)
                    {
                        my $loop_dur = ($area_dur > $tail_dur) ? ($area_dur - $tail_dur) : $area_dur;

                        push
                        (
                            @{$ASSET->{'ENTRIES'}},
                            {
                                IDX     => $asset_idx,
                                IN      => 0,
                                OUT     => $loop_dur - 1,
                                LOOPED  => 1,
                            }
                        );

                        $ASSET->{'LOOPED_IN'} = $res_in;
                        $ASSET->{'LOOPED_OUT'} = $res_out;

                        $area_dur -= $loop_dur;
                    };

                    # tail
                    if($tail_dur > 0 && $tail_dur <= $area_dur)
                    {
                        push
                        (
                            @{$ASSET->{'ENTRIES'}},
                            {
                                IDX     => $asset_idx,
                                IN      => $res_out + 1,
                                OUT     => $res_dur - 1,
                            }
                        );

                        $area_dur -= $head_dur;
                    };

                    # blanks
                    $ASSET->{BLANK_IN} = $a->{'in'} if($a->{'in'} > 0);
                    $ASSET->{BLANK_OUT} = ($clip_dur - $a->{'out'} - 1) if(($clip_dur - $a->{'out'} - 1) > 0);
                }
                else
                {
                    # playback entry
                    push
                    (
                        @{$ASSET->{'ENTRIES'}},
                        {
                            IDX     => $asset_idx,
                            IN      => 0,
                            OUT     => $a->{'dur'} - 1,
                            LOOPED  => 1,
                        }
                    );

                    # blanks
                    $ASSET->{BLANK_IN} = $a->{'in'} if($a->{'in'} > 0);
                    $ASSET->{BLANK_OUT} = ($clip_dur - $a->{'out'} - 1) if(($clip_dur - $a->{'out'} - 1) > 0);
                };
            }
            # unreal condition
            else
            {
                warn "Unreal condition";
            };
        }
        else
        {
            print "not used = " . dump($a) . "\n";
        };


        # tractor
        foreach my $at ('valign', 'halign', 'progressive', 'distort', 'crop', 'titles')
        {
            next unless defined($a->{$at});
            push
            (
                @{$ASSET->{'TRANSITION_PROPERTIES'}},
                {
                    NAME    => $at,
                    VALUE   => $a->{$at}
                }
            );
        };
        foreach my $k (@{$a->{'key'}})
        {
            my $kp;

            # resolve key
            if($k->{OFFSET} eq 'end')
            {
                $kp = $a->{'dur'} - 1;
            }
            elsif($k->{OFFSET} eq 'start')
            {
                $kp = 0;
            }
            elsif($k->{OFFSET} < 0)
            {
                $kp = $a->{'dur'} + $k->{OFFSET};
            }
            else
            {
                $kp = $k->{OFFSET};
            };

            # clip
            $kp = 0 if($kp < 0);
            $kp = ($a->{'dur'} - 1) if($kp >= $a->{'dur'});

            # store
            push
            (
                @{$ASSET->{'TRANSITION_PROPERTIES'}},
                {
                    NAME    => "key[$kp]",
                    VALUE   => $k->{GEOM},
                }
            );
        };
        $ASSET->{'TRANSITION_IN'} = $a->{'in'};
        $ASSET->{'TRANSITION_OUT'} = $a->{'out'};
        push(@ASSETS, $ASSET);
        $asset_idx++;
    };

    $tmpl_main->param
    (
        LIST          =>      \@ASSETS,
    );

    $tmpl_main->param
    (
        SHM             =>      \@SHM,
    );

    return $tmpl_main->output();
};

my $conf =
{
    'lib'               => 'localhost:8000',
    'assets_path'       => '/usr/local/src/2014-03-25/assets',
    'fps'               => [25, 1],
};

my $runtime =
{
    'assets'    =>      [],
    'metas'     =>      {},
};

print $0 . " \\\n";
foreach my $a (@ARGV)
{
    print "    " . $a . " \\\n";
};

GetOptions
(
    'config-lib=s'      =>      \$conf->{'lib'},
    'config-path=s'     =>      \$conf->{'assets_path'},
    'config-fps-num=i'  =>      \$conf->{'fps'}->[0],
    'config-fps-den=i'  =>      \$conf->{'fps'}->[1],
    'clip-name=s'       =>      \$runtime->{'clip'},
    'clip-in=i'         =>      \$runtime->{'in'},
    'clip-out=i'        =>      \$runtime->{'out'},
    'asset=s'           =>      sub{push @{$runtime->{'assets'}}, $_[1];},
    'meta=s%'           =>      sub{ $runtime->{'metas'}->{$_[1]} = $_[2];},
    'output-file=s'     =>      \$runtime->{'output'},
);

# update for fps accoring to mode
if(defined($runtime->{'metas'}->{'TheCoreIO.mode_name'}))
{
    my $m = $runtime->{'metas'}->{'TheCoreIO.mode_name'};
    if(($m eq 'atsc_720p_50') || ($m eq 'uhd_2160p_50'))
    {
        $conf->{'fps'}->[0] = 50;               # frame_rate_num=25
        $conf->{'fps'}->[1] = 1;                # frame_rate_den=1

        $conf->{'sample_aspect'}->[0] = 1;      # sample_aspect_num=1
        $conf->{'sample_aspect'}->[1] = 1;      # sample_aspect_den=1
        $conf->{'display_aspect'}->[0] = 16;    # display_aspect_num=16
        $conf->{'display_aspect'}->[1] = 9;     # display_aspect_den=9
    }
    elsif($m eq 'atsc_1080i_50')
    {
        $conf->{'sample_aspect'}->[0] = 1;      # sample_aspect_num=1
        $conf->{'sample_aspect'}->[1] = 1;      # sample_aspect_den=1
        $conf->{'display_aspect'}->[0] = 16;    # display_aspect_num=16
        $conf->{'display_aspect'}->[1] = 9;     # display_aspect_den=9
    }
    elsif($m eq 'dv_pal_wide')
    {
        $conf->{'sample_aspect'}->[0] = 64;     # sample_aspect_num=1
        $conf->{'sample_aspect'}->[1] = 45;     # sample_aspect_den=1
        $conf->{'display_aspect'}->[0] = 16;    # display_aspect_num=16
        $conf->{'display_aspect'}->[1] = 9;     # display_aspect_den=9
    }

};

my $r = build_template
(
    $conf,
    $runtime->{'clip'}, $runtime->{'in'}, $runtime->{'out'},
    $runtime->{'assets'},
    $runtime->{'metas'}
);

exit 1 unless defined($r);

if(!open(OUTFILE, ">", $runtime->{'output'}))
{
    warn "failed to create output file " . $runtime->{'output'} . "\n";
    exit 1;
};

print OUTFILE $r;

close OUTFILE;

#print dump($conf);
#print dump($runtime);
