function time_to_tc(v)
{
    var S = Math.floor(v);
    var F = Math.floor((v - S) / 0.04)

    if(F > 9)
        F = ':' + F;
    else
        F = ':0' + F;

    var H = Math.floor(S / 3600);
    S -= H * 3600;

    if(H < 10)
        H = '0' + H;

    var M = Math.floor(S / 60);
    S -= M * 60;
    if(M < 10)
        M = ':0' + M;
    else
        M = ':' + M;

    if(S < 10)
        S = ':0' + S;
    else
        S = ':' + S;

    return H + M + S + F;
};

function ev_seeked()
{
    console.log("seeked");

    $('#control_buttons').find('button.nav_ctl').each(function(index)
    {
        $(this).prop("disabled", false);
    });
};

function ev_seeking()
{
    console.log("seeking....");

    $('#control_buttons').find('button.nav_ctl').each(function(index)
    {
        $(this).prop("disabled", true);
    });
};

function ev_seektimeupdate()
{
    var video = document.getElementById('my-video');

    console.log("video.currentTime=" + video.currentTime + ", video.duration=" + video.duration);

    $("input.nav_times.nav_mark_curr").val(time_to_tc(video.currentTime)); // + " / " + time_to_tc(video.duration));
};

var h;

$(document).ready(function () {
    h = $(location).attr('hash');
    h = h.substring(1);

    console.log("Starting..." + h);

    if(Hls.isSupported())
    {
        var m3u8 = "/webcut2/hls/" + h + "/index.m3u8";
        var video = document.getElementById('my-video');
        var hls = new Hls();
        hls.loadSource(m3u8);
        hls.attachMedia(video);
        hls.on(Hls.Events.MANIFEST_PARSED, function()
        {
            $('#my-video').prop("volume", 0.1);

            video.addEventListener("timeupdate", ev_seektimeupdate, false);
            video.addEventListener("seeked", ev_seeked, false);
            video.addEventListener("seeking", ev_seeking, false);

            $('#download_buttons').delegate("button.nav_ctl", "click", function()
            {
                if($(this).hasClass('nav_mp4') || $(this).hasClass('nav_ts') || $(this).hasClass('nav_mp4_bump'))
                {
                    var mark_in = $("input.nav_times.nav_mark_in").attr("nav-time");
                    var mark_out = $("input.nav_times.nav_mark_out").attr("nav-time");
                    if(null != mark_in && "" != mark_in && null != mark_out && "" != mark_out)
                    {
                        $('#download_buttons').find("button.nav_ctl.nav_ts,button.nav_ctl.nav_mp4").prop("disabled", true);

                        var newWindow = window.open('', '_blank', 'width=750,height=500');

                        $.getJSON
                        (
                            'cut.php',
                            {
                                'mark_in'       : mark_in,
                                'mark_out'      : mark_out,
                                'format'        : ($(this).hasClass('nav_mp4') || $(this).hasClass('nav_mp4_bump'))?'mp4':'mpegts',
                                'bumper'        : $(this).hasClass('nav_mp4_bump') ? 1 : 0,
                                'id'            : h,
                            }
                        )
                        .done(function(resp)
                        {
                            console.log("resp:" + JSON.stringify(resp));

                            $('#download_buttons').find("button.nav_ctl.nav_ts,button.nav_ctl.nav_mp4").prop("disabled", false);

                            var trg = resp['target'];
                            console.log("trg:" + trg);
//                            window.open(trg, '_blank');
                            newWindow.location = trg;
                        });
                    };
                }
            });

            $('#control_buttons').delegate("button.nav_ctl", "click", function()
            {
                console.log("button clicked");

                if($(this).hasClass('nav_pause'))
                    video.pause();
                else if($(this).hasClass('nav_play'))
                    video.play();
                else if($(this).hasClass('nav_seek_m05'))
                    video.currentTime -= 0.2;
                else if($(this).hasClass('nav_seek_m1'))
                    video.currentTime -= 1.0;
                else if($(this).hasClass('nav_seek_m10'))
                    video.currentTime -= 10.0;
                else if($(this).hasClass('nav_seek_p05'))
                    video.currentTime += 0.2;
                else if($(this).hasClass('nav_seek_p1'))
                    video.currentTime += 1.0;
                else if($(this).hasClass('nav_seek_p10'))
                    video.currentTime += 10.0;
                else if($(this).hasClass('nav_goto_in'))
                {
                    var v = $("input.nav_times.nav_mark_in").attr("nav-time");
                    if(null != v && "" != v)
                        video.currentTime = v;
                }
                else if($(this).hasClass('nav_goto_out'))
                {
                    var v = $("input.nav_times.nav_mark_out").attr("nav-time");
                    if(null != v && "" != v)
                        video.currentTime = v;
                }
                else if($(this).hasClass('nav_mark_in'))
                {
                    var v = video.currentTime;
                    $("input.nav_times.nav_mark_in").attr("nav-time", v);
                    $("input.nav_times.nav_mark_in").val(time_to_tc(v));
                }
                else if($(this).hasClass('nav_mark_out'))
                {
                    var v = video.currentTime;
                    $("input.nav_times.nav_mark_out").attr("nav-time", v);
                    $("input.nav_times.nav_mark_out").val(time_to_tc(v));
                }
            });

        });
    }
});
