#!/bin/bash

/usr/local/enctools/bin/ffmpeg \
    -i BUMP_IN.mov \
\
    -map 0:v \
    -vf "format=pix_fmts=yuv420p,setdar=dar=16/9,hwupload_cuda,scale_npp=w=1920:h=1080:format=nv12:interp_algo=lanczos" \
    -vcodec h264_nvenc \
        -vb 3092k \
            -g 25 -keyint_min 25 \
            -minrate 2048k -maxrate 4096k \
            -level:v 41 -preset:v medium \
    -flags:v +global_header \
\
    -map 0:a \
    -acodec libfdk_aac -ab 128k -ac 2 -ar 48000 \
\
    -f mpegts \
\
    -y BUMP_IN.ts

/usr/local/enctools/bin/ffmpeg \
    -i BUMP_OUT.mov \
\
    -map 0:v \
    -vf "format=pix_fmts=yuv420p,setdar=dar=16/9,hwupload_cuda,scale_npp=w=1920:h=1080:format=nv12:interp_algo=lanczos" \
    -vcodec h264_nvenc \
        -vb 3092k \
            -g 25 -keyint_min 25 \
            -minrate 2048k -maxrate 4096k \
            -level:v 41 -preset:v medium \
    -flags:v +global_header \
\
    -map 0:a \
    -acodec libfdk_aac -ab 128k -ac 2 -ar 48000 \
\
    -f mpegts \
\
    -y BUMP_OUT.ts
