(function ($) {

$.fn.sizeChanged = function (handleFunction) {
    var element = this;
    var lastWidth = element.width();
    var lastHeight = element.height();

    setInterval(function () {
        if (lastWidth === element.width()&&lastHeight === element.height())
            return;
        if (typeof (handleFunction) == 'function') {
            handleFunction({ width: lastWidth, height: lastHeight },
                           { width: element.width(), height: element.height() });
            lastWidth = element.width();
            lastHeight = element.height();
        }
    }, 100);


    return element;
};

}(jQuery));


(function($) {

    var timings_steps =
    [
        {
            'step': 1,
            'tall': 0,
            'shrt': 10
        },
        {
            'step': 2,
            'tall': 0,
            'shrt': 2
        },
        {
            'step': 4,
            'tall': 0,
            'shrt': 4
        },
        {
            'step': 5,
            'tall': 0,
            'shrt': 5
        },
        {
            'step': 10,
            'tall': 0,
            'shrt': 10
        },
        {
            'step': 15,
            'tall': 0,
            'shrt': 3
        },
        {
            'step': 20,
            'tall': 2,
            'shrt': 2
        },
        {
            'step': 30,
            'tall': 3,
            'shrt': 2
        },
        {
            'step': 60,
            'tall': 0,
            'shrt': 4
        },
        {
            'step': 120,
            'tall': 2,
            'shrt': 2
        },
        {
            'step': 180,
            'tall': 0,
            'shrt': 3
        },
        {
            'step': 300,
            'tall': 0,
            'shrt': 5
        },
        {
            'step': 600,
            'tall': 0,
            'shrt': 10
        },
        {
            'step': 900,
            'tall': 0,
            'shrt': 3
        },
        {
            'step': 1800,
            'tall': 3,
            'shrt': 5
        },
        {
            'step': 3600,
            'tall': 0,
            'shrt': 6
        },
    ];

    var defaults =
    {
        padding_left: 40,
        padding_right: 40,
        padding_top: 10,
        timings_area_h: 20,
        rules_area_h: 20,
        thumbs_area_h: 60,
        timing_area_w: 100,
        seek_cb: null,
        thumb_url_cb: null,
        cont_region_rem_cb: null,
        last_seek: -1
    };

    function _cleanup(that)
    {
        // cleanup test content
        that.children().remove();
    };

    function _reset(that)
    {
        _cleanup(that);

        // setup zero width
        that.css({'width': '0px'});

        that.data('live_history_timeline').last_seek = -1;
    };

    function _scroll_happens(that)
    {
        _draw_timings(that);
        _draw_thumbs(that);
    };

    function _sec_to_hhmmss(sec)
    {
        var s = sec % 60; sec = (sec - s) / 60;
        var m = sec % 60; sec = (sec - m) / 60;
        var h = sec % 24; sec = (sec - h) / 24;
        var r =
            ("00" + h).slice(-2) + ":" +
            ("00" + m).slice(-2) + ":" +
            ("00" + s).slice(-2);

////        console.log("_sec_to_hhmmss: r=[" + r + "]");

        return r;
    };

    function _get_start_visible_time(that)
    {
        var padding_left = that.data('live_history_timeline').padding_left;
        var left_pos = parseInt(that.parent().scrollLeft());

        var t = left_pos - padding_left;

        if(t < 0)
            return 0;

        var px_per_sec = that.data('live_history_timeline').width / (24 * 3600);

        t /= px_per_sec;

        return t;
    };

    function _draw_thumbs(that)
    {
        var left_pos = parseInt(that.parent().scrollLeft());
        var width = parseInt(that.parent().css('width'));
        console.log("live_history_timeline:_draw_thumbs: scollLeft=[" + left_pos + "], width=[" + width + "]");

        // drop old timings
        that.find(".live_history_timeline_thumb_area").remove();

        var offset = -that.data('live_history_timeline').padding_left + parseInt(that.parent().scrollLeft());
        if(offset < 0)
            offset = 0;

        for(i = 0; i < width;)
        {
            var t = (offset + i) * (24 * 3600) / that.data('live_history_timeline').width;
            var url = that.data('live_history_timeline').thumb_url_cb(t);

            if(!url)
            {
                i += 1;
                continue;
            };

            var thumb = $("<div></div>");
            thumb.addClass("live_history_timeline_thumb_area");
            thumb.attr("original_bg_url", url);
            thumb.css
            ({
                'left':
                (
                    that.data('live_history_timeline').padding_left +
                    offset + i
                ) + 'px',
                'top':
                (
                    that.data('live_history_timeline').padding_top +
                    that.data('live_history_timeline').timings_area_h +
                    that.data('live_history_timeline').rules_area_h + 6
                ) + 'px',
                'background-image': 'url(' + url + ')',
            });
            thumb.appendTo(that);

            var w = parseInt(thumb.css('width'));

            /* check if we need to crop */
            var rem = that.data('live_history_timeline').cont_region_rem_cb(t);
            var len = rem * that.data('live_history_timeline').width / (24 * 3600);
            console.log('live_history_timeline: _draw_thumbs: t=' + t + ', rem=' + rem + ', len=' + len);
            if(w > len)
            {
                w = Math.round(len);
                thumb.css({'width' : w + 'px'});
            };
            if(!w) w = 1;

            i += w;
        };

    };

    function _draw_timings(that)
    {
        var timings_step, timings_cnt, timings_idx, i;
        var px_per_sec = that.data('live_history_timeline').width / (24 * 3600);
        var timing_area_w = that.data('live_history_timeline').timing_area_w;

        // find that scale dest used
        {
            for(i = 0; i < timings_steps.length; i++)
            {
                timings_step = timings_steps[i].step * px_per_sec;
                if(timings_step >= timing_area_w)
                    break;
            };
            timings_idx = i;
        }

////        console.log("live_history_timeline: _draw_timings: px_per_sec=[" + px_per_sec + "], idx=[" + i + "], timings_step=[" + timings_step + "]");

        // drop old timings
        that.find(".live_history_timeline_timing_area").remove();

        // draw timings text boxes
        var rules_points = [];
        var left_pos = parseInt(that.parent().scrollLeft());
        var parent_width = parseInt(that.parent().css('width'));

        i = Math.trunc(_get_start_visible_time(that) / timings_steps[timings_idx].step)
            * timings_steps[timings_idx].step;
        for(; i <= (24 * 3600); i += timings_steps[timings_idx].step)
        {
            var pos = i * px_per_sec;
            var offset = pos + that.data('live_history_timeline').padding_left - left_pos;
            var r = offset + timing_area_w, l = offset - timing_area_w;

////            console.log("live_history_timeline: _draw_timings: i=[" + i + "], pos=[" + pos + "], offset=[" + offset + "], l=[" + l + "], r=[" + r + "]");

            // check if timing in visible area
            if(r < 0)
                continue;

            // check if too right
            if(l > parent_width)
                break;

            var t = _sec_to_hhmmss(i);
////            console.log("live_history_timeline: _draw_timings: i=[" + i + "], t=[" + t + "]");

            var timing = $("<div></div>");
            timing.addClass("live_history_timeline_timing_area");
            timing.text(t);
            timing.attr("timing", i);
            timing.css
            ({
                'width': that.data('live_history_timeline').timing_area_w + 'px',
                'top': that.data('live_history_timeline').padding_top + 'px',
                'height': that.data('live_history_timeline').timings_area_h + 'px',
                'left':
                (
                    pos +
                    that.data('live_history_timeline').padding_left -
                    that.data('live_history_timeline').timing_area_w / 2
                ) + 'px',
            });
            timing.appendTo(that);

            rules_points.push
            ({
                'time': i,
                'pos': pos,
            });
        };

////        console.log("live_history_timeline: _draw_timings: rules_point=" + JSON.stringify(rules_points));

        // drop old rules
        that.find(".live_history_timeline_rule_area").remove();

        // draw rules
        for(i = 0; i < rules_points.length; i++)
        {
            var rule;

            rule = $("<div></div>");
            rule.addClass("live_history_timeline_rule_area");
            rule.css
            ({
                'top':
                (
                    that.data('live_history_timeline').padding_top +
                    that.data('live_history_timeline').timings_area_h
                ) + 'px',

                'height': that.data('live_history_timeline').rules_area_h + 'px',

                'left':
                (
                    rules_points[i].pos +
                    that.data('live_history_timeline').padding_left
                ) + 'px',
            });

            rule.appendTo(that);

            if(!i)
                continue;

            // draw long rules
            for(var j = 1; j < timings_steps[timings_idx].tall; j++)
            {
                var offset = Math.round(j * px_per_sec * timings_steps[timings_idx].step / timings_steps[timings_idx].tall);

                rule = $("<div></div>");
                rule.addClass("live_history_timeline_rule_area");
                rule.css
                ({
                    'top':
                    (
                        that.data('live_history_timeline').padding_top +
                        that.data('live_history_timeline').timings_area_h
                    ) + 'px',

                    'height': that.data('live_history_timeline').rules_area_h + 'px',

                    'left':
                    (
                        offset +
                        rules_points[i - 1].pos +
                        that.data('live_history_timeline').padding_left
                    ) + 'px',
                });
                rule.appendTo(that);
            };

            // draw short rules
            var shrt = timings_steps[timings_idx].shrt;
            if(timings_steps[timings_idx].tall)
                shrt *= timings_steps[timings_idx].tall;
            for(var j = 1; j < shrt; j++)
            {
                var offset = Math.round(j * px_per_sec * timings_steps[timings_idx].step / shrt);

                rule = $("<div></div>");
                rule.addClass("live_history_timeline_rule_area");
                rule.css
                ({
                    'top':
                    (
                        that.data('live_history_timeline').padding_top +
                        that.data('live_history_timeline').timings_area_h
                    ) + 'px',

                    'height': (that.data('live_history_timeline').rules_area_h / 2) + 'px',

                    'left':
                    (
                        offset +
                        rules_points[i - 1].pos +
                        that.data('live_history_timeline').padding_left
                    ) + 'px',
                });
                rule.appendTo(that);
            };
        };
    };

    function _scaling_changed(that, dir)
    {
        var R = 1.1;
        var timing_area_w = that.data('live_history_timeline').timing_area_w;
        var width = that.data('live_history_timeline').width;
        var width_mul = (dir < 0) ? 1.0/R : (dir > 0) ? R : 0;
        width *= width_mul;
        var px_per_sec = width / (24 * 3600);
        var timing_area_w_0 = timings_steps[0].step * px_per_sec;
        var timing_area_w_N = timings_steps[timings_steps.length - 1].step * px_per_sec;

////        console.log("_scaling_changed: dir=[" + dir +
////            "], width=[" + width + "], w_0=[" + timing_area_w_0 +
////            "], timing_area_w_N=[" + timing_area_w_N +
////            "], timing_area_w=[" + timing_area_w + "]");

        if(timing_area_w_N < timing_area_w)
            return;

        if(timing_area_w_0 * 2 > timing_area_w)
            return;

        that.data('live_history_timeline').width = width;

        _cleanup(that);
        _draw_background(that);
        _draw_timings(that);
        _draw_thumbs(that);

        var last_seek = that.data('live_history_timeline').last_seek;
        if(last_seek >= 0)
            _set_cursor_time(that, last_seek)
    };

    function _draw_background(that)
    {
        // set width of main container
        var w = that.data('live_history_timeline').padding_left
            + that.data('live_history_timeline').padding_right
            + that.data('live_history_timeline').width;
        console.log("live_history_timeline: setup: w=[" + w + "]");
        that.css({'width':  w + 'px'});

        // draw background
        var rules_area = $("<div></div>");
        rules_area.addClass("live_history_timeline_rules_area");
        rules_area.css
        ({
            'width' : that.data('live_history_timeline').width + 'px',
            'height' : that.data('live_history_timeline').rules_area_h + 'px',
            'left' : that.data('live_history_timeline').padding_left + 'px',
            'top' :
            (
                that.data('live_history_timeline').padding_top +
                that.data('live_history_timeline').timings_area_h
            ) + 'px',
        });
        rules_area.appendTo(that);

        var thumbs_area = $("<div></div>");
        thumbs_area.addClass("live_history_timeline_thumbs_area");
        thumbs_area.css
        ({
            'width' : that.data('live_history_timeline').width + 'px',
            'height' : that.data('live_history_timeline').thumbs_area_h + 'px',
            'left' : that.data('live_history_timeline').padding_left + 'px',
            'top' :
            (
                that.data('live_history_timeline').padding_top +
                that.data('live_history_timeline').timings_area_h +
                that.data('live_history_timeline').rules_area_h
            ) + 'px',
        });
        thumbs_area.appendTo(that);

        var thumb_area = $("<div></div>");
        thumb_area.addClass("live_history_timeline_thumb_prv");
        thumb_area.hide();
        thumb_area.appendTo(that);
        thumb_area.css({'top' : '100px', 'left' : '100px'});

        thumbs_area.on('mouseenter', function(ev) {
////            console.log('MOUSE ENTER');
            thumb_area.show();
        });
        thumbs_area.on('mouseleave', function(ev) {
////            console.log('MOUSE LEAVE');
            thumb_area.hide();
        });
        thumbs_area.on('mousemove', function(ev) {

            var parentOffset = $(this).parent().offset();
            var Offset = $(this).offset();
            var posX = ev.pageX - parentOffset.left + 20,
                posY = ev.pageY - parentOffset.top - 40,
                relX = ev.pageX - Offset.left;

////            console.log('MOUSE MOVE: relX=' + relX);

            thumb_area.css
            ({
                'left' : posX + 'px',
                'top' : posY + 'px'
            });

            var t = relX * (24 * 3600) / that.data('live_history_timeline').width;
            var url = that.data('live_history_timeline').thumb_url_cb(t);

            if(url)
                thumb_area.css({'background-image': 'url(' + url + ')', 'background-repeat': 'no-repeat'});
            else
                thumb_area.css({'background-image': ''});

            {
                var sec = Math.trunc(t);

                var ms = ("000" + Math.trunc((t - sec) * 10)).slice(-1);
                var ss = sec % 60; sec = Math.trunc(sec / 60);
                var mm = sec % 60; sec = Math.trunc(sec / 60);
                var hh = sec % 24;

                t =
                    ("00" + hh).slice(-2) + ":" +
                    ("00" + mm).slice(-2) + ":" +
                    ("00" + ss).slice(-2) + "." + ms;
            };

            thumb_area.text(t);
        });
    };

    function _get_cursor_time(that)
    {
        if(that.find('.live_history_timeline_cursor_body')[0] === undefined)
            return -1;

        var cursor_body = that.find('.live_history_timeline_cursor_body').first();
        var left = cursor_body.css('left');
        var width = cursor_body.css('width');
        var px_per_sec = that.data('live_history_timeline').width / (24 * 3600);

        var r = left + cursor_width / 2 - that.data('live_history_timeline').padding_left;

        r /= px_per_sec;

        return r;
    };

    function _seek_cb(that, t)
    {
        if(!that.data('live_history_timeline').seek_cb)
            return;

        that.data('live_history_timeline').seek_cb(t);
    };

    function _set_cursor_time(that, sec)
    {
        var cursor_drag, cursor_body;

        if(that.find('.live_history_timeline_cursor_body')[0] === undefined)
        {
            cursor_body = $('<div class="live_history_timeline_cursor_body"></div>');
            cursor_body.appendTo(that);
            cursor_drag = $('<div class="live_history_timeline_cursor_drag"></div>');
            cursor_drag.appendTo(that);

            cursor_drag.on('mousedown', function(e)
            {
                console.log('drag start:' + e);
                that.data('live_history_timeline').dragging = true;
            });
        };

        cursor_body = that.find('.live_history_timeline_cursor_body').first();
        cursor_drag = that.find('.live_history_timeline_cursor_drag').first();

        var px_per_sec = that.data('live_history_timeline').width / (24 * 3600);
        var cursor_width = parseInt(cursor_body.css('width'));
        var left = Math.round(that.data('live_history_timeline').padding_left +
            px_per_sec * sec - cursor_width / 2);

        cursor_body.css
        ({
            'left': left + 'px',

            'top':
            (
                that.data('live_history_timeline').padding_top +
                that.data('live_history_timeline').timings_area_h
            ) + 'px',

            'height':
            (
                that.data('live_history_timeline').rules_area_h +
                that.data('live_history_timeline').thumbs_area_h
            ) + 'px',
        });

        cursor_drag.css
        ({
            'left': left + 'px',

            'top':
            (
                that.data('live_history_timeline').padding_top +
                that.data('live_history_timeline').timings_area_h
            ) + 'px',

            'height':
            (
                that.data('live_history_timeline').rules_area_h
            ) + 'px',
        });

        var left_pos = parseInt(that.parent().scrollLeft());
        var width = parseInt(that.parent().css('width'));
        var scrl;

        if(left < left_pos)
        {
            console.log('need to scroll LEFT');

            scrl = left - width / 16;
        }
        else if(left > left_pos + width)
        {
            console.log('need to scroll RIGHT');
            scrl = left - width / 16;
        };

        if(scrl !== undefined)
        {
            console.log('scroll update to ' + scrl);
            that.parent().scrollLeft(scrl);
        };

    };

    var methods =
    {
        init : function(options)
        {
            return this.each(function()
            {
                var that = $(this);
                var data = that.data('live_history_timeline');
                if(!data )
                {
                    data = $.extend({}, defaults, options);
                    that.data('live_history_timeline', data);
                };

                _reset(that);

                // calculate initial width
                that.data('live_history_timeline').width =
                that.data('live_history_timeline').timing_area_w
                    * 24 * 3600 / timings_steps[ timings_steps.length - 1 ].step;

                // scroll handler
                that.parent().scroll(function() { _scroll_happens(that); } );
                that.parent().sizeChanged(function() { _scroll_happens(that); } );
                that.bind('mousewheel', function(ev) {
////                    console.log('wheel shiftKey=: ' + ev.shiftKey);
                    if(!ev.shiftKey)
                    {
////                        console.log('wheel:  ev.originalEvent.wheelDelta=' + ev.originalEvent.wheelDelta);
                        _scaling_changed(that, ev.originalEvent.wheelDelta);
                        ev.preventDefault();
                        return true;
                    };
                });

                that.on('mousedown', function(ev)
                {
                    var parentOffset = that.offset();
                    var relX = (ev.pageX - parentOffset.left);

                    relX -= that.data('live_history_timeline').padding_left;
                    if(relX < 0)
                        relX = 0;
                    else if(relX >= that.data('live_history_timeline').width)
                        relX = 24 * 3600 - 1;
                    else
                        relX = (relX * 24 * 3600) / that.data('live_history_timeline').width

                    _seek_cb(that, relX);
                });

                $(window).on('mouseup', function(ev)
                {
                    var data = that.data('live_history_timeline');
                    if(data && data.dragging)
                    {
                        data.dragging = false;
                        console.log('drag end:' + ev);
                        ev.preventDefault();

                        var last_seek = that.data('live_history_timeline').last_seek;
                        if(last_seek >= 0)
                            _set_cursor_time(that, last_seek)

                        return true;
                    };
                });

                that.on('mousemove', function(ev)
                {
                    if(that.data('live_history_timeline').dragging)
                    {
                        var parentOffset = that.offset();
                        var relX = (ev.pageX - parentOffset.left);

////                        console.log('drag move: relX=' + relX + ' px');

                        relX -= that.data('live_history_timeline').padding_left;
                        if(relX < 0)
                            relX = 0;
                        else if(relX >= that.data('live_history_timeline').width)
                            relX = 24 * 3600 - 1;
                        else
                            relX = (relX * 24 * 3600) / that.data('live_history_timeline').width

////                        console.log('drag move: relX=' + relX + ' sec');

                        _set_cursor_time(that, relX);
                        _seek_cb(that, relX);
                        ev.preventDefault();
                        return true;
                    };
                });

                console.log('live_history_timeline: init done!');
            });
        },

        seek_to : function(sec)
        {
            var that = $(this);

            return this.each(function()
            {
                that.data('live_history_timeline').last_seek = sec;
                if(!that.data('live_history_timeline').dragging)
                    _set_cursor_time(that, sec);
            })
        },


        reset : function()
        {
            var that = $(this);

            return this.each(function()
            {
                _reset(that);
            })
        },

        destroy : function()
        {
            return this.each(function()
            {
                // cleanup test content
                $(this).removeData('live_history_timeline');
            })
        },

        setup : function()
        {
            var that = $(this);

            return this.each(function()
            {
                console.log("live_history_timeline: setup");

                // cleanup
                _cleanup(that);
                _draw_background(that)
                _draw_timings(that);
                _draw_thumbs(that);
            });
        },

    };

    $.fn.live_history_timeline = function(method)
    {
        if (typeof method === 'object' || !method)
        {
            return methods.init.apply(this, arguments);
        }
        else if(methods[method])
        {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        }
        else
        {
            $.error("Method [" + method + "] not found for live_history_timeline");
        }
    };

})(jQuery);
